/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.aop;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.cache.aop.CachedAttribute;

public class CachedType {
    protected static Set immediates = new HashSet<Object>(Arrays.asList(class$java$lang$String == null ? (class$java$lang$String = CachedType.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = CachedType.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Double == null ? (class$java$lang$Double = CachedType.class$("java.lang.Double")) : class$java$lang$Double, class$java$lang$Float == null ? (class$java$lang$Float = CachedType.class$("java.lang.Float")) : class$java$lang$Float, class$java$lang$Integer == null ? (class$java$lang$Integer = CachedType.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$Long == null ? (class$java$lang$Long = CachedType.class$("java.lang.Long")) : class$java$lang$Long, class$java$lang$Short == null ? (class$java$lang$Short = CachedType.class$("java.lang.Short")) : class$java$lang$Short, class$java$lang$Character == null ? (class$java$lang$Character = CachedType.class$("java.lang.Character")) : class$java$lang$Character, Boolean.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, Character.TYPE, class$java$lang$Class == null ? (class$java$lang$Class = CachedType.class$("java.lang.Class")) : class$java$lang$Class));
    protected Class type;
    protected boolean immutable;
    protected boolean immediate;
    protected List attributes = new ArrayList();
    protected Map attributeMap = new HashMap();
    protected List fields = new ArrayList();
    protected Map fieldMap = new HashMap();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Class;

    public CachedType() {
    }

    public CachedType(Class type) {
        this.type = type;
        this.analyze();
    }

    public Class getType() {
        return this.type;
    }

    public boolean isImmediate() {
        return this.immediate;
    }

    public static boolean isImmediate(Class clazz) {
        return immediates.contains(clazz);
    }

    public boolean isImmutable() {
        return this.immutable;
    }

    public List getFields() {
        return this.fields;
    }

    public Field getField(String name) {
        return (Field)this.fieldMap.get(name);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.type.getName()).append(" {\n");
        Iterator i = this.attributes.iterator();
        while (i.hasNext()) {
            CachedAttribute attr = (CachedAttribute)i.next();
            sb.append("\t").append(attr.getType().getName()).append(" ").append(attr.getName()).append(" [").append(attr.getGet() == null ? "<no get>" : attr.getGet().getName()).append(", ").append(attr.getSet() == null ? "<no set>" : attr.getSet().getName()).append("]\n");
        }
        sb.append("}, immutable =" + this.immutable);
        return sb.toString();
    }

    private void analyze() {
        this.analyzeFields(this.type);
        this.immediate = CachedType.isImmediate(this.type);
    }

    void analyzeFields(Class clazz) {
        if (clazz == null) {
            return;
        }
        this.analyzeFields(clazz.getSuperclass());
        Field[] classFields = clazz.getDeclaredFields();
        int i = 0;
        while (i < classFields.length) {
            Field f = classFields[i];
            if (!CachedType.isNonReplicatable(f)) {
                f.setAccessible(true);
                this.fields.add(f);
                this.fieldMap.put(f.getName(), f);
            }
            ++i;
        }
    }

    public static boolean isNonReplicatable(Field f) {
        int mods = f.getModifiers();
        return Modifier.isStatic(mods) || Modifier.isTransient(mods) || Modifier.isFinal(mods);
    }

    protected String attributeName(String methodName) {
        return methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
    }

    protected CachedAttribute getAttribute(Method method, Map map, boolean create) {
        String name = this.attributeName(method.getName());
        CachedAttribute attribute = (CachedAttribute)map.get(name);
        if (create && attribute == null) {
            attribute = new CachedAttribute(name);
            map.put(name, attribute);
        }
        return attribute;
    }

    protected boolean isGet(Method method) {
        return method.getName().startsWith("get") && method.getParameterTypes().length == 0 && method.getReturnType() != Void.TYPE;
    }

    protected boolean isSet(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1 && method.getReturnType() == Void.TYPE;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

