/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache;

import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.cache.ConfigureException;
import org.jboss.cache.TreeCache;
import org.jboss.util.propertyeditor.PropertyEditors;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PropertyConfigurator {
    private static Log logger_ = LogFactory.getLog((Class)(class$org$jboss$cache$PropertyConfigurator == null ? (class$org$jboss$cache$PropertyConfigurator = PropertyConfigurator.class$("org.jboss.cache.PropertyConfigurator")) : class$org$jboss$cache$PropertyConfigurator));
    private Object objToConfigure_;
    private static final String ROOT = "mbean";
    private static final String ATTR = "attribute";
    private static final String SUB_ATTR = "config";
    private static final String NAME = "name";
    static /* synthetic */ Class class$org$jboss$cache$PropertyConfigurator;
    static /* synthetic */ Class class$java$lang$String;

    public PropertyConfigurator() {
        try {
            Class<?> clasz = Class.forName("org.w3c.dom.Element");
            Class<?> elementClasz = Class.forName("org.jboss.util.propertyeditor.ElementEditor");
            try {
                PropertyEditor editor = PropertyEditors.getEditor(clasz);
                logger_.info((Object)("Found existing property editor for org.w3c.dom.Element: " + editor));
            }
            catch (RuntimeException ex) {
                logger_.info((Object)"Property editor for org.w3c.dom.Element does not exist. Will register org.jboss.util.propertyeditor.ElementEditor");
                PropertyEditors.registerEditor(clasz, elementClasz);
            }
        }
        catch (ClassNotFoundException ex) {
            logger_.error((Object)"Class not found for either org.w3c.dom.Element or org.jboss.util.propertyeditor.ElementEditor");
        }
    }

    protected Element loadDocument(String location) throws ConfigureException {
        URL url = null;
        try {
            url = new URL("file", "", 80, location);
            logger_.debug((Object)("URL location is " + url.toString()));
            return this.loadDocument(url.openStream());
        }
        catch (MalformedURLException mfx) {
            logger_.error((Object)("Configurator error: " + mfx));
            mfx.printStackTrace();
        }
        catch (IOException e) {
            logger_.error((Object)("Configurator error: " + e));
            e.printStackTrace();
        }
        return null;
    }

    protected Element loadDocument(InputStream is) throws ConfigureException {
        Document doc = null;
        try {
            InputSource xmlInp = new InputSource(is);
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = docBuilderFactory.newDocumentBuilder();
            doc = parser.parse(xmlInp);
            Element root = doc.getDocumentElement();
            root.normalize();
            return root;
        }
        catch (SAXParseException err) {
            logger_.error((Object)("Configurator SAXParse error: " + err.getMessage()));
            err.printStackTrace();
        }
        catch (SAXException e) {
            logger_.error((Object)("Configurator SAX error: " + e));
            e.printStackTrace();
        }
        catch (Exception pce) {
            logger_.error((Object)("Configurator general error: " + pce));
            pce.printStackTrace();
        }
        return null;
    }

    protected Element getMBeanElement(Element root) throws ConfigureException {
        NodeList list = root.getElementsByTagName(ROOT);
        if (list == null) {
            throw new ConfigureException("Can't find mbean tag");
        }
        if (list.getLength() > 1) {
            throw new ConfigureException("Has multiple mbean tag");
        }
        Node node = list.item(0);
        Element element = null;
        if (node.getNodeType() != 1) {
            throw new ConfigureException("Can't find mbean element");
        }
        element = (Element)node;
        return element;
    }

    public void configure(Object objToConfigure, String configFile) throws ConfigureException {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream(configFile);
        if (is == null) {
            try {
                is = new FileInputStream(configFile);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (is == null) {
            throw new ConfigureException("could not find resource " + configFile);
        }
        this.configure(objToConfigure, is);
    }

    public void configure(Object objToConfigure, InputStream is) throws ConfigureException {
        this.objToConfigure_ = objToConfigure;
        if (is == null) {
            throw new ConfigureException("configure(): input stream is null for property xml");
        }
        Element root = this.loadDocument(is);
        Element mbeanElement = this.getMBeanElement(root);
        NodeList list = mbeanElement.getElementsByTagName(ATTR);
        logger_.info((Object)("configure(): attribute size: " + list.getLength()));
        Class<?> objClass = this.objToConfigure_.getClass();
        Method[] methods = objClass.getMethods();
        Class[] string_sig = new Class[]{class$java$lang$String == null ? (class$java$lang$String = PropertyConfigurator.class$("java.lang.String")) : class$java$lang$String};
        int loop = 0;
        while (loop < list.getLength()) {
            Node node = list.item(loop);
            if (node.getNodeType() == 1) {
                Element element = (Element)node;
                String name = element.getAttribute(NAME);
                String valueStr = this.getElementContent(element, true);
                Element valueObj = null;
                if (valueStr.length() == 0) {
                    valueObj = this.getSubElementObject(element);
                }
                String methodName = "set" + name;
                Object value = null;
                Method method = null;
                try {
                    method = objClass.getMethod(methodName, string_sig);
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (method != null) {
                    try {
                        Object[] args = new Object[]{valueStr};
                        logger_.debug((Object)("setting attribute " + name + " to " + valueStr));
                        method.invoke(this.objToConfigure_, valueStr);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        throw new ConfigureException("configure(): can't invoke " + methodName + " to configure " + "TreeCache properties. Exception: " + ex);
                    }
                }
                int i = 0;
                while (i < methods.length) {
                    if (methodName.equals(methods[i].getName())) {
                        method = methods[i];
                        Class<?>[] clz = method.getParameterTypes();
                        if (clz.length != 1) {
                            throw new ConfigureException("Parameter size of " + methodName + " is not 1 but " + clz.length);
                        }
                        Class<?> classParam = clz[0];
                        PropertyEditor editor = PropertyEditorManager.findEditor(classParam);
                        if (editor == null) {
                            String str = "Could not find PropertyEditor for type class " + classParam;
                            throw new ConfigureException(str);
                        }
                        if (valueObj != null) {
                            editor.setValue(valueObj);
                        } else {
                            editor.setAsText(valueStr);
                        }
                        value = editor.getValue();
                        logger_.debug((Object)("Invoking setter method: " + method + " with parameter \"" + value + "\" of type " + value.getClass()));
                        try {
                            method.invoke(this.objToConfigure_, value);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            throw new ConfigureException("configure(): Can't invoke set method to configure TreeCache properties. Method name: " + methodName + " exception: " + ex);
                        }
                    }
                    ++i;
                }
            }
            ++loop;
        }
    }

    private Element getSubElementObject(Element element) throws ConfigureException {
        NodeList nl = element.getChildNodes();
        int i = 0;
        while (i < nl.getLength()) {
            Node node = nl.item(i);
            if (node.getNodeType() == 1 && SUB_ATTR.equals(((Element)node).getTagName())) {
                return (Element)node;
            }
            ++i;
        }
        logger_.debug((Object)"getSubElementObject(): element object. Does not exist for config");
        return null;
    }

    private String getElementContent(Element element, boolean trim) throws ConfigureException {
        NodeList nl = element.getChildNodes();
        String attributeText = "";
        int i = 0;
        while (i < nl.getLength()) {
            Node n = nl.item(i);
            if (n instanceof Text) {
                attributeText = attributeText + ((Text)n).getData();
            }
            ++i;
        }
        if (trim) {
            attributeText = attributeText.trim();
        }
        return attributeText;
    }

    public static void main(String[] args) {
        try {
            TreeCache cache = new TreeCache();
            PropertyConfigurator config = new PropertyConfigurator();
            config.configure((Object)cache, "tree-cache.xml");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

