/*
 * Decompiled with CFR 0.152.
 */
package edu.emory.mathcs.backport.java.util.concurrent;

import edu.emory.mathcs.backport.java.util.AbstractQueue;
import edu.emory.mathcs.backport.java.util.concurrent.BlockingQueue;
import edu.emory.mathcs.backport.java.util.concurrent.TimeUnit;
import edu.emory.mathcs.backport.java.util.concurrent.helpers.Utils;
import edu.emory.mathcs.backport.java.util.concurrent.locks.Condition;
import edu.emory.mathcs.backport.java.util.concurrent.locks.ReentrantLock;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ArrayBlockingQueue
extends AbstractQueue
implements BlockingQueue,
Serializable {
    private static final long serialVersionUID = -817911632652898426L;
    private final Object[] items;
    private transient int takeIndex;
    private transient int putIndex;
    private int count;
    private final ReentrantLock lock;
    private final Condition notEmpty;
    private final Condition notFull;

    final int inc(int i) {
        int n = 0;
        if (++i != this.items.length) {
            n = i;
        }
        return n;
    }

    private final void insert(Object x) {
        this.items[this.putIndex] = x;
        this.putIndex = this.inc(this.putIndex);
        ++this.count;
        this.notEmpty.signal();
    }

    private final Object extract() {
        Object[] items = this.items;
        Object x = items[this.takeIndex];
        items[this.takeIndex] = null;
        this.takeIndex = this.inc(this.takeIndex);
        --this.count;
        this.notFull.signal();
        return x;
    }

    void removeAt(int i) {
        Object[] items = this.items;
        if (i == this.takeIndex) {
            items[this.takeIndex] = null;
            this.takeIndex = this.inc(this.takeIndex);
        } else {
            int nexti;
            while ((nexti = this.inc(i)) != this.putIndex) {
                items[i] = items[nexti];
                i = nexti;
            }
            items[i] = null;
            this.putIndex = i;
        }
        --this.count;
        this.notFull.signal();
    }

    public boolean add(Object e) {
        return super.add(e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean offer(Object e) {
        ReentrantLock lock;
        block4: {
            if (e == null) {
                throw new NullPointerException();
            }
            lock = this.lock;
            lock.lock();
            try {
                if (this.count != this.items.length) break block4;
                boolean bl = false;
                Object var4_5 = null;
                lock.unlock();
                return bl;
            }
            catch (Throwable throwable) {
                Object var4_7 = null;
                lock.unlock();
                throw throwable;
            }
        }
        this.insert(e);
        boolean bl = true;
        Object var4_6 = null;
        lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void put(Object e) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            try {
                while (this.count == items.length) {
                    this.notFull.await();
                }
            }
            catch (InterruptedException ie) {
                this.notFull.signal();
                throw ie;
            }
            this.insert(e);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            lock.unlock();
            throw throwable;
        }
        {
            Object var5_7 = null;
            lock.unlock();
            return;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean offer(Object e, long timeout, TimeUnit unit) throws InterruptedException {
        if (e == null) {
            throw new NullPointerException();
        }
        nanos = unit.toNanos(timeout);
        lock = this.lock;
        lock.lockInterruptibly();
        try {
            deadline = Utils.nanoTime() + nanos;
            while (true) lbl-1000:
            // 2 sources

            {
                if (this.count == this.items.length) ** break block8
                this.insert(e);
                var10_7 = true;
                var9_9 = null;
                lock.unlock();
                return var10_7;
            }
        }
        catch (Throwable var8_13) {
            var9_11 = null;
            lock.unlock();
            throw var8_13;
        }
        {
            block9: {
                if (nanos > 0L) break block9;
                var10_8 = false;
                var9_10 = null;
                lock.unlock();
                return var10_8;
            }
            try {
                this.notFull.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
                continue;
            }
            catch (InterruptedException ie) {
                this.notFull.signal();
                throw ie;
            }
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object poll() {
        Object x;
        ReentrantLock lock;
        block3: {
            lock = this.lock;
            lock.lock();
            try {
                if (this.count != 0) break block3;
                Object var4_2 = null;
                Object var3_4 = null;
                lock.unlock();
                return var4_2;
            }
            catch (Throwable throwable) {
                Object var3_6 = null;
                lock.unlock();
                throw throwable;
            }
        }
        Object object = x = this.extract();
        Object var3_5 = null;
        lock.unlock();
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object take() throws InterruptedException {
        ReentrantLock lock = this.lock;
        lock.lockInterruptibly();
        try {
            Object x;
            try {
                while (this.count == 0) {
                    this.notEmpty.await();
                }
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            Object object = x = this.extract();
            Object var3_5 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var3_6 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     */
    public Object poll(long timeout, TimeUnit unit) throws InterruptedException {
        nanos = unit.toNanos(timeout);
        lock = this.lock;
        lock.lockInterruptibly();
        try {
            deadline = Utils.nanoTime() + nanos;
            while (true) lbl-1000:
            // 2 sources

            {
                if (this.count == 0) ** break block7
                var9_8 = x = this.extract();
                var8_10 = null;
                lock.unlock();
                return var9_8;
            }
        }
        catch (Throwable var7_13) {
            var8_12 = null;
            lock.unlock();
            throw var7_13;
        }
        {
            block8: {
                if (nanos > 0L) break block8;
                var9_9 = null;
                var8_11 = null;
                lock.unlock();
                return var9_9;
            }
            try {
                this.notEmpty.await(nanos, TimeUnit.NANOSECONDS);
                nanos = deadline - Utils.nanoTime();
                continue;
            }
            catch (InterruptedException ie) {
                this.notEmpty.signal();
                throw ie;
            }
            ** while (true)
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object peek() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object object = this.count == 0 ? null : this.items[this.takeIndex];
            Object var3_3 = null;
            lock.unlock();
            return object;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.count;
            Object var3_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remainingCapacity() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int n = this.items.length - this.count;
            Object var3_3 = null;
            lock.unlock();
            return n;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean remove(Object o) {
        boolean bl;
        if (o == null) {
            return false;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (true) {
                if (k++ >= this.count) {
                    boolean bl2 = false;
                    Object var5_8 = null;
                    lock.unlock();
                    return bl2;
                }
                if (o.equals(items[i])) {
                    this.removeAt(i);
                    bl = true;
                    break;
                }
                i = this.inc(i);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            lock.unlock();
            throw throwable;
        }
        Object var5_9 = null;
        lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean contains(Object o) {
        boolean bl;
        if (o == null) {
            return false;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = 0;
            while (true) {
                if (k++ >= this.count) {
                    bl = false;
                    break;
                }
                if (o.equals(items[i])) {
                    boolean bl2 = true;
                    Object var5_8 = null;
                    lock.unlock();
                    return bl2;
                }
                i = this.inc(i);
            }
        }
        catch (Throwable throwable) {
            Object var5_10 = null;
            lock.unlock();
            throw throwable;
        }
        Object var5_9 = null;
        lock.unlock();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray() {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Object[] a = new Object[this.count];
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                a[k++] = items[i];
                i = this.inc(i);
            }
            Object[] objectArray = a;
            Object var4_7 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            if (a.length < this.count) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), this.count);
            }
            int k = 0;
            int i = this.takeIndex;
            while (k < this.count) {
                a[k++] = items[i];
                i = this.inc(i);
            }
            if (a.length > this.count) {
                a[this.count] = null;
            }
            Object[] objectArray = a;
            Object var5_7 = null;
            lock.unlock();
            return objectArray;
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            String string = super.toString();
            Object var3_3 = null;
            lock.unlock();
            return string;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clear() {
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int k = this.count;
            while (true) {
                block4: {
                    if (k-- > 0) break block4;
                    this.count = 0;
                    this.putIndex = 0;
                    this.takeIndex = 0;
                    this.notFull.signalAll();
                    break;
                }
                items[i] = null;
                i = this.inc(i);
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            lock.unlock();
            throw throwable;
        }
        {
            Object var4_7 = null;
            lock.unlock();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int n = 0;
            int max = this.count;
            while (n < max) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
                ++n;
            }
            if (n > 0) {
                this.count = 0;
                this.putIndex = 0;
                this.takeIndex = 0;
                this.notFull.signalAll();
            }
            int n2 = n;
            Object var5_8 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int drainTo(Collection c, int maxElements) {
        if (c == null) {
            throw new NullPointerException();
        }
        if (c == this) {
            throw new IllegalArgumentException();
        }
        if (maxElements <= 0) {
            return 0;
        }
        Object[] items = this.items;
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            int i = this.takeIndex;
            int n = 0;
            int sz = this.count;
            int max = maxElements < this.count ? maxElements : this.count;
            while (n < max) {
                c.add(items[i]);
                items[i] = null;
                i = this.inc(i);
                ++n;
            }
            if (n > 0) {
                this.count -= n;
                this.takeIndex = i;
                this.notFull.signalAll();
            }
            int n2 = n;
            Object var6_10 = null;
            lock.unlock();
            return n2;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            lock.unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Iterator iterator() {
        ReentrantLock lock = this.lock;
        lock.lock();
        try {
            Itr itr = new Itr();
            Object var3_3 = null;
            lock.unlock();
            return itr;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            lock.unlock();
            throw throwable;
        }
    }

    public ArrayBlockingQueue(int capacity) {
        this(capacity, false);
    }

    public ArrayBlockingQueue(int capacity, boolean fair) {
        if (capacity <= 0) {
            throw new IllegalArgumentException();
        }
        this.items = new Object[capacity];
        this.lock = new ReentrantLock(fair);
        this.notEmpty = this.lock.newCondition();
        this.notFull = this.lock.newCondition();
    }

    public ArrayBlockingQueue(int capacity, boolean fair, Collection c) {
        this(capacity, fair);
        if (capacity < c.size()) {
            throw new IllegalArgumentException();
        }
        Iterator it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    private class Itr
    implements Iterator {
        private int nextIndex;
        private Object nextItem;
        private int lastRet = -1;

        public boolean hasNext() {
            boolean bl = false;
            if (this.nextIndex >= 0) {
                bl = true;
            }
            return bl;
        }

        private final void checkNext() {
            if (this.nextIndex == ArrayBlockingQueue.this.putIndex) {
                this.nextIndex = -1;
                this.nextItem = null;
            } else {
                this.nextItem = ArrayBlockingQueue.this.items[this.nextIndex];
                if (this.nextItem == null) {
                    this.nextIndex = -1;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object next() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                if (this.nextIndex < 0) {
                    throw new NoSuchElementException();
                }
                this.lastRet = this.nextIndex;
                Object x = this.nextItem;
                this.nextIndex = ArrayBlockingQueue.this.inc(this.nextIndex);
                this.checkNext();
                Object object = x;
                Object var3_4 = null;
                lock.unlock();
                return object;
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                lock.unlock();
                throw throwable;
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void remove() {
            ReentrantLock lock = ArrayBlockingQueue.this.lock;
            lock.lock();
            try {
                int i = this.lastRet;
                if (i == -1) {
                    throw new IllegalStateException();
                }
                this.lastRet = -1;
                int ti = ArrayBlockingQueue.this.takeIndex;
                ArrayBlockingQueue.this.removeAt(i);
                this.nextIndex = i == ti ? ArrayBlockingQueue.this.takeIndex : i;
                this.checkNext();
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                lock.unlock();
                throw throwable;
            }
            {
                Object var3_6 = null;
                lock.unlock();
                return;
            }
        }

        Itr() {
            if (ArrayBlockingQueue.this.count == 0) {
                this.nextIndex = -1;
            } else {
                this.nextIndex = ArrayBlockingQueue.this.takeIndex;
                this.nextItem = ArrayBlockingQueue.this.items[ArrayBlockingQueue.this.takeIndex];
            }
        }
    }
}

