/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.lang.reflect.Method;
import java.util.Set;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import org.jboss.beans.metadata.plugins.AbstractBeanMetaData;
import org.jboss.beans.metadata.plugins.AbstractConstructorMetaData;
import org.jboss.beans.metadata.plugins.AbstractDemandMetaData;
import org.jboss.beans.metadata.plugins.AbstractValueMetaData;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.ConstructorMetaData;
import org.jboss.beans.metadata.spi.DemandMetaData;
import org.jboss.beans.metadata.spi.ValueMetaData;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.MCClientKernelAbstraction;
import org.jboss.ejb3.MCDependencyPolicy;
import org.jboss.ejb3.embedded.resource.RARDeployment;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.logging.Logger;

public class MCKernelAbstraction
extends MCClientKernelAbstraction
implements KernelAbstraction {
    private static final Logger log = Logger.getLogger(MCKernelAbstraction.class);
    private MBeanServer server;

    public MCKernelAbstraction(Kernel kernel, MBeanServer server) {
        super(kernel);
        this.server = server;
    }

    public void setMbeanServer(MBeanServer server) {
        this.server = server;
    }

    private boolean hasOperation(MBeanInfo info, String operationName) {
        for (MBeanOperationInfo operationInfo : info.getOperations()) {
            if (!operationInfo.getName().equals(operationName) || !operationInfo.getReturnType().equals("void") || operationInfo.getSignature().length != 0) continue;
            return true;
        }
        return false;
    }

    public void install(String name, DependencyPolicy dependencies, Object service) {
        AbstractBeanMetaData bean = new AbstractBeanMetaData(name, service.getClass().getName());
        bean.setConstructor((ConstructorMetaData)new AlreadyInstantiated(service));
        MCDependencyPolicy policy = (MCDependencyPolicy)dependencies;
        bean.setDemands((Set)policy.getDependencies());
        log.info("installing bean: " + name + " with dependencies:");
        for (DemandMetaData obj : policy.getDependencies()) {
            String msg = obj instanceof AbstractDemandMetaData ? ((AbstractDemandMetaData)obj).getDemand().toString() : obj.toString();
            log.info("\t" + msg);
        }
        try {
            try {
                this.kernel.getController().uninstall((Object)name);
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
            this.kernel.getController().install((BeanMetaData)bean);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public void installMBean(ObjectName on, DependencyPolicy dependencies, Object service) {
        try {
            this.server.registerMBean(service, on);
            this.install(on.getCanonicalName(), dependencies, service);
            MBeanInfo info = this.server.getMBeanInfo(on);
            this.invokeOptionalMethod(on, info, "create");
            this.invokeOptionalMethod(on, info, "start");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private void invokeOptionalMethod(ObjectName on, MBeanInfo info, String operationName) throws InstanceNotFoundException, MBeanException, ReflectionException {
        Object[] params = new Object[]{};
        String[] signature = new String[]{};
        if (this.hasOperation(info, operationName)) {
            this.server.invoke(on, operationName, params, signature);
        }
    }

    public void uninstallMBean(ObjectName on) {
        try {
            MBeanInfo info = this.server.getMBeanInfo(on);
            this.invokeOptionalMethod(on, info, "stop");
            this.invokeOptionalMethod(on, info, "destroy");
            this.server.unregisterMBean(on);
            this.kernel.getController().uninstall((Object)on.toString());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void uninstall(String name) {
        try {
            log.info("uninstalling bean: " + name);
            this.kernel.getController().uninstall((Object)name);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object invoke(ObjectName objectName, String operationName, Object[] params, String[] signature) throws Exception {
        String name = objectName.getCanonicalName();
        KernelRegistryEntry entry = this.kernel.getRegistry().getEntry((Object)name);
        if (entry != null) {
            Object target = entry.getTarget();
            if (target instanceof RARDeployment) {
                RARDeployment deployment = (RARDeployment)target;
                return deployment.invoke(operationName, params, signature);
            }
            Class[] types = new Class[signature.length];
            for (int i = 0; i < signature.length; ++i) {
                types[i] = Thread.currentThread().getContextClassLoader().loadClass(signature[i]);
            }
            Method method = target.getClass().getMethod(operationName, types);
            return method.invoke(target, params);
        }
        return null;
    }

    public static class AlreadyInstantiated
    extends AbstractConstructorMetaData {
        private Object bean;

        public AlreadyInstantiated(Object bean) {
            this.bean = bean;
            this.setFactory((ValueMetaData)new AbstractValueMetaData((Object)new Factory()));
            this.setFactoryClass(Factory.class.getName());
            this.setFactoryMethod("create");
        }

        public class Factory {
            public Object create() {
                return AlreadyInstantiated.this.bean;
            }
        }
    }
}

