/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.marshall;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import org.jboss.cache.marshall.ObjectStreamFactory;
import org.jboss.serial.io.JBossObjectInputStreamSharedTree;
import org.jboss.serial.io.JBossObjectOutputStreamSharedTree;

class JBossObjectStreamFactory
implements ObjectStreamFactory {
    JBossObjectStreamFactory() {
    }

    public ObjectInputStream createObjectInputStream(byte[] bytes) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        return new JBossObjectInputStreamOverride(in);
    }

    public ObjectOutputStream createObjectOutputStream(OutputStream out) throws IOException {
        return new JBossObjectOutputStreamSharedTree(out);
    }

    static class JBossObjectInputStreamOverride
    extends JBossObjectInputStreamSharedTree {
        public JBossObjectInputStreamOverride(InputStream input) throws IOException {
            super(input);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object readObjectOverride() throws IOException, ClassNotFoundException {
            ClassLoader older = this.getClassLoader();
            try {
                this.setClassLoader(Thread.currentThread().getContextClassLoader());
                Object object = super.readObjectOverride();
                return object;
            }
            finally {
                this.setClassLoader(older);
            }
        }
    }
}

