/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.ExpectContinueMethod;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MultipartPostMethod
extends ExpectContinueMethod {
    public static final String MULTIPART_FORM_CONTENT_TYPE = "multipart/form-data";
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$methods$MultipartPostMethod == null ? (class$org$apache$commons$httpclient$methods$MultipartPostMethod = MultipartPostMethod.class$("org.apache.commons.httpclient.methods.MultipartPostMethod")) : class$org$apache$commons$httpclient$methods$MultipartPostMethod));
    private final List parameters = new ArrayList();
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$MultipartPostMethod;

    public MultipartPostMethod() {
    }

    public MultipartPostMethod(String string) {
        super(string);
    }

    protected boolean hasRequestContent() {
        return true;
    }

    public String getName() {
        return "POST";
    }

    public void addParameter(String string, String string2) {
        LOG.trace((Object)"enter addParameter(String parameterName, String parameterValue)");
        StringPart stringPart = new StringPart(string, string2);
        this.parameters.add(stringPart);
    }

    public void addParameter(String string, File file) throws FileNotFoundException {
        LOG.trace((Object)"enter MultipartPostMethod.addParameter(String parameterName, File parameterFile)");
        FilePart filePart = new FilePart(string, file);
        this.parameters.add(filePart);
    }

    public void addParameter(String string, String string2, File file) throws FileNotFoundException {
        LOG.trace((Object)"enter MultipartPostMethod.addParameter(String parameterName, String fileName, File parameterFile)");
        FilePart filePart = new FilePart(string, string2, file);
        this.parameters.add(filePart);
    }

    public void addPart(Part part) {
        LOG.trace((Object)"enter addPart(Part part)");
        this.parameters.add(part);
    }

    public Part[] getParts() {
        return this.parameters.toArray(new Part[this.parameters.size()]);
    }

    protected void addContentLengthRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter EntityEnclosingMethod.addContentLengthRequestHeader(HttpState, HttpConnection)");
        if (this.getRequestHeader("Content-Length") == null) {
            long l = this.getRequestContentLength();
            this.addRequestHeader("Content-Length", String.valueOf(l));
        }
        this.removeRequestHeader("Transfer-Encoding");
    }

    protected void addContentTypeRequestHeader(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter EntityEnclosingMethod.addContentTypeRequestHeader(HttpState, HttpConnection)");
        if (!this.parameters.isEmpty()) {
            StringBuffer stringBuffer = new StringBuffer(MULTIPART_FORM_CONTENT_TYPE);
            if (Part.getBoundary() != null) {
                stringBuffer.append("; boundary=");
                stringBuffer.append(Part.getBoundary());
            }
            this.setRequestHeader("Content-Type", stringBuffer.toString());
        }
    }

    protected void addRequestHeaders(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter MultipartPostMethod.addRequestHeaders(HttpState state, HttpConnection conn)");
        super.addRequestHeaders(httpState, httpConnection);
        this.addContentLengthRequestHeader(httpState, httpConnection);
        this.addContentTypeRequestHeader(httpState, httpConnection);
    }

    protected boolean writeRequestBody(HttpState httpState, HttpConnection httpConnection) throws IOException, HttpException {
        LOG.trace((Object)"enter MultipartPostMethod.writeRequestBody(HttpState state, HttpConnection conn)");
        OutputStream outputStream = httpConnection.getRequestOutputStream();
        Part.sendParts(outputStream, this.getParts());
        return true;
    }

    protected long getRequestContentLength() throws IOException {
        LOG.trace((Object)"enter MultipartPostMethod.getRequestContentLength()");
        return Part.getLengthOfParts(this.getParts());
    }

    public void recycle() {
        LOG.trace((Object)"enter MultipartPostMethod.recycle()");
        super.recycle();
        this.parameters.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

