/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms.message;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.util.Map;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import org.jboss.jms.message.JBossMessage;
import org.jboss.messaging.util.SafeUTF;

public class JBossTextMessage
extends JBossMessage
implements TextMessage {
    private static final long serialVersionUID = -5661567664746852006L;
    public static final byte TYPE = 3;

    public JBossTextMessage() {
    }

    public JBossTextMessage(long messageID) {
        super(messageID);
    }

    public JBossTextMessage(long messageID, boolean reliable, long expiration, long timestamp, byte priority, Map coreHeaders, byte[] payloadAsByteArray) {
        super(messageID, reliable, expiration, timestamp, priority, coreHeaders, payloadAsByteArray);
    }

    public JBossTextMessage(JBossTextMessage other) {
        super(other);
    }

    public JBossTextMessage(TextMessage foreign, long id) throws JMSException {
        super((Message)foreign, id);
        String text = foreign.getText();
        if (text != null) {
            this.setText(text);
        }
    }

    public byte getType() {
        return 3;
    }

    public void setText(String string) throws JMSException {
        this.setPayload((Serializable)((Object)string));
        this.clearPayloadAsByteArray();
    }

    public String getText() throws JMSException {
        return (String)this.getPayload();
    }

    public JBossMessage doCopy() {
        return new JBossTextMessage(this);
    }

    protected void writePayload(DataOutputStream out, Object thePayload) throws Exception {
        SafeUTF.instance.safeWriteUTF(out, (String)thePayload);
    }

    protected Object readPayload(DataInputStream in, int length) throws Exception {
        return SafeUTF.instance.safeReadUTF(in);
    }
}

