/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.jboss.logging.Logger;
import org.jboss.util.xml.DOMUtils;
import org.jboss.util.xml.DOMWriter;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLService;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class WSDLWriter {
    protected static final Logger log = Logger.getLogger(WSDLWriter.class);
    protected WSDLDefinitions wsdl;
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected boolean includeSchemaInWSDL = true;

    protected WSDLWriter(WSDLDefinitions wsdl) {
        if (wsdl == null) {
            throw new IllegalArgumentException("WSDL definitions is NULL");
        }
        this.wsdl = wsdl;
    }

    public void write(Writer writer) throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append("<?xml version='1.0' encoding='UTF-8'?>");
        this.appendDefinitions(buffer);
        this.appendTypes(buffer);
        this.appendInterfaces(buffer);
        this.appendBindings(buffer);
        this.appendServices(buffer);
        buffer.append("</definitions>");
        Element element = DOMUtils.parse((String)buffer.toString());
        new DOMWriter(writer).setPrettyprint(true).print((Node)element);
    }

    protected void appendDefinitions(StringBuilder buffer) {
        buffer.append("<definitions");
        WSDLService[] services = this.wsdl.getServices();
        if (services != null && services.length == 1) {
            WSDLService ser = services[0];
            buffer.append(" name='" + ser.getName() + "'");
        }
        buffer.append(" targetNamespace='" + this.wsdl.getTargetNamespace() + "'");
        buffer.append(" xmlns='" + this.wsdl.getWsdlNamespace() + "'");
        Iterator it = this.wsdl.getRegisteredNamespaceURIs();
        while (it.hasNext()) {
            String namespaceURI = (String)it.next();
            String prefix = this.wsdl.getPrefix(namespaceURI);
            if (prefix.length() <= 0) continue;
            buffer.append(" xmlns:" + prefix + "='" + namespaceURI + "'");
        }
        buffer.append(">");
    }

    protected void appendTypes(StringBuilder buffer) {
        buffer.append("<types>");
        JBossXSModel xsM = this.wsdl.getWsdlTypes().getSchemaModel();
        String schema = xsM.serialize();
        buffer.append(schema);
        buffer.append("</types>");
    }

    protected abstract void appendInterfaces(StringBuilder var1);

    protected abstract void appendBindings(StringBuilder var1);

    protected abstract void appendServices(StringBuilder var1);

    protected String getQNameRef(QName qname) {
        String retStr = qname.getLocalPart();
        String prefix = qname.getPrefix();
        String nsURI = qname.getNamespaceURI();
        if (prefix.length() == 0 && nsURI.length() > 0) {
            qname = this.wsdl.registerQName(qname);
            prefix = qname.getPrefix();
        }
        if (prefix.length() > 0) {
            retStr = prefix + ":" + retStr;
        }
        return retStr;
    }

    public WSDLDefinitions getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(WSDLDefinitions wsdl) {
        this.wsdl = wsdl;
    }

    public boolean isIncludeTypesInWSDL() {
        return this.includeSchemaInWSDL;
    }

    public void logException(Exception e) {
        if (log.isTraceEnabled()) {
            log.trace((Object)e);
        }
    }

    public void logMessage(String msg) {
        if (log.isTraceEnabled()) {
            log.trace((Object)msg);
        }
    }
}

