/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.metadata.wsdl;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.jboss.ws.metadata.wsdl.Extendable;
import org.jboss.ws.metadata.wsdl.NCName;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLEndpoint;

public class WSDLService
extends Extendable {
    private static final long serialVersionUID = 1274166611190648479L;
    private WSDLDefinitions wsdlDefinitions;
    private NCName name;
    private QName qname;
    private QName interfaceName;
    private ArrayList endpoints = new ArrayList();

    public WSDLService(WSDLDefinitions wsdlDefinitions) {
        this.wsdlDefinitions = wsdlDefinitions;
    }

    public WSDLDefinitions getWsdlDefinitions() {
        return this.wsdlDefinitions;
    }

    public NCName getName() {
        return this.name;
    }

    public void setName(NCName name) {
        this.name = name;
    }

    public QName getQName() {
        if (this.qname == null) {
            String tnsURI = this.wsdlDefinitions.getTargetNamespace();
            this.qname = new QName(tnsURI, this.name.toString());
        }
        return this.qname;
    }

    public void setQName(QName qname) {
        this.qname = qname;
    }

    public QName getInterfaceName() {
        return this.interfaceName;
    }

    public void setInterfaceName(QName interfaceName) {
        this.interfaceName = interfaceName;
    }

    public WSDLEndpoint[] getEndpoints() {
        WSDLEndpoint[] arr = new WSDLEndpoint[this.endpoints.size()];
        this.endpoints.toArray(arr);
        return arr;
    }

    public void addEndpoint(WSDLEndpoint endpoint) {
        this.endpoints.add(endpoint);
    }

    public WSDLEndpoint getEndpoint(QName epName) {
        for (WSDLEndpoint wsdlEndpoint : this.endpoints) {
            if (!epName.equals(wsdlEndpoint.getQName())) continue;
            return wsdlEndpoint;
        }
        return null;
    }
}

