/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.xml.registry.JAXRException;
import javax.xml.registry.LifeCycleManager;
import javax.xml.registry.infomodel.Association;
import javax.xml.registry.infomodel.Concept;
import javax.xml.registry.infomodel.ExternalIdentifier;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.Organization;
import javax.xml.registry.infomodel.RegistryObject;
import javax.xml.registry.infomodel.Service;
import javax.xml.registry.infomodel.ServiceBinding;
import org.apache.ws.scout.registry.infomodel.AssociationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationImpl;
import org.apache.ws.scout.registry.infomodel.ClassificationSchemeImpl;
import org.apache.ws.scout.registry.infomodel.ConceptImpl;
import org.apache.ws.scout.registry.infomodel.ExternalIdentifierImpl;
import org.apache.ws.scout.registry.infomodel.ExternalLinkImpl;
import org.apache.ws.scout.registry.infomodel.InternationalStringImpl;
import org.apache.ws.scout.registry.infomodel.KeyImpl;
import org.apache.ws.scout.registry.infomodel.OrganizationImpl;
import org.apache.ws.scout.registry.infomodel.PersonNameImpl;
import org.apache.ws.scout.registry.infomodel.ServiceBindingImpl;
import org.apache.ws.scout.registry.infomodel.ServiceImpl;
import org.apache.ws.scout.registry.infomodel.UserImpl;
import org.apache.ws.scout.uddi.AccessPoint;
import org.apache.ws.scout.uddi.BindingTemplate;
import org.apache.ws.scout.uddi.BindingTemplates;
import org.apache.ws.scout.uddi.BusinessDetail;
import org.apache.ws.scout.uddi.BusinessEntity;
import org.apache.ws.scout.uddi.BusinessService;
import org.apache.ws.scout.uddi.BusinessServices;
import org.apache.ws.scout.uddi.CategoryBag;
import org.apache.ws.scout.uddi.Contact;
import org.apache.ws.scout.uddi.Contacts;
import org.apache.ws.scout.uddi.Description;
import org.apache.ws.scout.uddi.DiscoveryURL;
import org.apache.ws.scout.uddi.DiscoveryURLs;
import org.apache.ws.scout.uddi.IdentifierBag;
import org.apache.ws.scout.uddi.KeyedReference;
import org.apache.ws.scout.uddi.Name;
import org.apache.ws.scout.uddi.ServiceInfo;
import org.apache.ws.scout.uddi.TModel;
import org.apache.ws.scout.uddi.TModelDetail;
import org.apache.ws.scout.uddi.TModelInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScoutUddiJaxrHelper {
    public static Association getAssociation(Collection orgs, LifeCycleManager lcm) throws JAXRException {
        AssociationImpl asso = new AssociationImpl(lcm);
        Object[] arr = orgs.toArray();
        asso.setSourceObject((RegistryObject)arr[0]);
        asso.setTargetObject((RegistryObject)arr[1]);
        return asso;
    }

    public static Organization getOrganization(BusinessEntity entity, LifeCycleManager lcm) throws JAXRException {
        Name[] namearray = entity.getNameArray();
        Name n = namearray != null && namearray.length > 0 ? namearray[0] : null;
        String name = n != null ? n.getStringValue() : null;
        Description[] descarray = entity.getDescriptionArray();
        Description desc = descarray != null && descarray.length > 0 ? descarray[0] : null;
        OrganizationImpl org = new OrganizationImpl(lcm);
        if (name != null) {
            org.setName(ScoutUddiJaxrHelper.getIString(n.getLang(), name, lcm));
        }
        if (desc != null) {
            org.setDescription(ScoutUddiJaxrHelper.getIString(desc.getLang(), desc.getStringValue(), lcm));
        }
        org.setKey(lcm.createKey(entity.getBusinessKey()));
        BusinessServices services = entity.getBusinessServices();
        BusinessService[] sarr = services != null ? services.getBusinessServiceArray() : null;
        for (int i = 0; sarr != null && i < sarr.length; ++i) {
            BusinessService s = sarr[i];
            org.addService(ScoutUddiJaxrHelper.getService(s, lcm));
        }
        Contacts contacts = entity.getContacts();
        Contact[] carr = contacts != null ? contacts.getContactArray() : null;
        for (int i = 0; carr != null && i < carr.length; ++i) {
            Contact contact = carr[i];
            UserImpl user = new UserImpl(null);
            String pname = contact.getPersonName();
            user.setPersonName(new PersonNameImpl(pname));
            if (i == 0) {
                org.setPrimaryContact(user);
                continue;
            }
            org.addUser(user);
        }
        DiscoveryURLs durls = entity.getDiscoveryURLs();
        if (durls != null) {
            DiscoveryURL[] darr = durls.getDiscoveryURLArray();
            for (int j = 0; darr != null && j < darr.length; ++j) {
                DiscoveryURL durl = darr[j];
                ExternalLinkImpl link = new ExternalLinkImpl(lcm);
                link.setExternalURI(durl.getStringValue());
                org.addExternalLink(link);
            }
        }
        org.addExternalIdentifiers(ScoutUddiJaxrHelper.getExternalIdentifiers(entity.getIdentifierBag(), lcm));
        org.addClassifications(ScoutUddiJaxrHelper.getClassifications(entity.getCategoryBag(), lcm));
        return org;
    }

    public static Organization getOrganization(BusinessDetail bizdetail, LifeCycleManager lcm) throws JAXRException {
        BusinessEntity[] bz = bizdetail.getBusinessEntityArray();
        BusinessEntity entity = bz[0];
        Name[] namearr = entity.getNameArray();
        Name n = namearr != null && namearr.length > 0 ? namearr[0] : null;
        String name = n != null ? n.getStringValue() : null;
        Description[] descarr = entity.getDescriptionArray();
        Description desc = descarr != null && descarr.length > 0 ? descarr[0] : null;
        OrganizationImpl org = new OrganizationImpl(lcm);
        if (name != null) {
            org.setName(ScoutUddiJaxrHelper.getIString(n.getLang(), name, lcm));
        }
        if (desc != null) {
            org.setDescription(ScoutUddiJaxrHelper.getIString(desc.getLang(), desc.getStringValue(), lcm));
        }
        org.setKey(lcm.createKey(entity.getBusinessKey()));
        BusinessServices services = entity.getBusinessServices();
        BusinessService[] sarr = services != null ? services.getBusinessServiceArray() : null;
        for (int i = 0; sarr != null && i < sarr.length; ++i) {
            BusinessService s = sarr[i];
            org.addService(ScoutUddiJaxrHelper.getService(s, lcm));
        }
        Contacts contacts = entity.getContacts();
        Contact[] carr = contacts != null ? contacts.getContactArray() : null;
        for (int i = 0; carr != null && i < carr.length; ++i) {
            Contact contact = carr[i];
            UserImpl user = new UserImpl(null);
            String pname = contact.getPersonName();
            user.setType(contact.getUseType());
            user.setPersonName(new PersonNameImpl(pname));
            if (i == 0) {
                org.setPrimaryContact(user);
                continue;
            }
            org.addUser(user);
        }
        DiscoveryURLs durls = entity.getDiscoveryURLs();
        if (durls != null) {
            DiscoveryURL[] darr = durls.getDiscoveryURLArray();
            for (int j = 0; darr != null && j < darr.length; ++j) {
                DiscoveryURL durl = darr[j];
                ExternalLinkImpl link = new ExternalLinkImpl(lcm);
                link.setExternalURI(durl.getStringValue());
                org.addExternalLink(link);
            }
        }
        org.addExternalIdentifiers(ScoutUddiJaxrHelper.getExternalIdentifiers(entity.getIdentifierBag(), lcm));
        org.addClassifications(ScoutUddiJaxrHelper.getClassifications(entity.getCategoryBag(), lcm));
        return org;
    }

    private static InternationalString getIString(String lang, String str, LifeCycleManager blm) throws JAXRException {
        return blm.createInternationalString(ScoutUddiJaxrHelper.getLocale(lang), str);
    }

    public static InternationalString getIString(String str, LifeCycleManager blm) throws JAXRException {
        return blm.createInternationalString(str);
    }

    public static Service getService(BusinessService bs, LifeCycleManager lcm) throws JAXRException {
        BindingTemplates bts;
        Description[] descarr;
        Description desc;
        Name[] namearr;
        Name n;
        ServiceImpl serve = new ServiceImpl(lcm);
        String keystr = bs.getServiceKey();
        if (keystr != null) {
            serve.setKey(lcm.createKey(keystr));
        }
        Name name = n = (namearr = bs.getNameArray()) != null && namearr.length > 0 ? namearr[0] : null;
        if (n != null) {
            String name2 = n.getStringValue();
            serve.setName(lcm.createInternationalString(ScoutUddiJaxrHelper.getLocale(n.getLang()), name2));
        }
        Description description = desc = (descarr = bs.getDescriptionArray()) != null && descarr.length > 0 ? descarr[0] : null;
        if (desc != null) {
            serve.setDescription(lcm.createInternationalString(ScoutUddiJaxrHelper.getLocale(desc.getLang()), desc.getStringValue()));
        }
        BindingTemplate[] btarr = (bts = bs.getBindingTemplates()) != null ? bts.getBindingTemplateArray() : null;
        for (int i = 0; btarr != null && i < btarr.length; ++i) {
            BindingTemplate bindingTemplate = btarr[i];
            serve.addServiceBinding(ScoutUddiJaxrHelper.getServiceBinding(bindingTemplate, lcm));
        }
        serve.addClassifications(ScoutUddiJaxrHelper.getClassifications(bs.getCategoryBag(), lcm));
        return serve;
    }

    public static Service getService(ServiceInfo si, LifeCycleManager lcm) throws JAXRException {
        Name[] namearr;
        Name n;
        ServiceImpl service = new ServiceImpl(lcm);
        String keystr = si.getServiceKey();
        if (keystr != null) {
            service.setKey(lcm.createKey(keystr));
        }
        Name name = n = (namearr = si.getNameArray()) != null && namearr.length > 0 ? namearr[0] : null;
        if (n != null) {
            String name2 = n.getStringValue();
            service.setName(lcm.createInternationalString(ScoutUddiJaxrHelper.getLocale(n.getLang()), name2));
        }
        return service;
    }

    public static ServiceBinding getServiceBinding(BindingTemplate bs, LifeCycleManager lcm) throws JAXRException {
        Description[] da;
        AccessPoint access;
        String bindingKey;
        ServiceBindingImpl serve = new ServiceBindingImpl(lcm);
        String keystr = bs.getServiceKey();
        if (keystr != null) {
            ServiceImpl svc = new ServiceImpl(lcm);
            svc.setKey(lcm.createKey(keystr));
            serve.setService(svc);
        }
        if ((bindingKey = bs.getBindingKey()) != null) {
            serve.setKey(new KeyImpl(bindingKey));
        }
        if ((access = bs.getAccessPoint()) != null) {
            serve.setAccessURI(access.getStringValue());
        }
        if ((da = bs.getDescriptionArray()) != null && da.length > 0) {
            Description des = da[0];
            serve.setDescription(new InternationalStringImpl(des.getStringValue()));
        }
        return serve;
    }

    public static Concept getConcept(TModelDetail tm, LifeCycleManager lcm) throws JAXRException {
        TModel tmodel;
        ConceptImpl concept = new ConceptImpl(lcm);
        TModel[] tc = tm.getTModelArray();
        TModel tModel = tmodel = tc != null && tc.length > 0 ? tc[0] : null;
        if (tmodel != null) {
            concept.setKey(lcm.createKey(tmodel.getTModelKey()));
            concept.setName(lcm.createInternationalString(ScoutUddiJaxrHelper.getLocale(tmodel.getName().getLang()), tmodel.getName().getStringValue()));
            Description desc = ScoutUddiJaxrHelper.getDescription(tmodel);
            if (desc != null) {
                concept.setDescription(lcm.createInternationalString(ScoutUddiJaxrHelper.getLocale(desc.getLang()), desc.getStringValue()));
            }
            concept.addExternalIdentifiers(ScoutUddiJaxrHelper.getExternalIdentifiers(tmodel.getIdentifierBag(), lcm));
            concept.addClassifications(ScoutUddiJaxrHelper.getClassifications(tmodel.getCategoryBag(), lcm));
        }
        return concept;
    }

    public static Concept getConcept(TModel tmodel, LifeCycleManager lcm) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(lcm);
        concept.setKey(lcm.createKey(tmodel.getTModelKey()));
        concept.setName(lcm.createInternationalString(ScoutUddiJaxrHelper.getLocale(tmodel.getName().getLang()), tmodel.getName().getStringValue()));
        Description desc = ScoutUddiJaxrHelper.getDescription(tmodel);
        if (desc != null) {
            concept.setDescription(lcm.createInternationalString(ScoutUddiJaxrHelper.getLocale(desc.getLang()), desc.getStringValue()));
        }
        concept.addExternalIdentifiers(ScoutUddiJaxrHelper.getExternalIdentifiers(tmodel.getIdentifierBag(), lcm));
        concept.addClassifications(ScoutUddiJaxrHelper.getClassifications(tmodel.getCategoryBag(), lcm));
        return concept;
    }

    public static Concept getConcept(TModelInfo tm, LifeCycleManager lcm) throws JAXRException {
        ConceptImpl concept = new ConceptImpl(lcm);
        concept.setKey(lcm.createKey(tm.getTModelKey()));
        concept.setName(lcm.createInternationalString(ScoutUddiJaxrHelper.getLocale(tm.getName().getLang()), tm.getName().getStringValue()));
        return concept;
    }

    private static Description getDescription(TModel tmodel) {
        Description[] descarr = tmodel.getDescriptionArray();
        Description desc = descarr != null && descarr.length > 0 ? descarr[0] : null;
        return desc;
    }

    public static Collection getClassifications(CategoryBag cbag, LifeCycleManager lcm) throws JAXRException {
        ArrayList<ClassificationImpl> classifications = null;
        if (cbag != null) {
            classifications = new ArrayList<ClassificationImpl>();
            KeyedReference[] keyrarr = cbag.getKeyedReferenceArray();
            for (int i = 0; keyrarr != null && i < keyrarr.length; ++i) {
                KeyedReference keyr = keyrarr[i];
                ClassificationImpl classification = new ClassificationImpl(lcm);
                classification.setValue(keyr.getKeyValue());
                classification.setName(new InternationalStringImpl(keyr.getKeyName()));
                String tmodelKey = keyr.getTModelKey();
                if (tmodelKey != null) {
                    ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(lcm);
                    scheme.setKey(new KeyImpl(tmodelKey));
                    classification.setClassificationScheme(scheme);
                }
                classifications.add(classification);
            }
        }
        return classifications;
    }

    public static Collection<ExternalIdentifier> getExternalIdentifiers(IdentifierBag ibag, LifeCycleManager lcm) throws JAXRException {
        ArrayList<ExternalIdentifierImpl> extidentifiers = null;
        if (ibag != null) {
            extidentifiers = new ArrayList<ExternalIdentifierImpl>();
            KeyedReference[] keyrarr = ibag.getKeyedReferenceArray();
            for (int i = 0; keyrarr != null && i < keyrarr.length; ++i) {
                KeyedReference keyr = keyrarr[i];
                ExternalIdentifierImpl extId = new ExternalIdentifierImpl(lcm);
                extId.setValue(keyr.getKeyValue());
                extId.setName(new InternationalStringImpl(keyr.getKeyName()));
                String tmodelKey = keyr.getTModelKey();
                if (tmodelKey != null) {
                    ClassificationSchemeImpl scheme = new ClassificationSchemeImpl(lcm);
                    scheme.setKey(new KeyImpl(tmodelKey));
                    extId.setIdentificationScheme(scheme);
                }
                extidentifiers.add(extId);
            }
        }
        return extidentifiers;
    }

    private static Locale getLocale(String lang) {
        if (lang == null || lang.trim().length() == 0) {
            return Locale.getDefault();
        }
        if (lang.equalsIgnoreCase(Locale.getDefault().getLanguage())) {
            return Locale.getDefault();
        }
        return new Locale(lang);
    }
}

