/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.scout.registry;

import java.io.Serializable;
import java.net.URI;
import java.util.Properties;
import java.util.Set;
import javax.xml.registry.Connection;
import javax.xml.registry.JAXRException;
import javax.xml.registry.RegistryService;
import org.apache.ws.scout.registry.RegistryImpl;
import org.apache.ws.scout.registry.RegistryServiceImpl;

public class ConnectionImpl
implements Connection,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean closed = false;
    private boolean synchronous = true;
    private Set credentials;
    private final RegistryImpl registry;
    private final String postalScheme;
    private final int maxRows;

    public ConnectionImpl(URI queryManagerURI, URI lifeCycleManagerURI, String transportClass, String postalScheme, int maxRows) {
        Properties prop = new Properties();
        if (transportClass != null) {
            prop.setProperty("scout.proxy.transportClass", transportClass);
        } else {
            String transport = System.getProperty("scout.proxy.transportClass");
            if (transport != null) {
                prop.setProperty("scout.proxy.transportClass", transport);
            }
        }
        this.registry = new RegistryImpl(prop);
        this.registry.setInquiryURI(queryManagerURI);
        this.registry.setPublishURI(lifeCycleManagerURI);
        this.postalScheme = postalScheme;
        this.maxRows = maxRows;
    }

    public RegistryService getRegistryService() throws JAXRException {
        RegistryServiceImpl reg = new RegistryServiceImpl(this.registry, this.postalScheme, this.maxRows);
        reg.setConnection(this);
        return reg;
    }

    public void close() {
        this.closed = true;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Set getCredentials() {
        return this.credentials;
    }

    public void setCredentials(Set credentials) {
        this.credentials = credentials;
    }

    public boolean isSynchronous() {
        return this.synchronous;
    }

    public void setSynchronous(boolean synchronous) {
        this.synchronous = synchronous;
    }
}

