/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.security;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.activemq.command.ActiveMQDestination;
import org.apache.activemq.filter.DestinationMap;
import org.apache.activemq.security.AuthorizationEntry;
import org.apache.activemq.security.AuthorizationMap;

public class DefaultAuthorizationMap
extends DestinationMap
implements AuthorizationMap {
    private AuthorizationEntry defaultEntry;

    public DefaultAuthorizationMap() {
    }

    public DefaultAuthorizationMap(List authorizationEntries) {
        this.setAuthorizationEntries(authorizationEntries);
    }

    public Set getAdminACLs(ActiveMQDestination destination) {
        Set entries = this.getAllEntries(destination);
        HashSet answer = new HashSet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            AuthorizationEntry entry = (AuthorizationEntry)iter.next();
            answer.addAll(entry.getAdminACLs());
        }
        return answer;
    }

    public Set getReadACLs(ActiveMQDestination destination) {
        Set entries = this.getAllEntries(destination);
        HashSet answer = new HashSet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            AuthorizationEntry entry = (AuthorizationEntry)iter.next();
            answer.addAll(entry.getReadACLs());
        }
        return answer;
    }

    public Set getWriteACLs(ActiveMQDestination destination) {
        Set entries = this.getAllEntries(destination);
        HashSet answer = new HashSet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            AuthorizationEntry entry = (AuthorizationEntry)iter.next();
            answer.addAll(entry.getWriteACLs());
        }
        return answer;
    }

    public AuthorizationEntry getEntryFor(ActiveMQDestination destination) {
        AuthorizationEntry answer = (AuthorizationEntry)this.chooseValue(destination);
        if (answer == null) {
            answer = this.getDefaultEntry();
        }
        return answer;
    }

    public void setAuthorizationEntries(List entries) {
        super.setEntries(entries);
    }

    public AuthorizationEntry getDefaultEntry() {
        return this.defaultEntry;
    }

    public void setDefaultEntry(AuthorizationEntry defaultEntry) {
        this.defaultEntry = defaultEntry;
    }

    protected Class getEntryClass() {
        return AuthorizationEntry.class;
    }

    protected Set getAllEntries(ActiveMQDestination destination) {
        Set entries = this.get(destination);
        if (this.defaultEntry != null) {
            entries.add(this.defaultEntry);
        }
        return entries;
    }
}

