/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq;

import java.io.Serializable;
import java.util.Random;

public class RedeliveryPolicy
implements Cloneable,
Serializable {
    protected double collisionAvoidanceFactor = 0.15;
    protected int maximumRedeliveries = 6;
    protected long initialRedeliveryDelay = 1000L;
    protected static Random randomNumberGenerator;
    protected boolean useCollisionAvoidance = false;
    protected boolean useExponentialBackOff = false;
    protected short backOffMultiplier = (short)5;

    public RedeliveryPolicy copy() {
        try {
            return (RedeliveryPolicy)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException("Could not clone: " + e, e);
        }
    }

    public short getBackOffMultiplier() {
        return this.backOffMultiplier;
    }

    public void setBackOffMultiplier(short backOffMultiplier) {
        this.backOffMultiplier = backOffMultiplier;
    }

    public short getCollisionAvoidancePercent() {
        return (short)Math.round(this.collisionAvoidanceFactor * 100.0);
    }

    public void setCollisionAvoidancePercent(short collisionAvoidancePercent) {
        this.collisionAvoidanceFactor = (double)collisionAvoidancePercent * 0.01;
    }

    public long getInitialRedeliveryDelay() {
        return this.initialRedeliveryDelay;
    }

    public void setInitialRedeliveryDelay(long initialRedeliveryDelay) {
        this.initialRedeliveryDelay = initialRedeliveryDelay;
    }

    public int getMaximumRedeliveries() {
        return this.maximumRedeliveries;
    }

    public void setMaximumRedeliveries(int maximumRedeliveries) {
        this.maximumRedeliveries = maximumRedeliveries;
    }

    public long getRedeliveryDelay(long previousDelay) {
        long redeliveryDelay = previousDelay == 0L ? this.initialRedeliveryDelay : (this.useExponentialBackOff && this.backOffMultiplier > 1 ? previousDelay * (long)this.backOffMultiplier : previousDelay);
        if (this.useCollisionAvoidance) {
            if (randomNumberGenerator == null) {
                RedeliveryPolicy.initRandomNumberGenerator();
            }
            double variance = (randomNumberGenerator.nextBoolean() ? this.collisionAvoidanceFactor : -this.collisionAvoidanceFactor) * randomNumberGenerator.nextDouble();
            redeliveryDelay = (long)((double)redeliveryDelay + (double)redeliveryDelay * variance);
        }
        return redeliveryDelay;
    }

    public boolean isUseCollisionAvoidance() {
        return this.useCollisionAvoidance;
    }

    public void setUseCollisionAvoidance(boolean useCollisionAvoidance) {
        this.useCollisionAvoidance = useCollisionAvoidance;
    }

    public boolean isUseExponentialBackOff() {
        return this.useExponentialBackOff;
    }

    public void setUseExponentialBackOff(boolean useExponentialBackOff) {
        this.useExponentialBackOff = useExponentialBackOff;
    }

    protected static synchronized void initRandomNumberGenerator() {
        if (randomNumberGenerator == null) {
            randomNumberGenerator = new Random();
        }
    }
}

