/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.crypto;

import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.WrappedObject;
import com.enterprisedt.net.puretls.crypto.B;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.SecureRandom;

public class RandomStore {
    public static SecureRandom readRandomStore(String string, byte[] byArray) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        if (!WrappedObject.findObject(bufferedReader, "RANDOM DATA", null)) {
            throw new IOException("Couldn't find randomness in this file");
        }
        byte[] byArray2 = B.A(bufferedReader, byArray);
        SSLDebug.debug(8, "Creating new PRNG seeded with", byArray2);
        SecureRandom secureRandom = new SecureRandom(byArray2);
        secureRandom.setSeed(System.currentTimeMillis());
        RandomStore.writeRandomStore(string, byArray, secureRandom);
        return secureRandom;
    }

    public static void writeRandomStore(String string, byte[] byArray, SecureRandom secureRandom) throws FileNotFoundException, IOException {
        FileWriter fileWriter = new FileWriter(string);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        byte[] byArray2 = new byte[1024];
        secureRandom.nextBytes(byArray2);
        B.A(byArray2, byArray, "RANDOM DATA", bufferedWriter);
        secureRandom.setSeed(System.currentTimeMillis());
    }
}

