/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.crypto;

import com.enterprisedt.net.puretls.SSLDebug;
import java.math.BigInteger;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import xjava.security.IllegalBlockSizeException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class PKCS1Pad {
    public static final int ENCRYPT = 1;
    public static final int SIGN = 2;
    public static final int DECRYPT = 1;
    public static final int VERIFY = 2;

    public static byte[] pkcs1PadBuf(SecureRandom secureRandom, byte[] byArray, PublicKey publicKey) {
        BigInteger bigInteger = ((CryptixRSAPublicKey)publicKey).getModulus();
        return PKCS1Pad.pkcs1PadBuf(secureRandom, byArray, bigInteger, 1);
    }

    public static byte[] pkcs1PadBuf(byte[] byArray, PrivateKey privateKey) {
        BigInteger bigInteger = ((CryptixRSAPrivateKey)privateKey).getModulus();
        return PKCS1Pad.pkcs1PadBuf(byArray, bigInteger, 2);
    }

    public static byte[] pkcs1PadBuf(byte[] byArray, BigInteger bigInteger, int n2) {
        SecureRandom secureRandom = null;
        if (n2 == 1) {
            secureRandom = new SecureRandom();
        }
        return PKCS1Pad.pkcs1PadBuf(secureRandom, byArray, bigInteger, n2);
    }

    public static byte[] pkcs1PadBuf(SecureRandom secureRandom, byte[] byArray, BigInteger bigInteger, int n2) {
        SSLDebug.debug(8, "PKCS1 pad input", byArray);
        int n3 = bigInteger.bitLength() / 8;
        n3 += bigInteger.bitLength() % 8 > 0 ? 1 : 0;
        int n4 = n2 == 1 ? --n3 - (2 + byArray.length) : n3 - (3 + byArray.length);
        byte[] byArray2 = new byte[n3];
        if (n4 < 8) {
            throw new InternalError("Input too long");
        }
        int n5 = 0;
        if (n2 == 1) {
            byArray2[n5++] = 2;
            byte[] byArray3 = new byte[1];
            for (int i2 = 0; i2 < n4; ++i2) {
                do {
                    secureRandom.nextBytes(byArray3);
                } while (byArray3[0] == 0);
                byArray2[n5++] = byArray3[0];
            }
        } else {
            byArray2[n5++] = 0;
            byArray2[n5++] = 1;
            for (int i3 = 0; i3 < n4; ++i3) {
                byArray2[n5++] = -1;
            }
        }
        byArray2[n5++] = 0;
        System.arraycopy(byArray, 0, byArray2, n5, byArray.length);
        SSLDebug.debug(8, "PKCS1 padded output", byArray2);
        return byArray2;
    }

    public static byte[] pkcs1UnpadBuf(byte[] byArray, int n2, CryptixRSAPrivateKey cryptixRSAPrivateKey) {
        return PKCS1Pad.pkcs1UnpadBuf(byArray, n2, cryptixRSAPrivateKey.getModulus());
    }

    public static byte[] pkcs1UnpadBuf(byte[] byArray, int n2, BigInteger bigInteger) {
        int n3 = 0;
        SSLDebug.debug(8, "PKCS1 padded input", byArray);
        int n4 = bigInteger.bitLength() / 8;
        if ((n4 += bigInteger.bitLength() % 8 > 0 ? 1 : 0) - 1 != byArray.length) {
            SSLDebug.debug(8, "Encryption block wrong length");
            throw new IllegalBlockSizeException("Bad RSA padding: wrong length" + byArray.length);
        }
        if (n2 == 1 ? byArray[0] != 2 : byArray[0] != 1) {
            throw new IllegalBlockSizeException("Bad RSA padding");
        }
        for (int i2 = 1; i2 < byArray.length; ++i2) {
            if (byArray[i2] == 0) {
                if (n3 < 8) {
                    SSLDebug.debug(8, "Bad RSA padding" + n3 + "bytes");
                    throw new IllegalBlockSizeException("Bad RSA padding");
                }
                byte[] byArray2 = new byte[byArray.length - (i2 + 1)];
                System.arraycopy(byArray, i2 + 1, byArray2, 0, byArray2.length);
                SSLDebug.debug(8, "PKCS1 unpadded output", byArray2);
                return byArray2;
            }
            ++n3;
            if (n2 == 1 || byArray[i2] == -1) continue;
            throw new IllegalBlockSizeException("Bad RSA padding");
        }
        throw new IllegalBlockSizeException("Bad RSA padding");
    }
}

