/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.asn1.encoding.BaseCoder;
import com.enterprisedt.cryptix.asn1.encoding.CoderOperations;
import com.enterprisedt.cryptix.asn1.lang.ASNObject;
import com.enterprisedt.cryptix.asn1.lang.ASNSpecification;
import com.enterprisedt.net.puretls.cert.CertContext;
import com.enterprisedt.net.puretls.cert.DERUtils;
import com.enterprisedt.net.puretls.cert.X509SubjectPublicKeyInfo;
import com.enterprisedt.net.puretls.crypto.BaseDSAPublicKey;
import com.enterprisedt.net.puretls.crypto.RawDSAParams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.interfaces.DSAPublicKey;

public class X509DSAPublicKey
extends BaseDSAPublicKey {
    private byte[] A = new byte[]{42, -122, 72, -50, 56, 4, 1};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public X509DSAPublicKey(String string, byte[] byArray, byte[] byArray2) throws IOException {
        ASNSpecification aSNSpecification = CertContext.getSpec();
        synchronized (aSNSpecification) {
            CoderOperations coderOperations = BaseCoder.getInstance("DER");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            coderOperations.init(byteArrayInputStream);
            ASNObject aSNObject = CertContext.getSpec().getComponent("DSAParameters");
            aSNObject.accept(coderOperations, null);
            BigInteger bigInteger = (BigInteger)aSNObject.getComponent("DSAParameters.p").getValue();
            BigInteger bigInteger2 = (BigInteger)aSNObject.getComponent("DSAParameters.q").getValue();
            BigInteger bigInteger3 = (BigInteger)aSNObject.getComponent("DSAParameters.g").getValue();
            this.params = new RawDSAParams(bigInteger, bigInteger2, bigInteger3);
            if (byArray2[0] != 0) {
                throw new IOException("Bad encoded key");
            }
            byte[] byArray3 = new byte[byArray2.length - 1];
            System.arraycopy(byArray2, 1, byArray3, 0, byArray3.length);
            byteArrayInputStream = new ByteArrayInputStream(byArray3);
            ASNObject aSNObject2 = CertContext.getSpec().getComponent("DSAKey");
            coderOperations.init(byteArrayInputStream);
            aSNObject2.accept(coderOperations, null);
            this.Y = (BigInteger)aSNObject2.getValue();
        }
    }

    public X509DSAPublicKey(DSAPublicKey dSAPublicKey) {
        super(dSAPublicKey);
    }

    public String getFormat() {
        return "DER";
    }

    public byte[] getEncoded() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DERUtils.encodeInteger(this.params.getP(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.params.getQ(), byteArrayOutputStream);
            DERUtils.encodeInteger(this.params.getG(), byteArrayOutputStream);
            byte[] byArray = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeSequence(byArray, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            byteArrayOutputStream.reset();
            DERUtils.encodeInteger(this.Y, byteArrayOutputStream);
            byte[] byArray3 = byteArrayOutputStream.toByteArray();
            return X509SubjectPublicKeyInfo.encodePublicKey(this.A, byArray2, byArray3);
        }
        catch (IOException iOException) {
            throw new InternalError(iOException.toString());
        }
    }
}

