/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls.cert;

import com.enterprisedt.cryptix.asn1.lang.ASNSpecification;
import com.enterprisedt.cryptix.asn1.lang.ParseException;
import com.enterprisedt.cryptix.asn1.lang.Parser;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.cert.B;
import com.enterprisedt.net.puretls.cert.CertificateException;
import com.enterprisedt.net.puretls.cert.X509Cert;
import java.util.Vector;

public class CertContext {
    Vector B = new Vector();
    static Parser C = new Parser(new B());
    static ASNSpecification A;

    public CertContext() {
    }

    public CertContext(Vector vector) {
        if (vector != null) {
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                Object e2 = vector.elementAt(i2);
                if (e2 instanceof X509Cert) {
                    this.B.addElement(e2);
                    continue;
                }
                this.addRoot((byte[])vector.elementAt(i2));
            }
        }
    }

    public static ASNSpecification getSpec() {
        return A;
    }

    public void addRoot(byte[] byArray) {
        X509Cert x509Cert;
        try {
            x509Cert = new X509Cert(byArray);
        }
        catch (CertificateException certificateException) {
            SSLDebug.debug(32, "Couldn't parse. Skipping cert", byArray);
            return;
        }
        this.B.addElement(x509Cert);
        SSLDebug.debug(32, "Adding root with DN", x509Cert.getSubjectDER());
    }

    public Vector getRootList() {
        return this.B;
    }

    public boolean isRoot(byte[] byArray) {
        for (int i2 = 0; i2 < this.B.size(); ++i2) {
            byte[] byArray2 = ((X509Cert)this.B.elementAt(i2)).getDER();
            if (!ArrayUtil.areEqual(byArray, byArray2)) continue;
            return true;
        }
        return false;
    }

    public X509Cert signedByRoot(byte[] byArray) {
        for (int i2 = 0; i2 < this.B.size(); ++i2) {
            X509Cert x509Cert = (X509Cert)this.B.elementAt(i2);
            byte[] byArray2 = x509Cert.getSubjectDER();
            if (!ArrayUtil.areEqual(byArray, byArray2)) continue;
            return x509Cert;
        }
        return null;
    }

    static {
        C.disable_tracing();
        try {
            A = C.Specification(false);
        }
        catch (ParseException parseException) {
            throw new InternalError(parseException.toString());
        }
    }
}

