/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls;

import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.crypto.DHPrivateKey;
import com.enterprisedt.net.puretls.crypto.DHPublicKey;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SSLDHPrivateKey
extends DHPrivateKey {
    private SecureRandom B;
    private static int A = 80;

    public void initPrivateKey(BigInteger bigInteger, BigInteger bigInteger2, SecureRandom secureRandom) {
        this.g = bigInteger;
        this.p = bigInteger2;
        this.B = secureRandom;
        this.A();
    }

    public void initPrivateKey(SecureRandom secureRandom, int n2, boolean bl) {
        BigInteger bigInteger;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = new BigInteger("24");
        BigInteger bigInteger5 = new BigInteger("11");
        if (n2 % 8 != 0) {
            throw new InternalError("keylength must be a multiple of 8");
        }
        if (n2 < 768) {
            throw new InternalError("Keylength must be minimum 768");
        }
        int n3 = n2 / 8;
        byte[] byArray = new byte[n3];
        if (bl) {
            secureRandom.nextBytes(byArray);
            for (int i2 = 0; i2 < 8; ++i2) {
                byArray[i2] = -1;
                byArray[n3 - (i2 + 1)] = -1;
            }
            bigInteger = new BigInteger("0");
            bigInteger3 = bigInteger.setBit(64);
            bigInteger2 = new BigInteger(1, byArray);
        }
        this.g = new BigInteger("2");
        while (true) {
            if (bl) {
                bigInteger = bigInteger2.add(bigInteger3);
                if (!(bigInteger2 = bigInteger).isProbablePrime(2)) continue;
                SSLDebug.debug(8, "p passes quick check");
                BigInteger bigInteger6 = bigInteger2.shiftRight(1);
                if (!bigInteger6.isProbablePrime(A)) continue;
                SSLDebug.debug(8, "q is prime");
            } else {
                secureRandom.nextBytes(byArray);
                byArray[0] = (byte)(byArray[0] | 0xFFFFFF80);
                int n4 = n3 - 1;
                byArray[n4] = (byte)(byArray[n4] | 1);
                bigInteger2 = new BigInteger(1, byArray);
                BigInteger bigInteger7 = bigInteger2.mod(bigInteger4);
                BigInteger bigInteger8 = bigInteger2.subtract(bigInteger7);
                bigInteger2 = bigInteger5.add(bigInteger8);
            }
            SSLDebug.debug(8, "p candidate", bigInteger2.toByteArray());
            if (bigInteger2.isProbablePrime(A)) break;
            SSLDebug.debug(8, "p not prime");
        }
        this.B = secureRandom;
        this.p = bigInteger2;
        bigInteger = this.p.mod(bigInteger4);
        SSLDebug.debug(8, "P is prime" + this.p.isProbablePrime(A) + "mod 24=" + bigInteger);
        SSLDebug.debug(8, "p", this.p.toByteArray());
        this.A();
    }

    public byte[] keyAgree(DHPublicKey dHPublicKey, boolean bl) {
        if (bl) {
            BigInteger bigInteger = dHPublicKey.getp();
            BigInteger bigInteger2 = dHPublicKey.getg();
            if (bigInteger2 != null || bigInteger != null) {
                if (this.g.compareTo(bigInteger2) != 0) {
                    throw new Error("DH parameters don't match (g)");
                }
                if (this.p.compareTo(bigInteger) != 0) {
                    throw new Error("DH parameters don't match (p)");
                }
            }
        }
        BigInteger bigInteger = dHPublicKey.getY();
        return this.toBytes(bigInteger.modPow(this.X, this.p));
    }

    private void A() {
        int n2 = this.p.bitLength();
        int n3 = n2 / 8;
        int n4 = n2 % 8;
        if (n4 > 0) {
            ++n3;
        }
        byte[] byArray = new byte[n3];
        this.B.nextBytes(byArray);
        int n5 = n4 > 0 ? 8 - n4 : 1;
        byArray[0] = (byte)(byArray[0] & (byte)(255 >> n5));
        this.X = new BigInteger(1, byArray);
        SSLDebug.debug(8, "DH private", byArray);
        this.Y = this.g.modPow(this.X, this.p);
    }
}

