/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.puretls;

import com.enterprisedt.net.puretls.D;
import com.enterprisedt.net.puretls.LoadProviders;
import com.enterprisedt.net.puretls.SSLDebug;
import com.enterprisedt.net.puretls.SSLPeerCertVerifier;
import com.enterprisedt.net.puretls.cert.CertificateException;
import com.enterprisedt.net.puretls.cert.EAYDHParams;
import com.enterprisedt.net.puretls.cert.WrappedObject;
import com.enterprisedt.net.puretls.cert.X509Cert;
import com.enterprisedt.net.puretls.crypto.DHPrivateKey;
import com.enterprisedt.net.puretls.crypto.EAYEncryptedPrivateKey;
import com.enterprisedt.net.puretls.crypto.RandomStore;
import com.enterprisedt.net.puretls.sslg.SSLContextInt;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.Hashtable;
import java.util.Vector;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;

public class SSLContext
extends SSLContextInt {
    private static final int E = 128;
    private Hashtable M = new Hashtable();
    Vector G = new Vector();
    Vector C = null;
    PrivateKey K = null;
    PublicKey I = null;
    private int H = 1024;
    DHPrivateKey F = null;
    EAYDHParams B = null;
    KeyPair D = null;
    SecureRandom A = null;
    private boolean L = false;
    private SSLPeerCertVerifier J = null;

    public SSLContext() {
        LoadProviders.init();
    }

    public void seedRNG(byte[] byArray) {
        if (byArray == null) {
            byArray = new byte[]{};
        }
        if (this.A == null) {
            this.A = new SecureRandom(byArray);
        } else {
            this.A.setSeed(byArray);
        }
        this.A.setSeed(System.currentTimeMillis());
    }

    public void useRandomnessFile(String string, String string2) throws IOException, FileNotFoundException {
        this.A = null;
        try {
            this.A = RandomStore.readRandomStore(string, string2.getBytes());
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        if (this.A == null) {
            this.A = new SecureRandom();
            RandomStore.writeRandomStore(string, string2.getBytes(), this.A);
        }
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.K = privateKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.I = publicKey;
    }

    public void setPublicKeyFromCert(byte[] byArray) throws IOException {
        X509Cert x509Cert = new X509Cert(byArray);
        this.I = x509Cert.getPublicKey();
    }

    public void setCertificateChain(Vector vector) {
        this.C = vector;
    }

    public void loadPKCS12File(String string, String string2) {
        throw new InternalError("Not implemented");
    }

    public void loadEAYKeyFile(String string, String string2) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.loadEAYKeyFile(fileInputStream, string2);
    }

    public void loadEAYKeyFile(InputStream inputStream, String string) throws IOException {
        Object object;
        PrivateKey privateKey;
        int n2;
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n2 = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        StringBuffer stringBuffer = new StringBuffer();
        SSLDebug.debug(16, "Loading key file");
        if (!WrappedObject.findObject(bufferedReader, "PRIVATE KEY", stringBuffer)) {
            throw new IOException("Couldn't find private key in this file");
        }
        try {
            privateKey = EAYEncryptedPrivateKey.createPrivateKey(bufferedReader, stringBuffer.toString(), string.getBytes());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new IOException(illegalArgumentException.toString());
        }
        byteArrayInputStream = new ByteArrayInputStream(byArray2);
        bufferedReader = new BufferedReader(new InputStreamReader(byteArrayInputStream));
        Vector<byte[]> vector = new Vector<byte[]>();
        while ((object = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading certificate", (byte[])object);
            vector.insertElementAt((byte[])object, 0);
        }
        if (vector.size() == 0) {
            throw new IOException("Need at least one certificate");
        }
        object = new X509Cert((byte[])vector.elementAt(0));
        this.I = ((X509Cert)object).getPublicKey();
        this.K = privateKey;
        this.C = vector;
    }

    public void saveEAYKeyFile(String string, String string2) throws IOException, FileNotFoundException {
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        EAYEncryptedPrivateKey.writePrivateKey(this.K, string2.getBytes(), bufferedWriter);
        for (int i2 = 1; i2 <= this.C.size(); ++i2) {
            byte[] byArray = (byte[])this.C.elementAt(this.C.size() - i2);
            WrappedObject.writeHeader("CERTIFICATE", bufferedWriter);
            WrappedObject.writeObject(byArray, "CERTIFICATE", bufferedWriter);
        }
        bufferedWriter.flush();
        fileOutputStream.close();
    }

    public void setClientCertPrivKey(Certificate[] certificateArray, PrivateKey privateKey) throws CertificateException {
        try {
            this.C = new Vector();
            for (int i2 = 0; i2 < certificateArray.length; ++i2) {
                X509Cert x509Cert = new X509Cert(certificateArray[i2].getEncoded());
                this.C.insertElementAt(x509Cert.getDER(), 0);
            }
            X509Cert x509Cert = new X509Cert((byte[])this.C.get(0));
            this.I = x509Cert.getPublicKey();
            this.K = EAYEncryptedPrivateKey.createPrivateKey(privateKey, privateKey.getAlgorithm());
        }
        catch (CertificateEncodingException certificateEncodingException) {
            throw new CertificateException(certificateEncodingException.getMessage());
        }
        catch (IOException iOException) {
            throw new CertificateException(iOException.getMessage());
        }
    }

    public void loadRootCertificates(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.loadRootCertificates(fileInputStream);
        fileInputStream.close();
    }

    public void loadRootCertificates(InputStream inputStream) throws IOException {
        byte[] byArray;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((byArray = WrappedObject.loadObject(bufferedReader, "CERTIFICATE", null)) != null) {
            SSLDebug.debug(16, "Loading root", byArray);
            this.G.addElement(byArray);
        }
    }

    public void setRootCertificates(Vector vector) {
        this.G = vector;
    }

    public void loadDHParams(String string) throws FileNotFoundException, IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        this.loadDHParams(fileInputStream);
        fileInputStream.close();
    }

    public void loadDHParams(InputStream inputStream) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        byte[] byArray = WrappedObject.loadObject(bufferedReader, "DH PARAMETERS", null);
        if (byArray == null) {
            return;
        }
        SSLDebug.debug(16, "Loading DH params", byArray);
        this.B = new EAYDHParams(byArray);
    }

    public void saveDHParams(String string, int n2, boolean bl) throws IOException, FileNotFoundException {
        DHPrivateKey dHPrivateKey = this.A(n2, bl, true);
        EAYDHParams eAYDHParams = new EAYDHParams(dHPrivateKey.getg(), dHPrivateKey.getp());
        byte[] byArray = eAYDHParams.getEncoded();
        FileOutputStream fileOutputStream = new FileOutputStream(string);
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
        BufferedWriter bufferedWriter = new BufferedWriter(outputStreamWriter);
        WrappedObject.writeHeader("DH PARAMETERS", bufferedWriter);
        WrappedObject.writeObject(byArray, "DH PARAMETERS", bufferedWriter);
        bufferedWriter.flush();
        outputStreamWriter.flush();
        fileOutputStream.close();
    }

    Vector H() {
        return this.G;
    }

    Vector E() {
        return this.C;
    }

    PrivateKey B() {
        return this.K;
    }

    PublicKey G() {
        return this.I;
    }

    DHPrivateKey A(boolean bl) throws IOException {
        if (this.B == null) {
            throw new IOException("Must install DH parameters");
        }
        return this.A(this.H, this.L, bl);
    }

    private synchronized DHPrivateKey A(int n2, boolean bl, boolean bl2) {
        this.A();
        if (this.F == null || bl2) {
            this.F = DHPrivateKey.getInstance();
            if (this.B == null) {
                throw new InternalError("Can't generate ephemeral key without setting DH params");
            }
            this.F.initPrivateKey(this.B.getG(), this.B.getP(), this.A);
        }
        return this.F;
    }

    private synchronized KeyPair D() {
        this.A();
        if (this.D == null) {
            try {
                KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA", "CryptixEDT");
                keyPairGenerator.initialize(512, this.A);
                this.D = keyPairGenerator.generateKeyPair();
            }
            catch (Exception exception) {
                throw new InternalError(exception.toString());
            }
        }
        return this.D;
    }

    synchronized CryptixRSAPrivateKey F() {
        return (CryptixRSAPrivateKey)this.D().getPrivate();
    }

    synchronized CryptixRSAPublicKey I() {
        return (CryptixRSAPublicKey)this.D().getPublic();
    }

    synchronized byte[] C() {
        byte[] byArray = new byte[128];
        this.A();
        this.A.nextBytes(byArray);
        return byArray;
    }

    protected synchronized void storeSession(String string, D d2) {
        SSLDebug.debug(4, "Storing session under key " + string);
        this.M.put(string, d2);
    }

    protected synchronized D findSession(String string) {
        Object v = this.M.get(string);
        if (v == null) {
            SSLDebug.debug(4, "Could not recover cached session using key " + string);
            return null;
        }
        SSLDebug.debug(4, "Recovered cached session using key " + string);
        return (D)v;
    }

    protected synchronized void destroySession(String string) {
        SSLDebug.debug(4, "Destroying session" + string);
        this.M.remove(string);
    }

    private void A() {
        if (this.A != null) {
            return;
        }
        this.A = new SecureRandom();
    }

    public SSLPeerCertVerifier getVerifier() {
        return this.J;
    }

    public void setVerifier(SSLPeerCertVerifier sSLPeerCertVerifier) {
        this.J = sSLPeerCertVerifier;
    }
}

