/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.rsa;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;

public class SshRsaPublicKey
extends SshPublicKey {
    private static Logger D = Logger.getLogger(class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaPublicKey == null ? (class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaPublicKey = SshRsaPublicKey.class$("com.enterprisedt.net.j2ssh.transport.publickey.rsa.SshRsaPublicKey")) : class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaPublicKey);
    RSAPublicKey C;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$publickey$rsa$SshRsaPublicKey;

    public SshRsaPublicKey(RSAPublicKey rSAPublicKey) {
        this.C = rSAPublicKey;
    }

    public SshRsaPublicKey(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                String string2 = "Header '" + string + "' does not match algorithm '" + this.getAlgorithmName() + "'";
                D.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(bigInteger2, bigInteger);
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                this.C = (RSAPublicKey)keyFactory.generatePublic(rSAPublicKeySpec);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                D.error("SshRsaPublicKey()", noSuchAlgorithmException);
                throw new InvalidSshKeyException(noSuchAlgorithmException);
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                D.error("SshRsaPublicKey()", invalidKeySpecException);
                throw new InvalidSshKeyException(invalidKeySpecException);
            }
        }
        catch (IOException iOException) {
            D.error("SshRsaPublicKey()", iOException);
            throw new InvalidSshKeyException(iOException);
        }
    }

    public String getAlgorithmName() {
        return "ssh-rsa";
    }

    public int getBitLength() {
        return this.C.getModulus().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString(this.getAlgorithmName());
            byteArrayWriter.writeBigInteger(this.C.getPublicExponent());
            byteArrayWriter.writeBigInteger(this.C.getModulus());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean verifySignature(byte[] byArray, byte[] byArray2) throws InvalidSshKeySignatureException {
        try {
            Signature signature = Signature.getInstance("SHA1withRSA", "CryptixEDT");
            signature.initVerify(this.C);
            signature.update(byArray2);
            return signature.verify(byArray);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new InvalidSshKeySignatureException();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InvalidSshKeySignatureException(noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new InvalidSshKeySignatureException(invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw new InvalidSshKeySignatureException(signatureException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

