/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey.dsa;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeySignatureException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPublicKey;
import com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssPublicKey;
import com.enterprisedt.net.j2ssh.util.SimpleASNReader;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.Signature;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;

class A
extends SshPrivateKey {
    private Logger B = Logger.getLogger("com.enterprisedt.net.j2ssh.transport.publickey.dsa.SshDssPrivateKey");
    DSAPrivateKey A;

    public A(DSAPrivateKey dSAPrivateKey) {
        this.A = dSAPrivateKey;
    }

    public A(byte[] byArray) throws InvalidSshKeyException {
        try {
            ByteArrayReader byteArrayReader = new ByteArrayReader(byArray);
            String string = byteArrayReader.readString();
            if (!string.equals(this.getAlgorithmName())) {
                String string2 = "Header '" + string + "' does not match algorithm name '" + this.getAlgorithmName() + "'";
                this.B.error(string2);
                throw new InvalidSshKeyException(string2);
            }
            BigInteger bigInteger = byteArrayReader.readBigInteger();
            BigInteger bigInteger2 = byteArrayReader.readBigInteger();
            BigInteger bigInteger3 = byteArrayReader.readBigInteger();
            BigInteger bigInteger4 = byteArrayReader.readBigInteger();
            DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(bigInteger4, bigInteger, bigInteger2, bigInteger3);
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            this.A = (DSAPrivateKey)keyFactory.generatePrivate(dSAPrivateKeySpec);
        }
        catch (InvalidSshKeyException invalidSshKeyException) {
            throw invalidSshKeyException;
        }
        catch (Exception exception) {
            String string = "Failed to create private key";
            this.B.error(string, exception);
            throw new InvalidSshKeyException(exception);
        }
    }

    public boolean equals(Object object) {
        if (object instanceof A) {
            return this.A.equals(((A)object).A);
        }
        return false;
    }

    public int hashCode() {
        return this.A.hashCode();
    }

    public String getAlgorithmName() {
        return "ssh-dss";
    }

    public int getBitLength() {
        return this.A.getX().bitLength();
    }

    public byte[] getEncoded() {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byteArrayWriter.writeString("ssh-dss");
            byteArrayWriter.writeBigInteger(this.A.getParams().getP());
            byteArrayWriter.writeBigInteger(this.A.getParams().getQ());
            byteArrayWriter.writeBigInteger(this.A.getParams().getG());
            byteArrayWriter.writeBigInteger(this.A.getX());
            return byteArrayWriter.toByteArray();
        }
        catch (IOException iOException) {
            this.B.error("getPublicKey()", iOException);
            return null;
        }
    }

    public SshPublicKey getPublicKey() {
        try {
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(this.A(), this.A.getParams().getP(), this.A.getParams().getQ(), this.A.getParams().getG());
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            return new SshDssPublicKey((DSAPublicKey)keyFactory.generatePublic(dSAPublicKeySpec));
        }
        catch (Exception exception) {
            this.B.error("getPublicKey()", exception);
            return null;
        }
    }

    public byte[] generateSignature(byte[] byArray) throws InvalidSshKeySignatureException {
        try {
            Object object;
            Signature signature = Signature.getInstance("SHA1withDSA", "CryptixEDT");
            signature.initSign(this.A);
            signature.update(byArray);
            byte[] byArray2 = signature.sign();
            byte[] byArray3 = new byte[40];
            SimpleASNReader simpleASNReader = new SimpleASNReader(byArray2);
            simpleASNReader.getByte();
            simpleASNReader.getLength();
            simpleASNReader.getByte();
            byte[] byArray4 = simpleASNReader.getData();
            simpleASNReader.getByte();
            byte[] byArray5 = simpleASNReader.getData();
            if (byArray4.length >= 20) {
                System.arraycopy(byArray4, byArray4.length - 20, byArray3, 0, 20);
            } else {
                System.arraycopy(byArray4, 0, byArray3, 20 - byArray4.length, byArray4.length);
            }
            if (byArray5.length >= 20) {
                System.arraycopy(byArray5, byArray5.length - 20, byArray3, 20, 20);
            } else {
                System.arraycopy(byArray5, 0, byArray3, 20 + (20 - byArray5.length), byArray5.length);
            }
            if (this.B.isDebugEnabled()) {
                int n2;
                this.B.debug("s length is " + String.valueOf(byArray5.length));
                this.B.debug("r length is " + String.valueOf(byArray4.length));
                object = "";
                for (n2 = 0; n2 < byArray2.length; ++n2) {
                    object = (String)object + Integer.toHexString(byArray2[n2] & 0xFF) + " ";
                }
                this.B.debug("Java signature is " + (String)object);
                object = "";
                for (n2 = 0; n2 < byArray3.length; ++n2) {
                    object = (String)object + Integer.toHexString(byArray3[n2] & 0xFF) + " ";
                }
                this.B.debug("SSH signature is " + (String)object);
            }
            object = new ByteArrayWriter();
            ((ByteArrayWriter)object).writeString(this.getAlgorithmName());
            ((ByteArrayWriter)object).writeBinaryString(byArray3);
            return ((ByteArrayOutputStream)object).toByteArray();
        }
        catch (Exception exception) {
            throw new InvalidSshKeySignatureException(exception);
        }
    }

    private BigInteger A() {
        return this.A.getParams().getG().modPow(this.A.getX(), this.A.getParams().getP());
    }
}

