/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport.publickey;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.publickey.InvalidSshKeyException;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPair;
import com.enterprisedt.net.j2ssh.transport.publickey.SshKeyPairFactory;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKey;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormat;
import com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFormatFactory;
import com.enterprisedt.util.debug.Logger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class SshPrivateKeyFile {
    private static Logger A = Logger.getLogger(class$com$enterprisedt$net$j2ssh$transport$publickey$SshPrivateKeyFile == null ? (class$com$enterprisedt$net$j2ssh$transport$publickey$SshPrivateKeyFile = SshPrivateKeyFile.class$("com.enterprisedt.net.j2ssh.transport.publickey.SshPrivateKeyFile")) : class$com$enterprisedt$net$j2ssh$transport$publickey$SshPrivateKeyFile);
    private SshPrivateKeyFormat C;
    private byte[] B;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$publickey$SshPrivateKeyFile;

    protected SshPrivateKeyFile(byte[] byArray, SshPrivateKeyFormat sshPrivateKeyFormat) {
        this.B = byArray;
        this.C = sshPrivateKeyFormat;
    }

    public byte[] getBytes() {
        return this.B;
    }

    public byte[] getKeyBlob(String string) throws InvalidSshKeyException {
        return this.C.decryptKeyblob(this.B, string);
    }

    public void changePassphrase(String string, String string2) throws InvalidSshKeyException {
        byte[] byArray = this.C.decryptKeyblob(this.B, string);
        this.B = this.C.encryptKeyblob(byArray, string2);
    }

    public static SshPrivateKeyFile parse(byte[] byArray) throws InvalidSshKeyException {
        if (byArray == null) {
            throw new InvalidSshKeyException("Key data is null");
        }
        A.debug("Parsing private key file");
        SshPrivateKeyFormat sshPrivateKeyFormat = SshPrivateKeyFormatFactory.newInstance(SshPrivateKeyFormatFactory.getDefaultFormatType());
        boolean bl = sshPrivateKeyFormat.isFormatted(byArray);
        if (!bl) {
            A.debug("Private key is not in the default format, attempting parse with other supported formats");
            Iterator iterator = SshPrivateKeyFormatFactory.getSupportedFormats().iterator();
            while (iterator.hasNext() && !bl) {
                String string = (String)iterator.next();
                A.debug("Attempting " + string);
                sshPrivateKeyFormat = SshPrivateKeyFormatFactory.newInstance(string);
                bl = sshPrivateKeyFormat.isFormatted(byArray);
            }
        }
        if (bl) {
            return new SshPrivateKeyFile(byArray, sshPrivateKeyFormat);
        }
        throw new InvalidSshKeyException("The key format is not a supported format");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SshPrivateKeyFile parse(File file) throws InvalidSshKeyException, IOException {
        SshPrivateKeyFile sshPrivateKeyFile = null;
        FileInputStream fileInputStream = new FileInputStream(file);
        try {
            sshPrivateKeyFile = SshPrivateKeyFile.parse(fileInputStream);
        }
        finally {
            fileInputStream.close();
        }
        return sshPrivateKeyFile;
    }

    public static SshPrivateKeyFile parse(InputStream inputStream) throws InvalidSshKeyException, IOException {
        byte[] byArray = new byte[1024];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(byArray.length);
        int n2 = 0;
        while ((n2 = inputStream.read(byArray)) > 0) {
            byteArrayOutputStream.write(byArray, 0, n2);
        }
        return SshPrivateKeyFile.parse(byteArrayOutputStream.toByteArray());
    }

    public boolean isPassphraseProtected() {
        return this.C.isPassphraseProtected(this.B);
    }

    public static SshPrivateKeyFile create(SshPrivateKey sshPrivateKey, String string, SshPrivateKeyFormat sshPrivateKeyFormat) throws InvalidSshKeyException {
        byte[] byArray = sshPrivateKeyFormat.encryptKeyblob(sshPrivateKey.getEncoded(), string);
        return new SshPrivateKeyFile(byArray, sshPrivateKeyFormat);
    }

    public void setFormat(SshPrivateKeyFormat sshPrivateKeyFormat, String string) throws InvalidSshKeyException {
        byte[] byArray = this.C.decryptKeyblob(this.B, string);
        this.C = sshPrivateKeyFormat;
        this.B = this.C.encryptKeyblob(byArray, string);
    }

    public SshPrivateKeyFormat getFormat() {
        return this.C;
    }

    public SshPrivateKey toPrivateKey(String string) throws InvalidSshKeyException {
        try {
            byte[] byArray = this.C.decryptKeyblob(this.B, string);
            SshKeyPair sshKeyPair = SshKeyPairFactory.newInstance(this.A(byArray));
            return sshKeyPair.decodePrivateKey(byArray);
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            throw new InvalidSshKeyException("The public key algorithm for this private key is not supported", algorithmNotSupportedException);
        }
    }

    public String toString() {
        return new String(this.B);
    }

    private String A(byte[] byArray) {
        return ByteArrayReader.readString(byArray, 0);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

