/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.SshThread;
import com.enterprisedt.net.j2ssh.configuration.ConfigurationLoader;
import com.enterprisedt.net.j2ssh.configuration.SshConnectionProperties;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.net.TransportProvider;
import com.enterprisedt.net.j2ssh.transport.A;
import com.enterprisedt.net.j2ssh.transport.AlgorithmInitializationException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotAgreedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmNotSupportedException;
import com.enterprisedt.net.j2ssh.transport.AlgorithmOperationException;
import com.enterprisedt.net.j2ssh.transport.B;
import com.enterprisedt.net.j2ssh.transport.HostKeyVerification;
import com.enterprisedt.net.j2ssh.transport.MessageAlreadyRegisteredException;
import com.enterprisedt.net.j2ssh.transport.MessageNotRegisteredException;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.net.j2ssh.transport.SshMessageStore;
import com.enterprisedt.net.j2ssh.transport.SshMsgDebug;
import com.enterprisedt.net.j2ssh.transport.SshMsgDisconnect;
import com.enterprisedt.net.j2ssh.transport.SshMsgIgnore;
import com.enterprisedt.net.j2ssh.transport.SshMsgKexInit;
import com.enterprisedt.net.j2ssh.transport.SshMsgNewKeys;
import com.enterprisedt.net.j2ssh.transport.SshMsgUnimplemented;
import com.enterprisedt.net.j2ssh.transport.TransportProtocol;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolAlgorithmSync;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolEventHandler;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolException;
import com.enterprisedt.net.j2ssh.transport.TransportProtocolState;
import com.enterprisedt.net.j2ssh.transport.kex.KeyExchangeException;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchange;
import com.enterprisedt.net.j2ssh.transport.kex.SshKeyExchangeFactory;
import com.enterprisedt.net.j2ssh.util.Hash;
import com.enterprisedt.util.debug.Level;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.math.BigInteger;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public abstract class TransportProtocolCommon
implements TransportProtocol,
Runnable {
    protected static Logger log = Logger.getLogger(class$com$enterprisedt$net$j2ssh$transport$TransportProtocolCommon == null ? (class$com$enterprisedt$net$j2ssh$transport$TransportProtocolCommon = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.TransportProtocolCommon")) : class$com$enterprisedt$net$j2ssh$transport$TransportProtocolCommon);
    private static int F = 1;
    public static final int EOL_CRLF = 1;
    public static final int EOL_LF = 2;
    public static final String PROTOCOL_VERSION = "2.0";
    public static String SOFTWARE_VERSION_COMMENTS = "http://www.sshtools.com " + ConfigurationLoader.getVersionString("J2SSH", "j2ssh.properties");
    private int B = F++;
    protected BigInteger k = null;
    protected Boolean completeOnNewKeys = new Boolean(false);
    protected HostKeyVerification hosts;
    protected Map kexs = new HashMap();
    private boolean E = false;
    protected SshConnectionProperties properties;
    protected SshMessageStore messageStore = new SshMessageStore();
    protected SshMsgKexInit clientKexInit = null;
    protected SshMsgKexInit serverKexInit = null;
    protected String clientIdent = null;
    protected String serverIdent = null;
    protected TransportProtocolAlgorithmSync algorithmsIn;
    protected TransportProtocolAlgorithmSync algorithmsOut;
    protected TransportProtocolState state = new TransportProtocolState();
    private byte[] L = null;
    protected byte[] sessionIdentifier = null;
    protected byte[] hostKey = null;
    protected byte[] signature = null;
    private Vector D = new Vector();
    private List P = new ArrayList();
    private Map G = new HashMap();
    private Object J = new Object();
    TransportProvider H;
    private SshThread M;
    private long I = 3540000L;
    private long O = 996147200L;
    private long A = System.currentTimeMillis();
    private long K = 0L;
    protected A sshIn;
    protected B sshOut;
    private int C = 1;
    private Vector N = new Vector();
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$TransportProtocolCommon;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$SshMsgDisconnect;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$SshMsgIgnore;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$SshMsgUnimplemented;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$SshMsgDebug;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$SshMsgKexInit;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$transport$SshMsgNewKeys;

    public int getConnectionId() {
        return this.B;
    }

    public int getRemoteEOL() {
        return this.C;
    }

    public TransportProtocolState getState() {
        return this.state;
    }

    public SshConnectionProperties getProperties() {
        return this.properties;
    }

    protected abstract void onDisconnect();

    public void disconnect(String string) {
        if (log.isDebugEnabled()) {
            log.debug("Disconnect: " + string);
        }
        try {
            this.state.setValue(5);
            this.state.setDisconnectReason(string);
            this.sendDisconnect(11, string);
        }
        catch (Exception exception) {
            log.warn("Failed to send disconnect", exception);
        }
    }

    public void setSendIgnore(boolean bl) {
        this.E = bl;
    }

    public void setKexTimeout(long l2) throws TransportProtocolException {
        if (l2 < 60L) {
            throw new TransportProtocolException("Keys can only be re-exchanged every minute or more");
        }
        this.I = l2 * 1000L;
    }

    public void setKexTransferLimit(long l2) throws TransportProtocolException {
        if (l2 < 10L) {
            throw new TransportProtocolException("Keys can only be re-exchanged after every 10k of data, or more");
        }
        this.O = l2 * 1024L;
    }

    public long getOutgoingByteCount() {
        return this.sshOut.A();
    }

    public long getIncomingByteCount() {
        return this.sshIn.A();
    }

    public void addEventHandler(TransportProtocolEventHandler transportProtocolEventHandler) {
        if (transportProtocolEventHandler != null) {
            this.D.add(transportProtocolEventHandler);
        }
    }

    public abstract void registerTransportMessages() throws MessageAlreadyRegisteredException;

    public byte[] getSessionIdentifier() {
        return (byte[])this.sessionIdentifier.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.state.setValue(2);
            log.debug("Registering transport protocol messages with inputstream");
            this.algorithmsOut = new TransportProtocolAlgorithmSync();
            this.algorithmsIn = new TransportProtocolAlgorithmSync();
            this.sshIn = new A(this, this.H.getInputStream(), this.algorithmsIn);
            this.sshOut = new B(this.H.getOutputStream(), this, this.algorithmsOut);
            this.messageStore.registerMessage(1, class$com$enterprisedt$net$j2ssh$transport$SshMsgDisconnect == null ? (class$com$enterprisedt$net$j2ssh$transport$SshMsgDisconnect = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgDisconnect")) : class$com$enterprisedt$net$j2ssh$transport$SshMsgDisconnect);
            this.messageStore.registerMessage(2, class$com$enterprisedt$net$j2ssh$transport$SshMsgIgnore == null ? (class$com$enterprisedt$net$j2ssh$transport$SshMsgIgnore = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgIgnore")) : class$com$enterprisedt$net$j2ssh$transport$SshMsgIgnore);
            this.messageStore.registerMessage(3, class$com$enterprisedt$net$j2ssh$transport$SshMsgUnimplemented == null ? (class$com$enterprisedt$net$j2ssh$transport$SshMsgUnimplemented = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgUnimplemented")) : class$com$enterprisedt$net$j2ssh$transport$SshMsgUnimplemented);
            this.messageStore.registerMessage(4, class$com$enterprisedt$net$j2ssh$transport$SshMsgDebug == null ? (class$com$enterprisedt$net$j2ssh$transport$SshMsgDebug = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgDebug")) : class$com$enterprisedt$net$j2ssh$transport$SshMsgDebug);
            this.messageStore.registerMessage(20, class$com$enterprisedt$net$j2ssh$transport$SshMsgKexInit == null ? (class$com$enterprisedt$net$j2ssh$transport$SshMsgKexInit = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgKexInit")) : class$com$enterprisedt$net$j2ssh$transport$SshMsgKexInit);
            this.messageStore.registerMessage(21, class$com$enterprisedt$net$j2ssh$transport$SshMsgNewKeys == null ? (class$com$enterprisedt$net$j2ssh$transport$SshMsgNewKeys = TransportProtocolCommon.class$("com.enterprisedt.net.j2ssh.transport.SshMsgNewKeys")) : class$com$enterprisedt$net$j2ssh$transport$SshMsgNewKeys);
            this.registerTransportMessages();
            List list = SshKeyExchangeFactory.getSupportedKeyExchanges();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                SshKeyExchange sshKeyExchange = SshKeyExchangeFactory.newInstance(string);
                sshKeyExchange.init(this);
                this.kexs.put(string, sshKeyExchange);
            }
            this.setLocalIdent();
            this.A();
            this.startBinaryPacketProtocol();
        }
        catch (Throwable throwable) {
            if (throwable instanceof IOException) {
                this.state.setLastError((IOException)throwable);
            }
            if (this.state.getValue() != 5) {
                log.error("The Transport Protocol thread failed", throwable);
                this.stop();
                this.state.setValue(5);
            }
        }
        finally {
            this.M = null;
        }
        log.debug("The Transport Protocol has been stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sendMessage(SshMessage sshMessage, Object object) throws IOException {
        if (log.isEnabledFor(Level.ALL)) {
            log.log(Level.ALL, sshMessage.toString(), null);
        } else if (log.isDebugEnabled()) {
            log.debug("Sending " + sshMessage.getMessageName());
        }
        int n2 = this.state.getValue();
        if (object instanceof SshKeyExchange || object instanceof TransportProtocolCommon || n2 == 4) {
            this.sshOut.A(sshMessage);
            if (n2 == 4 && this.E) {
                byte[] byArray = new byte[1];
                ConfigurationLoader.getRND().nextBytes(byArray);
                byte[] byArray2 = new byte[(byArray[0] & 0xFF) + 1];
                ConfigurationLoader.getRND().nextBytes(byArray2);
                SshMsgIgnore sshMsgIgnore = new SshMsgIgnore(new String(byArray2));
                if (log.isDebugEnabled()) {
                    log.debug("Sending " + sshMsgIgnore.getMessageName());
                }
                this.sshOut.A(sshMsgIgnore);
            }
        } else if (n2 == 3) {
            log.debug("Adding to message queue whilst in key exchange");
            List list = this.P;
            synchronized (list) {
                this.P.add(sshMessage);
            }
        } else {
            throw new TransportProtocolException("The transport protocol is disconnected");
        }
    }

    protected abstract void onStartTransportProtocol() throws IOException;

    public void startTransportProtocol(TransportProvider transportProvider) throws IOException {
        this.H = transportProvider;
        log.debug("Starting transport protocol");
        this.M = new SshThread(this, "Transport protocol", true);
        this.M.start();
        this.onStartTransportProtocol();
    }

    public String getUnderlyingProviderDetail() {
        return this.H.getProviderDetail();
    }

    public void unregisterMessage(Integer n2, SshMessageStore sshMessageStore) throws MessageNotRegisteredException {
        if (log.isDebugEnabled()) {
            log.debug("Unregistering message Id " + n2.toString());
        }
        if (!this.G.containsKey(n2)) {
            throw new MessageNotRegisteredException(n2);
        }
        SshMessageStore sshMessageStore2 = (SshMessageStore)this.G.get(n2);
        if (!sshMessageStore.equals(sshMessageStore2)) {
            throw new MessageNotRegisteredException(n2, sshMessageStore);
        }
        this.G.remove(n2);
    }

    protected abstract String getDecryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getEncryptionAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getInputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setLocalIdent();

    public abstract String getLocalId();

    protected abstract void setLocalKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getLocalKexInit();

    protected abstract String getOutputStreamCompAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract String getOutputStreamMacAlgorithm() throws AlgorithmNotAgreedException;

    protected abstract void setRemoteIdent(String var1);

    public abstract String getRemoteId();

    protected abstract void setRemoteKexInit(SshMsgKexInit var1);

    protected abstract SshMsgKexInit getRemoteKexInit();

    protected abstract void performKeyExchange(SshKeyExchange var1) throws IOException, KeyExchangeException;

    protected String getKexAlgorithm() throws AlgorithmNotAgreedException {
        return this.determineAlgorithm(this.clientKexInit.getSupportedKex(), this.serverKexInit.getSupportedKex());
    }

    public boolean isConnected() {
        return this.state.getValue() == 4 || this.state.getValue() == 3;
    }

    protected void beginKeyExchange() throws IOException, KeyExchangeException {
        log.debug("Starting key exchange");
        String string = "";
        try {
            string = this.getKexAlgorithm();
            if (log.isDebugEnabled()) {
                log.debug("Key exchange algorithm: " + string);
            }
            SshKeyExchange sshKeyExchange = (SshKeyExchange)this.kexs.get(string);
            this.performKeyExchange(sshKeyExchange);
            this.L = sshKeyExchange.getExchangeHash();
            if (this.sessionIdentifier == null) {
                this.sessionIdentifier = new byte[this.L.length];
                System.arraycopy(this.L, 0, this.sessionIdentifier, 0, this.sessionIdentifier.length);
                this.M.setSessionId(this.sessionIdentifier);
            }
            this.hostKey = sshKeyExchange.getHostKey();
            this.signature = sshKeyExchange.getSignature();
            this.k = sshKeyExchange.getSecret();
            this.sendNewKeys();
            sshKeyExchange.reset();
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            log.debug("beginKeyExchange()", algorithmNotAgreedException);
            this.sendDisconnect(3, "No suitable key exchange algorithm was agreed");
            throw new KeyExchangeException("No suitable key exchange algorithm could be agreed.", algorithmNotAgreedException);
        }
    }

    protected SshMsgKexInit createLocalKexInit() throws IOException {
        return new SshMsgKexInit(this.properties);
    }

    protected void onCorruptMac() {
        log.fatal("Corrupt Mac on Input");
        this.sendDisconnect(5, "Corrupt Mac on input", new SshException("Corrupt Mac on Imput"));
    }

    protected abstract void onMessageReceived(SshMessage var1) throws IOException;

    protected void sendDisconnect(int n2, String string) {
        SshMsgDisconnect sshMsgDisconnect = new SshMsgDisconnect(n2, string, "");
        if (log.isDebugEnabled()) {
            log.debug("sendDisconnect(" + n2 + ",'" + string + "')");
        }
        try {
            this.sendMessage(sshMsgDisconnect, this);
            this.stop();
        }
        catch (Exception exception) {
            log.warn("Failed to send disconnect", exception);
        }
    }

    protected void sendDisconnect(int n2, String string, IOException iOException) {
        this.state.setLastError(iOException);
        this.sendDisconnect(n2, string);
    }

    protected void sendKeyExchangeInit() throws IOException {
        this.setLocalKexInit(this.createLocalKexInit());
        this.sendMessage(this.getLocalKexInit(), this);
        this.state.setValue(3);
    }

    protected void sendNewKeys() throws IOException {
        SshMsgNewKeys sshMsgNewKeys = new SshMsgNewKeys();
        this.sendMessage(sshMsgNewKeys, this);
        this.algorithmsOut.lock();
        int[] nArray = new int[]{21};
        sshMsgNewKeys = (SshMsgNewKeys)this.readMessage(nArray);
        this.completeKeyExchange();
    }

    protected abstract void setupNewKeys(byte[] var1, byte[] var2, byte[] var3, byte[] var4, byte[] var5, byte[] var6) throws AlgorithmNotAgreedException, AlgorithmOperationException, AlgorithmNotSupportedException, AlgorithmInitializationException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void completeKeyExchange() throws IOException {
        log.debug("Completing key exchange");
        try {
            Iterator iterator;
            log.debug("Making keys from key exchange output");
            byte[] byArray = this.A('C');
            byte[] byArray2 = this.A('A');
            byte[] byArray3 = this.A('D');
            byte[] byArray4 = this.A('B');
            byte[] byArray5 = this.A('E');
            byte[] byArray6 = this.A('F');
            log.debug("Creating algorithm objects");
            try {
                this.setupNewKeys(byArray, byArray2, byArray3, byArray4, byArray5, byArray6);
                iterator = null;
                this.clientKexInit = null;
                this.serverKexInit = null;
                this.algorithmsIn.release();
                this.algorithmsOut.release();
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                this.clientKexInit = null;
                this.serverKexInit = null;
                this.algorithmsIn.release();
                this.algorithmsOut.release();
                throw throwable;
            }
            this.state.setValue(4);
            List list = this.P;
            synchronized (list) {
                iterator = this.P.iterator();
                log.debug("Sending queued messages");
                while (iterator.hasNext()) {
                    SshMessage sshMessage = (SshMessage)iterator.next();
                    this.sendMessage(sshMessage, this);
                }
                this.P.clear();
            }
        }
        catch (AlgorithmNotAgreedException algorithmNotAgreedException) {
            this.sendDisconnect(3, "Algorithm not agreed");
            throw new TransportProtocolException("The connection was disconnected because an algorithm could not be agreed", algorithmNotAgreedException);
        }
        catch (AlgorithmNotSupportedException algorithmNotSupportedException) {
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("The connection was disconnected because an algorithm class could not be loaded", algorithmNotSupportedException);
        }
        catch (AlgorithmOperationException algorithmOperationException) {
            this.sendDisconnect(3, "Algorithm operation error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm operation error", algorithmOperationException);
        }
        catch (AlgorithmInitializationException algorithmInitializationException) {
            this.sendDisconnect(3, "Algorithm initialization error");
            throw new TransportProtocolException("The connection was disconnected because of an algorithm initialization error", algorithmInitializationException);
        }
    }

    protected List getEventHandlers() {
        return this.D;
    }

    protected String determineAlgorithm(List list, List list2, String string) throws AlgorithmNotAgreedException {
        if (string != null && list.contains(string) && list2.contains(string)) {
            return string;
        }
        return this.determineAlgorithm(list, list2);
    }

    protected String determineAlgorithm(List list, List list2) throws AlgorithmNotAgreedException {
        if (log.isDebugEnabled()) {
            log.debug("Determine Algorithm");
            log.debug("Client Algorithms: " + list.toString());
            log.debug("Server Algorithms: " + list2.toString());
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Iterator iterator2 = list2.iterator();
            while (iterator2.hasNext()) {
                String string2 = (String)iterator2.next();
                if (!string.equals(string2)) continue;
                log.debug("Returning " + string);
                return string;
            }
        }
        throw new AlgorithmNotAgreedException("Could not agree algorithm");
    }

    protected void startBinaryPacketProtocol() throws IOException {
        this.sendKeyExchangeInit();
        block7: while (this.state.getValue() != 5) {
            SshMessage sshMessage = this.processMessages();
            switch (sshMessage.getMessageId()) {
                case 20: {
                    this.A((SshMsgKexInit)sshMessage);
                    continue block7;
                }
                case 1: {
                    this.A((SshMsgDisconnect)sshMessage);
                    continue block7;
                }
                case 2: {
                    this.A((SshMsgIgnore)sshMessage);
                    continue block7;
                }
                case 3: {
                    this.A((SshMsgUnimplemented)sshMessage);
                    continue block7;
                }
                case 4: {
                    this.A((SshMsgDebug)sshMessage);
                    continue block7;
                }
            }
            this.onMessageReceived(sshMessage);
        }
    }

    protected final void stop() {
        log.debug("stop() called");
        this.onDisconnect();
        Iterator iterator = this.D.iterator();
        while (iterator.hasNext()) {
            TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
            transportProtocolEventHandler.onDisconnect(this);
        }
        if (this.messageStore != null) {
            this.messageStore.close();
        }
        iterator = this.N.iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            try {
                sshMessageStore.close();
            }
            catch (Exception exception) {}
        }
        this.N.clear();
        this.messageStore = null;
        try {
            this.H.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private byte[] A(char c2) throws IOException {
        try {
            ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
            byte[] byArray = null;
            Hash hash = new Hash("SHA");
            hash.putBigInteger(this.k);
            hash.putBytes(this.L);
            hash.putByte((byte)c2);
            hash.putBytes(this.sessionIdentifier);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            hash.reset();
            hash.putBigInteger(this.k);
            hash.putBytes(this.L);
            hash.putBytes(byArray);
            byArray = hash.doFinal();
            byteArrayWriter.write(byArray);
            return byteArrayWriter.toByteArray();
        }
        catch (NoSuchProviderException noSuchProviderException) {
            log.debug("makeSshKey()", noSuchProviderException);
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Unknown provider", noSuchProviderException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.debug("makeSshKey()", noSuchAlgorithmException);
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("SHA algorithm not supported", noSuchAlgorithmException);
        }
        catch (IOException iOException) {
            log.debug("makeSshKey()", iOException);
            this.sendDisconnect(3, "Application error");
            throw new TransportProtocolException("Error writing key data", iOException);
        }
    }

    private void A() throws IOException {
        String string;
        String string2 = "";
        log.debug("Negotiating protocol version");
        log.debug("Local identification: " + this.getLocalId());
        String string3 = this.getLocalId() + "\r\n";
        this.H.getOutputStream().write(string3.getBytes());
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 255;
        while (!string2.startsWith("SSH-") && stringBuffer.length() < n2) {
            char c2;
            while ((c2 = (char)this.H.getInputStream().read()) != '\n' && stringBuffer.length() < n2) {
                stringBuffer.append(c2);
            }
            string2 = stringBuffer.toString();
            this.C = string2.endsWith("\r") ? 1 : 2;
            log.debug("EOL is guessed at " + (this.C == 1 ? "CR+LF" : "LF"));
            string2 = string2.trim();
        }
        int n3 = string2.indexOf("-");
        int n4 = string2.indexOf("-", n3 + 1);
        this.setRemoteIdent(string2.trim());
        if (log.isDebugEnabled()) {
            log.debug("Remote identification: " + this.getRemoteId());
        }
        if (!(string = string2.substring(n3 + 1, n4)).equals(PROTOCOL_VERSION) && !string.equals("1.99")) {
            log.fatal("The remote computer does not support protocol version 2.0");
            throw new TransportProtocolException("The protocol version of the remote computer is not supported!");
        }
        log.debug("Protocol negotiation complete");
    }

    private void A(SshMsgDebug sshMsgDebug) {
        log.debug(sshMsgDebug.getMessage());
    }

    private void A(SshMsgDisconnect sshMsgDisconnect) throws IOException {
        log.debug("The remote computer disconnected: " + sshMsgDisconnect.getDescription());
        this.state.setValue(5);
        this.state.setDisconnectReason(sshMsgDisconnect.getDescription());
        this.stop();
    }

    private void A(SshMsgIgnore sshMsgIgnore) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void A(SshMsgKexInit sshMsgKexInit) throws IOException {
        log.debug("Received remote key exchange init message");
        Object object = this.J;
        synchronized (object) {
            this.setRemoteKexInit(sshMsgKexInit);
            if (this.state.getValue() != 3) {
                this.sendKeyExchangeInit();
            }
            this.beginKeyExchange();
        }
    }

    private void A(SshMsgUnimplemented sshMsgUnimplemented) {
        if (log.isDebugEnabled()) {
            log.debug("The message with sequence no " + sshMsgUnimplemented.getSequenceNo() + " was reported as unimplemented by the remote end.");
        }
    }

    public SshMessage readMessage(int[] nArray) throws IOException {
        byte[] byArray = null;
        block6: while (this.state.getValue() != 5) {
            SshMessage sshMessage;
            boolean bl = false;
            while (!bl) {
                byArray = this.sshIn.B();
                bl = true;
            }
            Integer n2 = SshMessage.getMessageId(byArray);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                if (nArray[i2] != n2) continue;
                if (this.messageStore.isRegisteredMessage(n2)) {
                    sshMessage = this.messageStore.createMessage(byArray);
                    if (log.isEnabledFor(Level.ALL)) {
                        log.log(Level.ALL, "Received registered message: " + sshMessage.toString(), null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("Received registered message: " + sshMessage.getMessageName());
                    }
                    return sshMessage;
                }
                SshMessageStore sshMessageStore = this.A(n2);
                sshMessage = sshMessageStore.createMessage(byArray);
                if (log.isEnabledFor(Level.ALL)) {
                    log.log(Level.ALL, "Received unregistered message: " + sshMessage.toString(), null);
                } else if (log.isDebugEnabled()) {
                    log.debug("Received unregistered message: " + sshMessage.getMessageName());
                }
                return sshMessage;
            }
            if (this.messageStore.isRegisteredMessage(n2)) {
                sshMessage = this.messageStore.createMessage(byArray);
                if (log.isEnabledFor(Level.ALL)) {
                    log.log(Level.ALL, "Received registered message: " + sshMessage.toString(), null);
                } else if (log.isDebugEnabled()) {
                    log.debug("Received registered message: " + sshMessage.getMessageName());
                }
                switch (n2) {
                    case 1: {
                        this.A((SshMsgDisconnect)sshMessage);
                        continue block6;
                    }
                    case 2: {
                        this.A((SshMsgIgnore)sshMessage);
                        continue block6;
                    }
                    case 3: {
                        this.A((SshMsgUnimplemented)sshMessage);
                        continue block6;
                    }
                    case 4: {
                        this.A((SshMsgDebug)sshMessage);
                        continue block6;
                    }
                }
                throw new IOException("Unexpected transport protocol message");
            }
            throw new IOException("Unexpected message received");
        }
        return null;
    }

    protected SshMessage processMessages() throws IOException {
        byte[] byArray = null;
        while (this.state.getValue() != 5) {
            SshMessage sshMessage;
            long l2 = System.currentTimeMillis();
            long l3 = this.sshIn.A() + this.sshOut.A();
            long l4 = l3 - this.K;
            long l5 = l2 - this.A;
            if (l5 > this.I || l4 > this.O) {
                this.A = l2;
                this.K = l3;
                if (log.isInfoEnabled()) {
                    log.info("rekeying after " + l3 + " bytes");
                }
                this.sendKeyExchangeInit();
            }
            boolean bl = false;
            while (!bl) {
                try {
                    byArray = this.sshIn.B();
                    bl = true;
                }
                catch (InterruptedIOException interruptedIOException) {
                    log.debug("Possible timeout on transport inputstream");
                    Iterator iterator = this.D.iterator();
                    while (iterator.hasNext()) {
                        TransportProtocolEventHandler transportProtocolEventHandler = (TransportProtocolEventHandler)iterator.next();
                        transportProtocolEventHandler.onSocketTimeout(this);
                    }
                }
            }
            Integer n2 = SshMessage.getMessageId(byArray);
            if (!this.messageStore.isRegisteredMessage(n2)) {
                try {
                    SshMessageStore sshMessageStore = this.A(n2);
                    sshMessage = sshMessageStore.createMessage(byArray);
                    if (log.isEnabledFor(Level.ALL)) {
                        log.log(Level.ALL, "Received registered message: " + sshMessage.toString(), null);
                    } else if (log.isDebugEnabled()) {
                        log.debug("Received registered message: " + sshMessage.getMessageName());
                    }
                    sshMessageStore.addMessage(sshMessage);
                }
                catch (MessageNotRegisteredException messageNotRegisteredException) {
                    log.debug("Unimplemented message received " + String.valueOf(n2));
                    sshMessage = new SshMsgUnimplemented(this.sshIn.C());
                    this.sendMessage(sshMessage, this);
                }
                continue;
            }
            sshMessage = this.messageStore.createMessage(byArray);
            if (log.isEnabledFor(Level.ALL)) {
                log.log(Level.ALL, "Received unregistered message: " + sshMessage.toString(), null);
            } else if (log.isDebugEnabled()) {
                log.debug("Received unregistered message: " + sshMessage.getMessageName());
            }
            return sshMessage;
        }
        throw new IOException("The transport protocol has disconnected");
    }

    public void addMessageStore(SshMessageStore sshMessageStore) throws MessageAlreadyRegisteredException {
        this.N.add(sshMessageStore);
    }

    private SshMessageStore A(Integer n2) throws MessageNotRegisteredException {
        Iterator iterator = this.N.iterator();
        while (iterator != null && iterator.hasNext()) {
            SshMessageStore sshMessageStore = (SshMessageStore)iterator.next();
            if (!sshMessageStore.isRegisteredMessage(n2)) continue;
            return sshMessageStore;
        }
        throw new MessageNotRegisteredException(n2);
    }

    public void removeMessageStore(SshMessageStore sshMessageStore) {
        this.N.remove(sshMessageStore);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

