/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.transport;

import com.enterprisedt.net.j2ssh.io.ByteArrayReader;
import com.enterprisedt.net.j2ssh.io.ByteArrayWriter;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;

public abstract class SshMessage {
    private int A;

    public SshMessage(int n2) {
        this.A = n2;
    }

    public final int getMessageId() {
        return this.A;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("Name=");
        stringBuffer.append(this.getMessageName()).append(",").append("MessageId=").append(this.getMessageId());
        return stringBuffer.toString();
    }

    public abstract String getMessageName();

    public final byte[] toByteArray() throws InvalidMessageException {
        ByteArrayWriter byteArrayWriter = new ByteArrayWriter();
        byteArrayWriter.write(this.A);
        this.constructByteArray(byteArrayWriter);
        return byteArrayWriter.toByteArray();
    }

    protected final void fromByteArray(ByteArrayReader byteArrayReader) throws InvalidMessageException {
        byteArrayReader.skip(5L);
        int n2 = byteArrayReader.read();
        if (n2 != this.A) {
            throw new InvalidMessageException("The message id " + String.valueOf(n2) + " is not the same as the message implementation id " + String.valueOf(this.A));
        }
        this.constructMessage(byteArrayReader);
    }

    public static Integer getMessageId(byte[] byArray) {
        return new Integer(byArray[5]);
    }

    protected abstract void constructByteArray(ByteArrayWriter var1) throws InvalidMessageException;

    protected abstract void constructMessage(ByteArrayReader var1) throws InvalidMessageException;
}

