/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import com.enterprisedt.net.j2ssh.sftp.B;
import com.enterprisedt.net.j2ssh.sftp.FileAttributes;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import com.enterprisedt.net.j2ssh.sftp.SshFxpAttrs;
import com.enterprisedt.net.j2ssh.sftp.SshFxpClose;
import com.enterprisedt.net.j2ssh.sftp.SshFxpData;
import com.enterprisedt.net.j2ssh.sftp.SshFxpFSetStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpFStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpHandle;
import com.enterprisedt.net.j2ssh.sftp.SshFxpInit;
import com.enterprisedt.net.j2ssh.sftp.SshFxpMkdir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpName;
import com.enterprisedt.net.j2ssh.sftp.SshFxpOpen;
import com.enterprisedt.net.j2ssh.sftp.SshFxpOpenDir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRead;
import com.enterprisedt.net.j2ssh.sftp.SshFxpReadDir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpReadlink;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRealPath;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRemove;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRename;
import com.enterprisedt.net.j2ssh.sftp.SshFxpRmdir;
import com.enterprisedt.net.j2ssh.sftp.SshFxpSetStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpStat;
import com.enterprisedt.net.j2ssh.sftp.SshFxpStatus;
import com.enterprisedt.net.j2ssh.sftp.SshFxpSymlink;
import com.enterprisedt.net.j2ssh.sftp.SshFxpVersion;
import com.enterprisedt.net.j2ssh.sftp.SshFxpWrite;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemChannel;
import com.enterprisedt.net.j2ssh.subsystem.SubsystemMessage;
import com.enterprisedt.net.j2ssh.transport.InvalidMessageException;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

public class SftpSubsystemClient
extends SubsystemChannel {
    public static final int OPEN_READ = 1;
    public static final int OPEN_WRITE = 2;
    public static final int OPEN_APPEND = 4;
    public static final int OPEN_CREATE = 8;
    public static final int OPEN_TRUNCATE = 16;
    public static final int OPEN_EXCLUSIVE = 32;
    public static final int VERSION_1 = 1;
    public static final int VERSION_2 = 2;
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    private static Logger d = Logger.getLogger(class$com$enterprisedt$net$j2ssh$sftp$SftpSubsystemClient == null ? (class$com$enterprisedt$net$j2ssh$sftp$SftpSubsystemClient = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SftpSubsystemClient")) : class$com$enterprisedt$net$j2ssh$sftp$SftpSubsystemClient);
    private List a = new Vector();
    private UnsignedInteger32 e = new UnsignedInteger32(1L);
    private int b = 3;
    private B c = (B)this.messageStore;
    private String f;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$sftp$SftpSubsystemClient;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$sftp$SshFxpVersion;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$sftp$SshFxpAttrs;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$sftp$SshFxpData;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$sftp$SshFxpHandle;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$sftp$SshFxpStatus;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$sftp$SshFxpName;

    public SftpSubsystemClient() {
        super("sftp", new B());
        this.G();
    }

    public void setControlEncoding(String string) {
        this.c.A(string);
        this.f = string;
        d.info("Using control encoding: " + string);
    }

    public void setServerResponseTimeout(long l2) {
        this.c.A(l2);
    }

    protected byte[] toByteArray(SubsystemMessage subsystemMessage) throws InvalidMessageException {
        return subsystemMessage.toByteArray(this.f);
    }

    public String getName() {
        return "sftp";
    }

    protected long availableWindowSpace() {
        return this.getRemoteWindow().getWindowSpace();
    }

    protected long maximumPacketSize() {
        return this.getRemotePacketSize();
    }

    protected synchronized void closeHandle(byte[] byArray) throws IOException {
        if (!this.isValidHandle(byArray)) {
            throw new IOException("The handle is invalid!");
        }
        this.a.remove(byArray);
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpClose sshFxpClose = new SshFxpClose(unsignedInteger32, byArray);
        this.sendMessage(sshFxpClose);
        try {
            this.A(unsignedInteger32);
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
    }

    public void closeFile(SftpFile sftpFile) throws IOException {
        this.closeHandle(sftpFile.getHandle());
    }

    protected boolean isValidHandle(byte[] byArray) {
        return this.a.contains(byArray);
    }

    public synchronized int listChildren(SftpFile sftpFile, List list) throws IOException, FTPException {
        if (sftpFile.isDirectory()) {
            if (!this.isValidHandle(sftpFile.getHandle()) && !this.isValidHandle((sftpFile = this.openDirectory(sftpFile.getAbsolutePath())).getHandle())) {
                throw new IOException("Failed to open directory");
            }
        } else {
            throw new IOException("Cannot list children for this file object");
        }
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpReadDir sshFxpReadDir = new SshFxpReadDir(unsignedInteger32, sftpFile.getHandle());
        this.sendMessage(sshFxpReadDir);
        try {
            SubsystemMessage subsystemMessage = this.c.A(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpName) {
                SshFxpName sshFxpName = (SshFxpName)subsystemMessage;
                SftpFile[] sftpFileArray = sshFxpName.getFiles();
                for (int i2 = 0; i2 < sftpFileArray.length; ++i2) {
                    SftpFile sftpFile2 = new SftpFile(sftpFile.getAbsolutePath() + "/" + sftpFileArray[i2].getFilename(), sftpFileArray[i2].getAttributes());
                    sftpFile2.setSFTPSubsystem(this);
                    list.add(sftpFile2);
                }
                return sftpFileArray.length;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                if (sshFxpStatus.getErrorCode().intValue() == 1) {
                    return -1;
                }
                throw new IOException(sshFxpStatus.getErrorMessage());
            }
            throw new IOException("Unexpected server response " + subsystemMessage.getMessageName());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void makeDirectory(String string) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpMkdir sshFxpMkdir = new SshFxpMkdir(unsignedInteger32, string, new FileAttributes());
        this.sendMessage(sshFxpMkdir);
        this.A(unsignedInteger32);
    }

    public void recurseMakeDirectory(String string) throws IOException, FTPException {
        if (string.trim().length() > 0) {
            try {
                SftpFile sftpFile = this.openDirectory(string);
                sftpFile.close();
            }
            catch (FTPException fTPException) {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "/", true);
                String string2 = "";
                while (stringTokenizer.hasMoreElements()) {
                    string2 = string2 + stringTokenizer.nextElement();
                    try {
                        SftpFile sftpFile = this.openDirectory(string2);
                        sftpFile.close();
                    }
                    catch (FTPException fTPException2) {
                        d.debug("Creating " + string2);
                        this.makeDirectory(string2);
                    }
                }
            }
        }
    }

    protected void onChannelClose() throws IOException {
        this.c.close();
    }

    public synchronized SftpFile openDirectory(String string) throws IOException, FTPException {
        String string2 = this.getAbsolutePath(string);
        UnsignedInteger32 unsignedInteger32 = this.H();
        SubsystemMessage subsystemMessage = new SshFxpOpenDir(unsignedInteger32, string2);
        this.sendMessage(subsystemMessage);
        byte[] byArray = this.B(unsignedInteger32);
        unsignedInteger32 = this.H();
        subsystemMessage = new SshFxpStat(unsignedInteger32, string2);
        this.sendMessage(subsystemMessage);
        try {
            SubsystemMessage subsystemMessage2 = this.c.A(unsignedInteger32);
            if (subsystemMessage2 instanceof SshFxpAttrs) {
                SftpFile sftpFile = new SftpFile(string2, ((SshFxpAttrs)subsystemMessage2).getAttributes());
                sftpFile.setHandle(byArray);
                sftpFile.setSFTPSubsystem(this);
                return sftpFile;
            }
            if (subsystemMessage2 instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)subsystemMessage2).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + subsystemMessage2.getMessageName());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public String getDefaultDirectory() throws IOException, FTPException {
        return this.getAbsolutePath("");
    }

    public synchronized String getAbsolutePath(String string) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpRealPath sshFxpRealPath = new SshFxpRealPath(unsignedInteger32, string);
        this.sendMessage(sshFxpRealPath);
        try {
            SubsystemMessage subsystemMessage = this.c.A(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpName) {
                SftpFile[] sftpFileArray = ((SshFxpName)subsystemMessage).getFiles();
                if (sftpFileArray.length != 1) {
                    throw new IOException("Server responded to SSH_FXP_REALPATH with too many files!");
                }
                return sftpFileArray[0].getAbsolutePath();
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                throw new FTPException(sshFxpStatus.getErrorMessage(), sshFxpStatus.getErrorCode().toString());
            }
            throw new IOException("Unexpected server response " + subsystemMessage.getMessageName());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public String getAbsolutePath(SftpFile sftpFile) throws IOException, FTPException {
        return this.getAbsolutePath(sftpFile.getFilename());
    }

    public SftpFile openFile(String string, int n2) throws IOException {
        return this.openFile(string, n2, null);
    }

    public synchronized SftpFile openFile(String string, int n2, FileAttributes fileAttributes) throws IOException {
        if (fileAttributes == null) {
            fileAttributes = new FileAttributes();
        }
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpOpen sshFxpOpen = new SshFxpOpen(unsignedInteger32, string, new UnsignedInteger32(n2), fileAttributes);
        this.sendMessage(sshFxpOpen);
        byte[] byArray = this.B(unsignedInteger32);
        SftpFile sftpFile = new SftpFile(string, null);
        sftpFile.setHandle(byArray);
        sftpFile.setSFTPSubsystem(this);
        return sftpFile;
    }

    public synchronized FileAttributes getAttributes(String string) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpStat sshFxpStat = new SshFxpStat(unsignedInteger32, string);
        this.sendMessage(sshFxpStat);
        try {
            SubsystemMessage subsystemMessage = this.c.A(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpAttrs) {
                return ((SshFxpAttrs)subsystemMessage).getAttributes();
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                throw new FTPException(sshFxpStatus.getErrorMessage() + " : " + string, sshFxpStatus.getErrorCode().toString());
            }
            if (this.getState().getValue() != 1) {
                throw new IOException("Connection closed unexpectedly.");
            }
            if (subsystemMessage != null) {
                throw new IOException("Unexpected server response " + subsystemMessage.getMessageName());
            }
            throw new IOException("No server response received");
        }
        catch (InterruptedException interruptedException) {
            throw new IOException(interruptedException.getMessage());
        }
    }

    public synchronized FileAttributes getAttributes(SftpFile sftpFile) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SubsystemMessage subsystemMessage = !this.isValidHandle(sftpFile.getHandle()) ? new SshFxpStat(unsignedInteger32, sftpFile.getAbsolutePath()) : new SshFxpFStat(unsignedInteger32, sftpFile.getHandle());
        this.sendMessage(subsystemMessage);
        try {
            SubsystemMessage subsystemMessage2 = this.c.A(unsignedInteger32);
            if (subsystemMessage2 instanceof SshFxpAttrs) {
                return ((SshFxpAttrs)subsystemMessage2).getAttributes();
            }
            if (subsystemMessage2 instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage2;
                throw new FTPException(sshFxpStatus.getErrorMessage() + " : " + sftpFile.getAbsolutePath(), sshFxpStatus.getErrorCode().toString());
            }
            throw new IOException("Unexpected server response " + subsystemMessage2.getMessageName());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    protected synchronized int readFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, byte[] byArray2, int n2, int n3) throws IOException {
        if (!this.a.contains(byArray)) {
            throw new IOException("The file handle is invalid!");
        }
        if (byArray2.length - n2 < n3) {
            throw new IOException("Output array size is smaller than read length!");
        }
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpRead sshFxpRead = new SshFxpRead(unsignedInteger32, byArray, unsignedInteger64, new UnsignedInteger32(n3));
        this.sendMessage(sshFxpRead);
        try {
            SubsystemMessage subsystemMessage = this.c.A(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpData) {
                byte[] byArray3 = ((SshFxpData)subsystemMessage).getData();
                System.arraycopy(byArray3, 0, byArray2, n2, byArray3.length);
                return byArray3.length;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                if (sshFxpStatus.getErrorCode().intValue() == 1) {
                    return -1;
                }
                throw new IOException(sshFxpStatus.getErrorMessage());
            }
            throw new IOException("Unexpected server response " + subsystemMessage.getMessageName());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void removeDirectory(String string) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpRmdir sshFxpRmdir = new SshFxpRmdir(unsignedInteger32, string);
        this.sendMessage(sshFxpRmdir);
        this.A(unsignedInteger32);
    }

    public synchronized void removeFile(String string) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpRemove sshFxpRemove = new SshFxpRemove(unsignedInteger32, string);
        this.sendMessage(sshFxpRemove);
        this.A(unsignedInteger32);
    }

    public synchronized void renameFile(String string, String string2) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpRename sshFxpRename = new SshFxpRename(unsignedInteger32, string, string2);
        this.sendMessage(sshFxpRename);
        this.A(unsignedInteger32);
    }

    protected synchronized void writeFile(byte[] byArray, UnsignedInteger64 unsignedInteger64, byte[] byArray2, int n2, int n3) throws IOException {
        if (!this.a.contains(byArray)) {
            throw new IOException("The handle is not valid!");
        }
        if (byArray2.length - n2 < n3) {
            throw new IOException("Incorrect data array size!");
        }
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpWrite sshFxpWrite = new SshFxpWrite(unsignedInteger32, byArray, unsignedInteger64, byArray2, n2, n3);
        this.sendMessage(sshFxpWrite);
        try {
            this.A(unsignedInteger32);
        }
        catch (FTPException fTPException) {
            throw new IOException(fTPException.getMessage());
        }
    }

    public synchronized void createSymbolicLink(String string, String string2) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpSymlink sshFxpSymlink = new SshFxpSymlink(unsignedInteger32, string, string2);
        this.sendMessage(sshFxpSymlink);
        this.A(unsignedInteger32);
    }

    public synchronized String getSymbolicLinkTarget(String string) throws IOException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpReadlink sshFxpReadlink = new SshFxpReadlink(unsignedInteger32, string);
        this.sendMessage(sshFxpReadlink);
        try {
            SubsystemMessage subsystemMessage = this.c.A(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpName) {
                SftpFile[] sftpFileArray = ((SshFxpName)subsystemMessage).getFiles();
                if (sftpFileArray.length != 1) {
                    throw new IOException("Server responded to SSH_FXP_REALLINK with too many files!");
                }
                return sftpFileArray[0].getAbsolutePath();
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + subsystemMessage.getMessageName());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    public synchronized void setAttributes(String string, FileAttributes fileAttributes) throws IOException, FTPException {
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpSetStat sshFxpSetStat = new SshFxpSetStat(unsignedInteger32, string, fileAttributes);
        this.sendMessage(sshFxpSetStat);
        this.A(unsignedInteger32);
    }

    public synchronized void setAttributes(SftpFile sftpFile, FileAttributes fileAttributes) throws IOException, FTPException {
        if (!this.isValidHandle(sftpFile.getHandle())) {
            throw new IOException("The handle is not an open file handle!");
        }
        UnsignedInteger32 unsignedInteger32 = this.H();
        SshFxpFSetStat sshFxpFSetStat = new SshFxpFSetStat(unsignedInteger32, sftpFile.getHandle(), fileAttributes);
        this.sendMessage(sshFxpFSetStat);
        this.A(unsignedInteger32);
    }

    public void changePermissions(SftpFile sftpFile, String string) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(string);
        this.setAttributes(sftpFile, fileAttributes);
    }

    public void changePermissions(SftpFile sftpFile, int n2) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(new UnsignedInteger32(n2));
        this.setAttributes(sftpFile, fileAttributes);
    }

    public void changePermissions(String string, int n2) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(new UnsignedInteger32(n2));
        this.setAttributes(string, fileAttributes);
    }

    public void changePermissions(String string, String string2) throws IOException, FTPException {
        FileAttributes fileAttributes = new FileAttributes();
        fileAttributes.setPermissions(string2);
        this.setAttributes(string, fileAttributes);
    }

    public synchronized boolean initialize() throws IOException {
        d.debug("Initializing SFTP protocol version " + String.valueOf(this.b));
        if (!this.startSubsystem()) {
            return false;
        }
        boolean bl = false;
        SshFxpInit sshFxpInit = new SshFxpInit(new UnsignedInteger32(this.b), null);
        this.sendMessage(sshFxpInit);
        SubsystemMessage subsystemMessage = null;
        for (int i2 = 0; i2 < 30; ++i2) {
            try {
                subsystemMessage = this.c.nextMessage(1000);
                d.debug("Received reply to init msg");
                break;
            }
            catch (MessageNotAvailableException messageNotAvailableException) {
                d.debug("Timed out attempt #" + i2);
            }
            catch (MessageStoreEOFException messageStoreEOFException) {
                d.error("Failed to retrieve reply");
                return false;
            }
            if (this.getState().getValue() == 2) continue;
            d.error("State is not CHANNEL_OPEN - initialize failed");
            return false;
        }
        if (subsystemMessage instanceof SshFxpVersion) {
            bl = true;
            this.b = ((SshFxpVersion)subsystemMessage).getVersion().intValue();
            d.debug("Server responded with version " + String.valueOf(this.b));
        }
        return bl;
    }

    private byte[] B(UnsignedInteger32 unsignedInteger32) throws IOException {
        try {
            SubsystemMessage subsystemMessage = this.c.A(unsignedInteger32);
            if (subsystemMessage instanceof SshFxpHandle) {
                byte[] byArray = ((SshFxpHandle)subsystemMessage).getHandle();
                this.a.add(byArray);
                return byArray;
            }
            if (subsystemMessage instanceof SshFxpStatus) {
                throw new IOException(((SshFxpStatus)subsystemMessage).getErrorMessage());
            }
            throw new IOException("Unexpected server response " + subsystemMessage.getMessageName());
        }
        catch (InterruptedException interruptedException) {
            throw new IOException("The thread was interrupted");
        }
    }

    private void A(UnsignedInteger32 unsignedInteger32) throws IOException, FTPException {
        block6: {
            try {
                if (d.isDebugEnabled()) {
                    d.debug("Waiting for response");
                }
                SubsystemMessage subsystemMessage = this.c.A(unsignedInteger32);
                d.debug("Received response");
                if (subsystemMessage instanceof SshFxpStatus) {
                    SshFxpStatus sshFxpStatus = (SshFxpStatus)subsystemMessage;
                    int n2 = sshFxpStatus.getErrorCode().intValue();
                    if (n2 != 0) {
                        if (n2 == 2 || n2 == 3) {
                            throw new FTPException(sshFxpStatus.getErrorMessage(), sshFxpStatus.getErrorCode().toString());
                        }
                        throw new IOException(sshFxpStatus.getErrorMessage());
                    }
                    break block6;
                }
                throw new IOException("Unexpected server response " + (subsystemMessage == null ? "" : subsystemMessage.getMessageName()));
            }
            catch (InterruptedException interruptedException) {
                throw new IOException("The thread was interrupted");
            }
        }
    }

    private UnsignedInteger32 H() {
        this.e = UnsignedInteger32.add(this.e, 1);
        return this.e;
    }

    private void G() {
        this.c.registerMessage(2, class$com$enterprisedt$net$j2ssh$sftp$SshFxpVersion == null ? (class$com$enterprisedt$net$j2ssh$sftp$SshFxpVersion = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpVersion")) : class$com$enterprisedt$net$j2ssh$sftp$SshFxpVersion);
        this.c.registerMessage(105, class$com$enterprisedt$net$j2ssh$sftp$SshFxpAttrs == null ? (class$com$enterprisedt$net$j2ssh$sftp$SshFxpAttrs = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpAttrs")) : class$com$enterprisedt$net$j2ssh$sftp$SshFxpAttrs);
        this.c.registerMessage(103, class$com$enterprisedt$net$j2ssh$sftp$SshFxpData == null ? (class$com$enterprisedt$net$j2ssh$sftp$SshFxpData = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpData")) : class$com$enterprisedt$net$j2ssh$sftp$SshFxpData);
        this.c.registerMessage(102, class$com$enterprisedt$net$j2ssh$sftp$SshFxpHandle == null ? (class$com$enterprisedt$net$j2ssh$sftp$SshFxpHandle = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpHandle")) : class$com$enterprisedt$net$j2ssh$sftp$SshFxpHandle);
        this.c.registerMessage(101, class$com$enterprisedt$net$j2ssh$sftp$SshFxpStatus == null ? (class$com$enterprisedt$net$j2ssh$sftp$SshFxpStatus = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpStatus")) : class$com$enterprisedt$net$j2ssh$sftp$SshFxpStatus);
        this.c.registerMessage(104, class$com$enterprisedt$net$j2ssh$sftp$SshFxpName == null ? (class$com$enterprisedt$net$j2ssh$sftp$SshFxpName = SftpSubsystemClient.class$("com.enterprisedt.net.j2ssh.sftp.SshFxpName")) : class$com$enterprisedt$net$j2ssh$sftp$SshFxpName);
    }

    protected int getMinimumWindowSpace() {
        return 1024;
    }

    protected int getMaximumWindowSpace() {
        return 131070;
    }

    protected int getMaximumPacketSize() {
        return 65535;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

