/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.openssh;

import com.enterprisedt.net.j2ssh.openssh.KeyInfo;
import com.enterprisedt.net.j2ssh.util.SimpleASNReader;
import com.enterprisedt.net.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;

public class DSAKeyInfo
implements KeyInfo {
    private BigInteger D;
    private BigInteger C;
    private BigInteger B;
    private BigInteger A;
    private BigInteger E;

    public DSAKeyInfo(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4, BigInteger bigInteger5) {
        this.D = bigInteger;
        this.C = bigInteger2;
        this.B = bigInteger3;
        this.A = bigInteger4;
        this.E = bigInteger5;
    }

    public BigInteger getG() {
        return this.B;
    }

    public BigInteger getP() {
        return this.D;
    }

    public BigInteger getQ() {
        return this.C;
    }

    public BigInteger getX() {
        return this.A;
    }

    public BigInteger getY() {
        return this.E;
    }

    public KeySpec getPrivateKeySpec() {
        return new DSAPrivateKeySpec(this.A, this.D, this.C, this.B);
    }

    public KeySpec getPublicKeySpec() {
        return new DSAPublicKeySpec(this.E, this.D, this.C, this.B);
    }

    public static DSAKeyInfo getDSAKeyInfo(SimpleASNReader simpleASNReader) throws IOException {
        simpleASNReader.assertByte(48);
        simpleASNReader.getLength();
        simpleASNReader.assertByte(2);
        simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray2 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray3 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray4 = simpleASNReader.getData();
        simpleASNReader.assertByte(2);
        byte[] byArray5 = simpleASNReader.getData();
        return new DSAKeyInfo(new BigInteger(byArray), new BigInteger(byArray2), new BigInteger(byArray3), new BigInteger(byArray5), new BigInteger(byArray4));
    }

    public static void writeDSAKeyInfo(SimpleASNWriter simpleASNWriter, DSAKeyInfo dSAKeyInfo) {
        SimpleASNWriter simpleASNWriter2 = new SimpleASNWriter();
        simpleASNWriter2.writeByte(2);
        byte[] byArray = new byte[1];
        simpleASNWriter2.writeData(byArray);
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getP().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getQ().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getG().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getY().toByteArray());
        simpleASNWriter2.writeByte(2);
        simpleASNWriter2.writeData(dSAKeyInfo.getX().toByteArray());
        byte[] byArray2 = simpleASNWriter2.toByteArray();
        simpleASNWriter.writeByte(48);
        simpleASNWriter.writeData(byArray2);
    }
}

