/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.io;

import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;

public class ByteArrayWriter
extends ByteArrayOutputStream {
    private String A;

    public ByteArrayWriter() {
    }

    public ByteArrayWriter(String string) {
        this.A = string;
    }

    public void writeBigInteger(BigInteger bigInteger) throws IOException {
        byte[] byArray = bigInteger.toByteArray();
        this.writeInt(byArray.length);
        this.write(byArray);
    }

    public void writeBoolean(boolean bl) throws IOException {
        this.write(bl ? 1 : 0);
    }

    public void writeBinaryString(byte[] byArray) throws IOException {
        this.writeInt(byArray.length);
        this.write(byArray);
    }

    public void writeInt(long l2) throws IOException {
        byte[] byArray = new byte[]{(byte)(l2 >> 24), (byte)(l2 >> 16), (byte)(l2 >> 8), (byte)l2};
        this.write(byArray);
    }

    public void writeInt(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
        this.write(byArray);
    }

    public static byte[] encodeInt(int n2) {
        byte[] byArray = new byte[]{(byte)(n2 >> 24), (byte)(n2 >> 16), (byte)(n2 >> 8), (byte)n2};
        return byArray;
    }

    public void writeUINT32(UnsignedInteger32 unsignedInteger32) throws IOException {
        this.writeInt(unsignedInteger32.longValue());
    }

    public void writeUINT64(UnsignedInteger64 unsignedInteger64) throws IOException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = unsignedInteger64.bigIntValue().toByteArray();
        System.arraycopy(byArray2, 0, byArray, byArray.length - byArray2.length, byArray2.length);
        this.write(byArray);
    }

    public static void writeIntToArray(byte[] byArray, int n2, int n3) throws IOException {
        if (byArray.length - n2 < 4) {
            throw new IOException("Not enough data in array to write integer at position " + String.valueOf(n2));
        }
        byArray[n2] = (byte)(n3 >> 24);
        byArray[n2 + 1] = (byte)(n3 >> 16);
        byArray[n2 + 2] = (byte)(n3 >> 8);
        byArray[n2 + 3] = (byte)n3;
    }

    public void writeString(String string) throws IOException {
        if (this.A == null) {
            this.A = "US-ASCII";
        }
        if (string == null) {
            this.writeInt(0);
        } else {
            this.writeInt(string.length());
            this.write(string.getBytes(this.A));
        }
    }
}

