/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.authentication;

import com.enterprisedt.net.j2ssh.SshException;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolException;
import com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolListener;
import com.enterprisedt.net.j2ssh.authentication.SshAuthenticationClient;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthBanner;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthFailure;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthRequest;
import com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthSuccess;
import com.enterprisedt.net.j2ssh.authentication.TerminatedStateException;
import com.enterprisedt.net.j2ssh.transport.MessageNotAvailableException;
import com.enterprisedt.net.j2ssh.transport.MessageStoreEOFException;
import com.enterprisedt.net.j2ssh.transport.Service;
import com.enterprisedt.net.j2ssh.transport.SshMessage;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class AuthenticationProtocolClient
extends Service {
    private static Logger D = Logger.getLogger(class$com$enterprisedt$net$j2ssh$authentication$AuthenticationProtocolClient == null ? (class$com$enterprisedt$net$j2ssh$authentication$AuthenticationProtocolClient = AuthenticationProtocolClient.class$("com.enterprisedt.net.j2ssh.authentication.AuthenticationProtocolClient")) : class$com$enterprisedt$net$j2ssh$authentication$AuthenticationProtocolClient);
    private int[] F = new int[2];
    private int[] E = new int[3];
    private Vector C = new Vector();
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$authentication$AuthenticationProtocolClient;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthFailure;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthSuccess;
    static /* synthetic */ Class class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthBanner;

    public AuthenticationProtocolClient() {
        super("ssh-userauth");
        this.F[0] = 52;
        this.F[1] = 51;
        this.E[0] = 52;
        this.E[1] = 51;
    }

    protected void onServiceAccept() throws IOException {
    }

    protected void onStart() {
    }

    protected void onServiceInit(int n2) throws IOException {
        if (n2 == 2) {
            throw new IOException("The Authentication Protocol client cannot be accepted");
        }
        this.messageStore.registerMessage(51, class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthFailure == null ? (class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthFailure = AuthenticationProtocolClient.class$("com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthFailure")) : class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthFailure);
        this.messageStore.registerMessage(52, class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthSuccess == null ? (class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthSuccess = AuthenticationProtocolClient.class$("com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthSuccess")) : class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthSuccess);
        this.messageStore.registerMessage(53, class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthBanner == null ? (class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthBanner = AuthenticationProtocolClient.class$("com.enterprisedt.net.j2ssh.authentication.SshMsgUserAuthBanner")) : class$com$enterprisedt$net$j2ssh$authentication$SshMsgUserAuthBanner);
    }

    protected void onServiceRequest() throws IOException {
        throw new IOException("This class implements the client protocol only!");
    }

    public void addEventListener(AuthenticationProtocolListener authenticationProtocolListener) {
        if (authenticationProtocolListener != null) {
            this.C.add(authenticationProtocolListener);
        }
    }

    public List getAvailableAuths(String string, String string2) throws IOException {
        D.debug("Requesting authentication methods");
        SshMessage sshMessage = new SshMsgUserAuthRequest(string, string2, "none", null);
        this.transport.sendMessage(sshMessage, this);
        try {
            sshMessage = this.messageStore.getMessage(this.F);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            return ((SshMsgUserAuthFailure)sshMessage).getAvailableAuthentications();
        }
        throw new IOException("None request returned success! Insecure feature not supported");
    }

    public int authenticate(SshAuthenticationClient sshAuthenticationClient, Service service) throws IOException {
        try {
            Object object;
            if (!sshAuthenticationClient.canAuthenticate() && sshAuthenticationClient.canPrompt() && !(object = sshAuthenticationClient.getAuthenticationPrompt()).showPrompt(sshAuthenticationClient)) {
                return 5;
            }
            sshAuthenticationClient.authenticate(this, service.getServiceName());
            object = this.A(this.messageStore.getMessage(this.F));
            throw new AuthenticationProtocolException("Unexpected authentication message " + ((SshMessage)object).getMessageName());
        }
        catch (TerminatedStateException terminatedStateException) {
            if (terminatedStateException.getState() == 4) {
                service.init(2, this.transport);
                service.start();
                Iterator iterator = this.C.iterator();
                while (iterator.hasNext()) {
                    AuthenticationProtocolListener authenticationProtocolListener = (AuthenticationProtocolListener)iterator.next();
                    if (authenticationProtocolListener == null) continue;
                    authenticationProtocolListener.onAuthenticationComplete();
                }
            }
            return terminatedStateException.getState();
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
    }

    public void sendMessage(SshMessage sshMessage) throws IOException {
        this.transport.sendMessage(sshMessage, this);
    }

    public byte[] getSessionIdentifier() {
        return this.transport.getSessionIdentifier();
    }

    public void registerMessage(Class clazz, int n2) {
        this.messageStore.registerMessage(n2, clazz);
    }

    public SshMessage readMessage(int n2) throws TerminatedStateException, IOException {
        this.E[2] = n2;
        return this.A(this.E);
    }

    private SshMessage A(int[] nArray) throws TerminatedStateException, IOException {
        try {
            SshMessage sshMessage = this.messageStore.getMessage(nArray);
            return this.A(sshMessage);
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            throw new AuthenticationProtocolException("Failed to read messages", messageStoreEOFException);
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
    }

    public SshMessage readMessage(int[] nArray) throws TerminatedStateException, IOException {
        int[] nArray2 = new int[nArray.length + this.F.length];
        System.arraycopy(this.F, 0, nArray2, 0, this.F.length);
        System.arraycopy(nArray, 0, nArray2, this.F.length, nArray.length);
        return this.A(nArray2);
    }

    public void readAuthenticationState() throws IOException, TerminatedStateException {
        this.A(this.F);
    }

    private SshMessage A(SshMessage sshMessage) throws TerminatedStateException {
        if (sshMessage instanceof SshMsgUserAuthFailure) {
            if (((SshMsgUserAuthFailure)sshMessage).getPartialSuccess()) {
                throw new TerminatedStateException(3);
            }
            throw new TerminatedStateException(2);
        }
        if (sshMessage instanceof SshMsgUserAuthSuccess) {
            throw new TerminatedStateException(4);
        }
        return sshMessage;
    }

    public String getBannerMessage(int n2) throws IOException {
        try {
            D.debug("getBannerMessage is attempting to read the authentication banner");
            SshMessage sshMessage = this.messageStore.peekMessage(53, n2);
            return ((SshMsgUserAuthBanner)sshMessage).getBanner();
        }
        catch (MessageNotAvailableException messageNotAvailableException) {
            return "";
        }
        catch (MessageStoreEOFException messageStoreEOFException) {
            D.error("Failed to retreive banner becasue the message store is EOF");
            return "";
        }
        catch (InterruptedException interruptedException) {
            throw new SshException("The thread was interrupted whilst waiting for an authentication message", interruptedException);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

