/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.util.math;

import com.enterprisedt.cryptix.util.math.BigRegister;
import java.io.Serializable;

public class TrinomialLFSR
extends BigRegister
implements Cloneable,
Serializable {
    private int K;
    private int L;
    private int O;
    private int Q;
    private static final long P = -8054549768481919515L;
    private static final boolean M = true;
    private transient TrinomialLFSR[] N;

    public TrinomialLFSR(int n2, int n3) {
        super(n2);
        if (n3 < 1 || n3 > n2 - 1) {
            throw new IllegalArgumentException();
        }
        this.K = n2;
        this.L = n3;
        this.Q = Math.min(this.L, this.K - this.L);
        this.O = Math.min(64, this.Q);
    }

    public Object clone() {
        TrinomialLFSR trinomialLFSR = new TrinomialLFSR(this.K, this.L);
        trinomialLFSR.load(this);
        return trinomialLFSR;
    }

    public void clock(int n2) {
        if (n2 < 1) {
            return;
        }
        int n3 = n2 % this.O;
        if (n3 != 0) {
            this.engineClock(n3);
            n2 -= n3;
        }
        while (n2 > 0) {
            this.engineClock(this.O);
            n2 -= this.O;
        }
    }

    protected void engineClock(int n2) {
        long l2 = this.getBits(this.K - n2, n2) ^ this.getBits(this.K - this.L - n2, n2);
        this.shiftLeft(n2);
        if (l2 != 0L) {
            this.setBits(0, n2, l2);
        }
    }

    private void A(int n2) {
        if (n2 < 1) {
            return;
        }
        int n3 = n2 % this.Q;
        if (n3 != 0) {
            this.clock(n3);
            n2 -= n3;
        }
        while (n2 > 0) {
            BigRegister bigRegister = (BigRegister)this.clone();
            BigRegister bigRegister2 = (BigRegister)this.clone();
            bigRegister2.shiftLeft(this.Q);
            bigRegister2.xor(bigRegister);
            bigRegister2.shiftRight(this.K - this.Q);
            this.shiftLeft(this.Q);
            this.or(bigRegister2);
            n2 -= this.Q;
        }
    }

    public long next(int n2) {
        if (n2 < 1) {
            return 0L;
        }
        long l2 = this.getBits(this.K - n2, n2);
        this.clock(n2);
        return l2;
    }

    public void add(TrinomialLFSR trinomialLFSR) {
        if (!this.isSameGroup(trinomialLFSR)) {
            throw new IllegalArgumentException();
        }
        this.xor(trinomialLFSR);
    }

    public void subtract(TrinomialLFSR trinomialLFSR) {
        this.add(trinomialLFSR);
    }

    public void multiply(TrinomialLFSR trinomialLFSR) {
        if (!this.isSameGroup(trinomialLFSR)) {
            throw new IllegalArgumentException();
        }
        if (trinomialLFSR.countSetBits() == 0) {
            this.reset();
            return;
        }
        TrinomialLFSR trinomialLFSR2 = new TrinomialLFSR(this.K, this.L);
        TrinomialLFSR trinomialLFSR3 = null;
        for (int i2 = 0; i2 < this.K; ++i2) {
            if (!trinomialLFSR.testBit(i2)) continue;
            trinomialLFSR2.load(this);
            int n2 = this.degreeAt(i2);
            if (n2 != 0) {
                trinomialLFSR2.A(n2);
            }
            if (trinomialLFSR3 == null) {
                trinomialLFSR3 = (TrinomialLFSR)trinomialLFSR2.clone();
                continue;
            }
            trinomialLFSR3.add(trinomialLFSR2);
        }
        this.load(trinomialLFSR3);
    }

    public static TrinomialLFSR multiply(TrinomialLFSR trinomialLFSR, TrinomialLFSR trinomialLFSR2) {
        TrinomialLFSR trinomialLFSR3;
        if (!trinomialLFSR.isSameGroup(trinomialLFSR2)) {
            throw new IllegalArgumentException();
        }
        if (trinomialLFSR.countSetBits() > trinomialLFSR2.countSetBits()) {
            trinomialLFSR3 = (TrinomialLFSR)trinomialLFSR.clone();
            trinomialLFSR3.multiply(trinomialLFSR2);
        } else {
            trinomialLFSR3 = (TrinomialLFSR)trinomialLFSR2.clone();
            trinomialLFSR3.multiply(trinomialLFSR);
        }
        return trinomialLFSR3;
    }

    public void pow(BigRegister bigRegister) {
        int n2;
        if (bigRegister.getSize() > this.K) {
            throw new IllegalArgumentException();
        }
        int n3 = bigRegister.highestSetBit();
        if (n3 == 0) {
            return;
        }
        if (n3 == -1) {
            this.resetX(0);
            return;
        }
        TrinomialLFSR trinomialLFSR = this.trinomialOne();
        TrinomialLFSR trinomialLFSR2 = (TrinomialLFSR)this.clone();
        if (this.N == null) {
            this.N = new TrinomialLFSR[this.K];
        }
        if (!this.isSameValue(this.N[0])) {
            this.N[0] = (TrinomialLFSR)trinomialLFSR2.clone();
            for (n2 = 1; n2 < this.K; ++n2) {
                trinomialLFSR2.multiply(trinomialLFSR2);
                this.N[n2] = (TrinomialLFSR)trinomialLFSR2.clone();
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            if (!bigRegister.testBit(n2)) continue;
            trinomialLFSR = TrinomialLFSR.multiply(this.N[n2], trinomialLFSR);
        }
        trinomialLFSR2 = this.N[n2];
        this.load(TrinomialLFSR.multiply(trinomialLFSR, trinomialLFSR2));
    }

    public void resetX(int n2) {
        this.reset();
        this.setX(n2);
    }

    public void setX(int n2) {
        this.setBit(this.indexOfX(n2));
    }

    public int indexOfX(int n2) {
        if (n2 < 0 || n2 >= this.K) {
            throw new IllegalArgumentException();
        }
        int n3 = n2 - this.L;
        if (n3 < 0) {
            n3 += this.K;
        }
        return n3;
    }

    public int degreeAt(int n2) {
        if (n2 < 0 || n2 >= this.K) {
            throw new IllegalArgumentException();
        }
        return (n2 + this.L) % this.K;
    }

    public TrinomialLFSR trinomialOne() {
        TrinomialLFSR trinomialLFSR = (TrinomialLFSR)this.clone();
        trinomialLFSR.resetX(0);
        return trinomialLFSR;
    }

    public TrinomialLFSR trinomialX() {
        TrinomialLFSR trinomialLFSR = (TrinomialLFSR)this.clone();
        trinomialLFSR.resetX(1);
        return trinomialLFSR;
    }

    public int getSize() {
        return this.K;
    }

    public int getMidTap() {
        return this.L;
    }

    public int getSlice() {
        return this.O;
    }

    public boolean isSameValue(TrinomialLFSR trinomialLFSR) {
        if (trinomialLFSR == null || trinomialLFSR.L != this.L) {
            return false;
        }
        return super.isSameValue(trinomialLFSR);
    }

    public int compareTo(TrinomialLFSR trinomialLFSR) {
        if (this.K > trinomialLFSR.K) {
            return 1;
        }
        if (this.K < trinomialLFSR.K) {
            return -1;
        }
        if (this.L > trinomialLFSR.L) {
            return 1;
        }
        if (this.L < trinomialLFSR.L) {
            return -1;
        }
        BigRegister bigRegister = this.toBigRegister();
        BigRegister bigRegister2 = trinomialLFSR.toBigRegister();
        return bigRegister.compareTo(bigRegister2);
    }

    public boolean isSameGroup(TrinomialLFSR trinomialLFSR) {
        return trinomialLFSR != null && this.K == trinomialLFSR.K && this.L == trinomialLFSR.L;
    }

    public BigRegister toBigRegister() {
        BigRegister bigRegister = (BigRegister)this.clone();
        bigRegister.rotateLeft(this.L);
        return bigRegister;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(8 * this.K + 64);
        stringBuffer.append("[...\n TrinomialLFSR <").append(this.K).append(", x").append(this.K).append(" + ").append(this.L == 1 ? "x" : "x" + this.L).append(" + 1").append(">...\n").append(" current state is: ").append(super.toString()).append("...]\n");
        return stringBuffer.toString();
    }

    public String toPolynomial() {
        StringBuffer stringBuffer = new StringBuffer(16);
        stringBuffer.append(' ');
        int n2 = this.K;
        boolean bl = true;
        while (--n2 >= 0) {
            if (!this.testBit(this.indexOfX(n2))) continue;
            if (bl) {
                bl = !bl;
            } else {
                stringBuffer.append(" + ");
            }
            if (n2 != 0) {
                stringBuffer.append('x');
                if (n2 == 1) continue;
                stringBuffer.append(n2);
                continue;
            }
            stringBuffer.append('1');
        }
        if (bl) {
            stringBuffer.append('0');
        }
        return stringBuffer.append(' ').toString();
    }
}

