/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.provider.rsa.A;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.net.puretls.crypto.Blindable;
import com.enterprisedt.net.puretls.crypto.PKCS1Pad;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import xjava.security.IllegalBlockSizeException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.CryptixRSAPublicKey;
import xjava.security.interfaces.RSAFactors;

public class RSASignature
extends Signature
implements Blindable {
    protected byte[] data = null;
    private BigInteger G;
    private BigInteger F;
    private BigInteger B;
    private BigInteger E;
    private BigInteger D;
    private BigInteger A;
    private SecureRandom C = null;

    public RSASignature(String string) {
        super(string);
    }

    public RSASignature() {
        super("RawRSAPKCS#1");
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof CryptixRSAPublicKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a RSA Public Key");
        }
        CryptixRSAPublicKey cryptixRSAPublicKey = (CryptixRSAPublicKey)publicKey;
        this.G = cryptixRSAPublicKey.getModulus();
        this.F = cryptixRSAPublicKey.getExponent();
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof CryptixRSAPrivateKey)) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Not a RSA Private Key");
        }
        CryptixRSAPrivateKey cryptixRSAPrivateKey = (CryptixRSAPrivateKey)privateKey;
        this.G = cryptixRSAPrivateKey.getModulus();
        this.F = cryptixRSAPrivateKey.getExponent();
        if (privateKey instanceof RSAFactors) {
            RSAFactors rSAFactors = (RSAFactors)((Object)privateKey);
            this.E = rSAFactors.getP();
            this.D = rSAFactors.getQ();
            this.A = rSAFactors.getInverseOfQModP();
        }
    }

    protected void engineUpdate(byte by) throws SignatureException {
        throw new SignatureException(this.getAlgorithm() + ": Must be called with a complete input");
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.data != null) {
            throw new SignatureException(this.getAlgorithm() + ": Raw RSA may only be updated once");
        }
        this.data = new byte[n3];
        System.arraycopy(byArray, n2, this.data, 0, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.data == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply input");
        }
        byte[] byArray = PKCS1Pad.pkcs1PadBuf(this.data, this.G, 2);
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = com.enterprisedt.cryptix.provider.rsa.A.A(bigInteger, this.G, this.F, this.B, this.E, this.D, this.A, this.C);
        byte[] byArray2 = this.sigToBytes(bigInteger2);
        return byArray2;
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        if (this.state != 3) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        if (this.data == null) {
            throw new SignatureException(this.getAlgorithm() + ": Must supply input");
        }
        if (byArray.length != this.A()) {
            throw new IllegalBlockSizeException("Wrong input length");
        }
        BigInteger bigInteger = new BigInteger(1, byArray);
        if (bigInteger.compareTo(this.G) > 0) {
            throw new IllegalBlockSizeException("Signature greater than modulus");
        }
        byte[] byArray2 = com.enterprisedt.cryptix.provider.rsa.A.A(bigInteger, this.G, this.F, null, this.E, this.D, this.A, null).toByteArray();
        byte[] byArray3 = null;
        try {
            byArray3 = PKCS1Pad.pkcs1UnpadBuf(byArray2, 2, this.G);
        }
        catch (IllegalBlockSizeException illegalBlockSizeException) {
            return false;
        }
        return ArrayUtil.areEqual(byArray3, this.data);
    }

    public void setBlindingInfo(SecureRandom secureRandom, CryptixRSAPublicKey cryptixRSAPublicKey) {
        this.C = secureRandom;
        this.B = cryptixRSAPublicKey.getExponent();
    }

    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected Object engineGetParameter(String string) throws InvalidParameterException {
        throw new InvalidParameterException(this.getAlgorithm() + ": No settable parameters");
    }

    protected byte[] sigToBytes(BigInteger bigInteger) {
        int n2;
        byte[] byArray = bigInteger.toByteArray();
        if (byArray.length == (n2 = this.A())) {
            return byArray;
        }
        byte[] byArray2 = new byte[n2];
        if (byArray.length < n2) {
            int n3;
            for (n3 = 0; n3 < n2 - byArray.length; ++n3) {
                byArray2[n3] = 0;
            }
            System.arraycopy(byArray, 0, byArray2, n3, byArray.length);
        } else {
            int n4;
            for (n4 = 0; n4 < byArray.length - n2; ++n4) {
                if (byArray[n4] == 0) continue;
                throw new InternalError("RSA signature error");
            }
            System.arraycopy(byArray, n4, byArray2, 0, n2);
        }
        return byArray2;
    }

    private int A() {
        int n2 = this.G.bitLength() / 8;
        return n2 += this.G.bitLength() % 8 > 0 ? 1 : 0;
    }
}

