/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.rsa;

import com.enterprisedt.cryptix.util.core.BI;
import com.enterprisedt.cryptix.util.core.Debug;
import java.math.BigInteger;
import java.security.InvalidParameterException;
import xjava.security.interfaces.CryptixRSAPrivateKey;
import xjava.security.interfaces.RSAFactors;

public abstract class BaseRSAPrivateKey
implements CryptixRSAPrivateKey,
RSAFactors {
    private static final boolean H = Debug.GLOBAL_DEBUG;
    private static final int E = H ? Debug.getLevel("RSA", "BaseRSAPrivateKey") : 0;
    private static final BigInteger F = BigInteger.valueOf(0L);
    private static final BigInteger A = BigInteger.valueOf(1L);
    private BigInteger D;
    private BigInteger G;
    private BigInteger C;
    private BigInteger B;
    private BigInteger I;

    private static void A(String string) {
        Debug.log("BaseRSAPrivateKey: " + string);
    }

    protected BaseRSAPrivateKey() {
    }

    public BigInteger getModulus() {
        return this.D;
    }

    public BigInteger getExponent() {
        return this.G;
    }

    public BigInteger getP() {
        return this.C;
    }

    public BigInteger getQ() {
        return this.B;
    }

    public BigInteger getInverseOfQModP() {
        return this.I;
    }

    public String getAlgorithm() {
        return "RSA";
    }

    protected void setRsaParams(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null) {
            throw new NullPointerException("n == null");
        }
        if (bigInteger2 == null) {
            throw new NullPointerException("d == null");
        }
        this.D = bigInteger;
        this.G = bigInteger2;
    }

    protected void setRsaParams(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
        if (bigInteger == null) {
            throw new NullPointerException("d == null");
        }
        this.D = bigInteger2.multiply(bigInteger3);
        this.G = bigInteger;
        this.C = bigInteger2;
        this.B = bigInteger3;
        if (bigInteger4 != null && !bigInteger4.multiply(bigInteger3).mod(bigInteger2).equals(A)) {
            if (H && E >= 1) {
                BaseRSAPrivateKey.A("uq != 1 (mod p)");
            }
            bigInteger4 = null;
        }
        if (bigInteger4 == null) {
            try {
                bigInteger4 = bigInteger3.modInverse(bigInteger2);
            }
            catch (ArithmeticException arithmeticException) {
                if (H && E >= 1) {
                    if (bigInteger2.compareTo(F) <= 0) {
                        BaseRSAPrivateKey.A("p <= 0");
                    }
                    if (bigInteger2.equals(bigInteger3)) {
                        BaseRSAPrivateKey.A("p == q");
                    }
                    if (!bigInteger2.isProbablePrime(80)) {
                        BaseRSAPrivateKey.A("p is composite");
                    }
                    if (!bigInteger3.isProbablePrime(80)) {
                        BaseRSAPrivateKey.A("q is composite");
                    }
                }
                throw new InvalidParameterException("gcd(q, p) != 1");
            }
        }
        this.I = bigInteger4;
    }

    public String toString() {
        if (H && E >= 5) {
            return "<----- RSAPrivateKey:\n         d: " + BI.dumpString(this.G) + "         p: " + BI.dumpString(this.C) + "         q: " + BI.dumpString(this.B) + "q^-1 mod p: " + BI.dumpString(this.I) + "----->\n";
        }
        return "<BaseRSAPrivateKey>";
    }
}

