/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.elgamal;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.elgamal.ElGamalAlgorithm;
import com.enterprisedt.cryptix.util.core.BI;
import com.enterprisedt.cryptix.util.core.Debug;
import com.enterprisedt.cryptix.util.core.Hex;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.util.Random;
import xjava.security.interfaces.ElGamalPrivateKey;
import xjava.security.interfaces.ElGamalPublicKey;

public abstract class Any_ElGamal_PKCS1Signature
extends Signature {
    private static final boolean J = Debug.GLOBAL_DEBUG;
    private static final int E = J ? Debug.getLevel("ElGamal", "Any_ElGamal_PKCS1Signature") : 0;
    private static final int D = 256;
    private static final BigInteger B = BigInteger.valueOf(1L);
    private BigInteger C;
    private BigInteger F;
    private BigInteger K;
    private BigInteger I;
    private int H;
    private Random A;
    private MessageDigest G;

    private static void A(String string) {
        Debug.log("Any_ElGamal_PKCS1Signature: " + string);
    }

    protected Any_ElGamal_PKCS1Signature(String string) {
        super(string + "/ElGamal/PKCS#1");
        try {
            this.G = MessageDigest.getInstance(string, "CryptixEDT");
        }
        catch (Exception exception) {
            throw new CryptixException(this.getAlgorithm() + ": Unable to instantiate the " + string + " MessageDigest\n" + exception);
        }
    }

    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        if (!(privateKey instanceof ElGamalPrivateKey)) {
            throw new InvalidKeyException("ElGamal: signing key does not implement java.security.interfaces.ElGamalPrivateKey");
        }
        ElGamalPrivateKey elGamalPrivateKey = (ElGamalPrivateKey)privateKey;
        BigInteger bigInteger = elGamalPrivateKey.getX();
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getX() == null");
        }
        this.A(elGamalPrivateKey.getP(), elGamalPrivateKey.getG(), bigInteger, elGamalPrivateKey.getY());
        if (this.A == null) {
            this.A = new SecureRandom();
        }
    }

    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        if (!(publicKey instanceof ElGamalPublicKey)) {
            throw new InvalidKeyException("ElGamal: verification key does not implement java.security.interfaces.ElGamalPublicKey");
        }
        ElGamalPublicKey elGamalPublicKey = (ElGamalPublicKey)publicKey;
        this.A(elGamalPublicKey.getP(), elGamalPublicKey.getG(), null, elGamalPublicKey.getY());
        if (this.A == null) {
            this.A = new SecureRandom();
        }
    }

    private void A(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) throws InvalidKeyException {
        if (bigInteger == null) {
            throw new InvalidKeyException("ElGamal: getP() == null");
        }
        if (bigInteger2 == null) {
            throw new InvalidKeyException("ElGamal: getG() == null");
        }
        if (bigInteger4 == null) {
            throw new InvalidKeyException("ElGamal: getY() == null");
        }
        if (bigInteger.bitLength() < 256) {
            throw new InvalidKeyException("ElGamal: getP().bitLength() < 256");
        }
        if (bigInteger.compareTo(B) <= 0) {
            throw new InvalidKeyException("ElGamal: getP() < 2");
        }
        this.C = bigInteger;
        this.F = bigInteger2;
        this.K = bigInteger3;
        this.I = bigInteger4;
        this.H = (this.C.bitLength() + 7) / 8;
        this.G.reset();
    }

    protected void engineUpdate(byte by) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        this.G.update(by);
    }

    protected void engineUpdate(byte[] byArray, int n2, int n3) throws SignatureException {
        if (this.state != 3 && this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized");
        }
        this.G.update(byArray, n2, n3);
    }

    protected byte[] engineSign() throws SignatureException {
        if (this.state != 2) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized for signing");
        }
        BigInteger bigInteger = this.A();
        BigInteger[] bigIntegerArray = new BigInteger[2];
        ElGamalAlgorithm.sign(bigInteger, bigIntegerArray, this.C, this.F, this.K, this.A);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            BI.toStream(bigIntegerArray[0], byteArrayOutputStream);
            BI.toStream(bigIntegerArray[1], byteArrayOutputStream);
        }
        catch (IOException iOException) {
            throw new SignatureException("BI.toStream() failed");
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        BigInteger bigInteger;
        BigInteger bigInteger2;
        if (this.state != 3) {
            throw new SignatureException(this.getAlgorithm() + ": Not initialized for verification");
        }
        BigInteger bigInteger3 = this.A();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            bigInteger2 = BI.fromStream(byteArrayInputStream);
            bigInteger = BI.fromStream(byteArrayInputStream);
        }
        catch (IOException iOException) {
            throw new SignatureException("BI.fromStream() failed");
        }
        return ElGamalAlgorithm.verify(bigInteger3, bigInteger2, bigInteger, this.C, this.F, this.I);
    }

    protected void engineSetParameter(String string, Object object) {
        if (string.equals("random")) {
            if (!(object instanceof Random)) {
                throw new InvalidParameterException("value must be an instance of java.util.Random");
            }
            this.A = (Random)object;
            return;
        }
        throw new InvalidParameterException(string);
    }

    protected Object engineGetParameter(String string) {
        if (string.equals("random")) {
            return this.A;
        }
        return null;
    }

    private BigInteger A() {
        byte[] byArray = this.G.digest();
        int n2 = byArray.length;
        byte[] byArray2 = new byte[this.H];
        byArray2[1] = 1;
        byte[] byArray3 = this.getAlgorithmEncoding();
        int n3 = byArray3.length;
        int n4 = this.H - 3 - n3 - n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            byArray2[2 + i2] = -1;
        }
        System.arraycopy(byArray3, 0, byArray2, n4 + 3, n3);
        System.arraycopy(byArray, 0, byArray2, this.H - n2, n2);
        if (J && E >= 4) {
            Any_ElGamal_PKCS1Signature.A("PKCS#1 frame = " + Hex.dumpString(byArray2));
        }
        return new BigInteger(byArray2);
    }

    protected abstract byte[] getAlgorithmEncoding();
}

