/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.cryptix.provider.cipher;

import com.enterprisedt.cryptix.CryptixException;
import com.enterprisedt.cryptix.provider.key.RawSecretKey;
import com.enterprisedt.cryptix.util.core.ArrayUtil;
import com.enterprisedt.cryptix.util.core.Debug;
import java.security.InvalidKeyException;
import java.security.Key;
import xjava.security.Cipher;
import xjava.security.SymmetricCipher;

public final class IDEA
extends Cipher
implements SymmetricCipher {
    private static final boolean \u0143 = Debug.GLOBAL_DEBUG;
    private static final int \u0147 = \u0143 ? Debug.getLevel("IDEA") : 0;
    private static final int \u0142 = 8;
    private static final int \u0146 = 8;
    private static final int \u0141 = 16;
    private static final int \u0144 = 52;
    private short[] \u0148 = new short[52];
    private static final byte[][][] \u0145 = new byte[][][]{new byte[][]{{0, 1, 0, 2, 0, 3, 0, 4, 0, 5, 0, 6, 0, 7, 0, 8}, {0, 0, 0, 1, 0, 2, 0, 3}, {17, -5, -19, 43, 1, -104, 109, -27}}, new byte[][]{{58, -104, 78, 32, 0, 25, 93, -77, 46, -27, 1, -56, -60, 124, -22, 96}, {1, 2, 3, 4, 5, 6, 7, 8}, {-105, -68, -40, 32, 7, -128, -38, -122}}, new byte[][]{{0, 100, 0, -56, 1, 44, 1, -112, 1, -12, 2, 88, 2, -68, 3, 32}, {5, 50, 10, 100, 20, -56, 25, -6}, {101, -66, -121, -25, -94, 83, -118, -19}}};

    private static void H(String string) {
        Debug.log("IDEA: " + string);
    }

    public IDEA() {
        super(false, false, "CryptixEDT");
    }

    public final Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected int engineBlockSize() {
        return 8;
    }

    protected void engineInitEncrypt(Key key) throws InvalidKeyException, CryptixException {
        this.I(key);
    }

    protected void engineInitDecrypt(Key key) throws InvalidKeyException, CryptixException {
        this.I(key);
        this.H();
    }

    protected int engineUpdate(byte[] byArray, int n2, int n3, byte[] byArray2, int n4) {
        boolean bl;
        if (n3 < 0) {
            throw new IllegalArgumentException("inLen < 0");
        }
        int n5 = n3 / 8;
        n3 = n5 * 8;
        boolean bl2 = bl = this.getState() == 1;
        if (byArray == byArray2 && (n4 >= n2 && (long)n4 < (long)n2 + (long)n3 || n2 >= n4 && (long)n2 < (long)n4 + (long)n3)) {
            byte[] byArray3 = new byte[n3];
            System.arraycopy(byArray, n2, byArray3, 0, n3);
            byArray = byArray3;
            n2 = 0;
        }
        if (bl) {
            for (int i2 = 0; i2 < n5; ++i2) {
                this.L(byArray, n2, byArray2, n4);
                n2 += 8;
                n4 += 8;
            }
        } else {
            for (int i3 = 0; i3 < n5; ++i3) {
                this.K(byArray, n2, byArray2, n4);
                n2 += 8;
                n4 += 8;
            }
        }
        return n3;
    }

    private void I(Key key) throws InvalidKeyException, CryptixException {
        byte[] byArray = key.getEncoded();
        if (byArray == null) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Null user key");
        }
        if (byArray.length != 16) {
            throw new InvalidKeyException(this.getAlgorithm() + ": Invalid user key length");
        }
        this.\u0148[0] = (short)((byArray[0] & 0xFF) << 8 | byArray[1] & 0xFF);
        this.\u0148[1] = (short)((byArray[2] & 0xFF) << 8 | byArray[3] & 0xFF);
        this.\u0148[2] = (short)((byArray[4] & 0xFF) << 8 | byArray[5] & 0xFF);
        this.\u0148[3] = (short)((byArray[6] & 0xFF) << 8 | byArray[7] & 0xFF);
        this.\u0148[4] = (short)((byArray[8] & 0xFF) << 8 | byArray[9] & 0xFF);
        this.\u0148[5] = (short)((byArray[10] & 0xFF) << 8 | byArray[11] & 0xFF);
        this.\u0148[6] = (short)((byArray[12] & 0xFF) << 8 | byArray[13] & 0xFF);
        this.\u0148[7] = (short)((byArray[14] & 0xFF) << 8 | byArray[15] & 0xFF);
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 8; i2 < 52; ++i2) {
            this.\u0148[++n2 + 7 + n3] = (short)(this.\u0148[(n2 & 7) + n3] << 9 | this.\u0148[(n2 + 1 & 7) + n3] >>> 7 & 0x1FF);
            n3 += n2 & 8;
            n2 &= 7;
        }
    }

    private void H() {
        int n2 = 4;
        int n3 = 51;
        short[] sArray = new short[52];
        sArray[n3--] = IDEA.A(this.\u0148[3]);
        sArray[n3--] = -this.\u0148[2];
        sArray[n3--] = -this.\u0148[1];
        sArray[n3--] = IDEA.A(this.\u0148[0]);
        int n4 = 1;
        while (n4 < 8) {
            sArray[n3--] = this.\u0148[n2 + 1];
            sArray[n3--] = this.\u0148[n2];
            sArray[n3--] = IDEA.A(this.\u0148[n2 + 5]);
            sArray[n3--] = -this.\u0148[n2 + 3];
            sArray[n3--] = -this.\u0148[n2 + 4];
            sArray[n3--] = IDEA.A(this.\u0148[n2 + 2]);
            ++n4;
            n2 += 6;
        }
        sArray[n3--] = this.\u0148[n2 + 1];
        sArray[n3--] = this.\u0148[n2];
        sArray[n3--] = IDEA.A(this.\u0148[n2 + 5]);
        sArray[n3--] = -this.\u0148[n2 + 4];
        sArray[n3--] = -this.\u0148[n2 + 3];
        sArray[n3--] = IDEA.A(this.\u0148[n2 + 2]);
        System.arraycopy(sArray, 0, this.\u0148, 0, 52);
    }

    private void L(byte[] byArray, int n2, byte[] byArray2, int n3) {
        short s2;
        short s3 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s4 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s5 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2++] & 0xFF);
        short s6 = (short)((byArray[n2++] & 0xFF) << 8 | byArray[n2] & 0xFF);
        int n4 = 0;
        int n5 = 8;
        while (n5-- > 0) {
            s3 = IDEA.E(s3, this.\u0148[n4++]);
            s4 = (short)(s4 + this.\u0148[n4++]);
            s5 = (short)(s5 + this.\u0148[n4++]);
            s6 = IDEA.E(s6, this.\u0148[n4++]);
            short s7 = s5;
            s5 = IDEA.E(s3 ^ s5, this.\u0148[n4++]);
            s2 = s4;
            s4 = IDEA.E(s5 + (s4 ^ s6), this.\u0148[n4++]);
            s5 = (short)(s5 + s4);
            s3 = (short)(s3 ^ s4);
            s6 = (short)(s6 ^ s5);
            s4 = (short)(s4 ^ s7);
            s5 = (short)(s5 ^ s2);
        }
        s2 = IDEA.E(s3, this.\u0148[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = (short)(s5 + this.\u0148[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = (short)(s4 + this.\u0148[n4++]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3++] = (byte)s2;
        s2 = IDEA.E(s6, this.\u0148[n4]);
        byArray2[n3++] = (byte)(s2 >>> 8);
        byArray2[n3] = (byte)s2;
    }

    private void K(byte[] byArray, int n2, byte[] byArray2, int n3) {
        this.L(byArray, n2, byArray2, n3);
    }

    private static short E(int n2, int n3) {
        n3 &= 0xFFFF;
        if ((n2 &= 0xFFFF) != 0) {
            if (n3 != 0) {
                int n4 = n2 * n3;
                return (short)(n3 - n2 + ((n3 = n4 & 0xFFFF) < (n2 = n4 >>> 16) ? 1 : 0));
            }
            return (short)(1 - n2);
        }
        return (short)(1 - n3);
    }

    private static short A(short s2) {
        int n2 = s2 & 0xFFFF;
        if (n2 <= 1) {
            return (short)n2;
        }
        int n3 = 65537 / n2;
        int n4 = 65537 % n2;
        if (n4 == 1) {
            return (short)(1 - n3);
        }
        int n5 = 1;
        do {
            int n6 = n2 / n4;
            n5 += n6 * n3;
            if ((n2 %= n4) == 1) {
                return (short)n5;
            }
            n6 = n4 / n2;
            n3 += n6 * n5;
        } while ((n4 %= n2) != 1);
        return (short)(1 - n3);
    }

    public static void main(String[] stringArray) {
        try {
            IDEA.self_test();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void self_test() throws Throwable {
        Cipher cipher = Cipher.getInstance("IDEA", "CryptixEDT");
        for (int i2 = 0; i2 < \u0145.length; ++i2) {
            RawSecretKey rawSecretKey = new RawSecretKey("IDEA", \u0145[i2][0]);
            cipher.initEncrypt(rawSecretKey);
            byte[] byArray = cipher.crypt(\u0145[i2][1]);
            if (!ArrayUtil.areEqual(\u0145[i2][2], byArray)) {
                throw new CryptixException("encrypt #" + i2 + " failed");
            }
            cipher.initDecrypt(rawSecretKey);
            byArray = cipher.crypt(\u0145[i2][2]);
            if (ArrayUtil.areEqual(\u0145[i2][1], byArray)) continue;
            throw new CryptixException("decrypt #" + i2 + " failed");
        }
        if (\u0143 && \u0147 > 0) {
            IDEA.H("Self-test OK");
        }
    }
}

