/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import org.jboss.util.NestedRuntimeException;

public class TxUtils {
    private static final String[] TxStatusStrings = new String[]{"STATUS_ACTIVE", "STATUS_MARKED_ROLLBACK", "STATUS_PREPARED", "STATUS_COMMITTED", "STATUS_ROLLEDBACK", "STATUS_UNKNOWN", "STATUS_NO_TRANSACTION", "STATUS_PREPARING", "STATUS_COMMITTING", "STATUS_ROLLING_BACK"};

    private TxUtils() {
    }

    public static boolean isActive(Transaction tx) {
        try {
            return tx != null && tx.getStatus() == 0;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isActive(TransactionManager tm) {
        try {
            return TxUtils.isActive(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isActive(UserTransaction ut) {
        try {
            return ut.getStatus() == 0;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isUncommitted(Transaction tx) {
        try {
            if (tx == null) {
                return false;
            }
            int status = tx.getStatus();
            return status == 0 || status == 1;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isUncommitted(TransactionManager tm) {
        try {
            return TxUtils.isUncommitted(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isUncommitted(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return status == 0 || status == 1;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isCompleted(Transaction tx) {
        try {
            if (tx == null) {
                return true;
            }
            int status = tx.getStatus();
            return status == 3 || status == 4 || status == 6;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isCompleted(TransactionManager tm) {
        try {
            return TxUtils.isCompleted(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isCompleted(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return status == 3 || status == 4 || status == 6;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isRollback(Transaction tx) {
        try {
            if (tx == null) {
                return false;
            }
            int status = tx.getStatus();
            return status == 1 || status == 9 || status == 4;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isRollback(TransactionManager tm) {
        try {
            return TxUtils.isRollback(tm.getTransaction());
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static boolean isRollback(UserTransaction ut) {
        try {
            int status = ut.getStatus();
            return status == 1 || status == 9 || status == 4;
        }
        catch (SystemException error) {
            throw new NestedRuntimeException(error);
        }
    }

    public static String getStatusAsString(int status) {
        if (status >= 0 && status <= 9) {
            return TxStatusStrings[status];
        }
        return "STATUS_INVALID";
    }

    public static String getXAResourceFlagsAsString(int flags) {
        if (flags == 0) {
            return "|TMNOFLAGS";
        }
        StringBuffer sbuf = new StringBuffer(64);
        if ((flags & 0x40000000) != 0) {
            sbuf.append("|TMONEPHASE");
        }
        if ((flags & 0x200000) != 0) {
            sbuf.append("|TMJOIN");
        }
        if ((flags & 0x8000000) != 0) {
            sbuf.append("|TMRESUME");
        }
        if ((flags & 0x4000000) != 0) {
            sbuf.append("|TMSUCCESS");
        }
        if ((flags & 0x20000000) != 0) {
            sbuf.append("|TMFAIL");
        }
        if ((flags & 0x2000000) != 0) {
            sbuf.append("|TMSUSPEND");
        }
        if ((flags & 0x1000000) != 0) {
            sbuf.append("|TMSTARTRSCAN");
        }
        if ((flags & 0x800000) != 0) {
            sbuf.append("|TMENDRSCAN");
        }
        return sbuf.toString();
    }
}

