/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.callback;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.remoting.callback.CallbackStoreMBean;
import org.jboss.remoting.serialization.SerializationStreamFactory;

public class CallbackStore
implements CallbackStoreMBean {
    private static long previousTimestamp;
    private static int timestampCounter;
    private String filePath = null;
    private String fileSuffix = "ser";
    private boolean isStarted = false;
    private boolean purgeOnShutdown = false;
    private String serializationType = "java";
    public static final String FILE_PATH_KEY = "StoreFilePath";
    public static final String FILE_SUFFIX_KEY = "StoreFileSuffix";
    private static final Logger log;
    static /* synthetic */ Class class$org$jboss$remoting$callback$CallbackStore;

    public CallbackStore() {
    }

    public CallbackStore(boolean purgeOnDestroy) {
        this.purgeOnShutdown = purgeOnDestroy;
    }

    public void start() throws Exception {
        if (!this.isStarted) {
            boolean madeDir;
            File storeFile;
            if (this.filePath == null) {
                this.filePath = System.getProperty("jboss.server.data.dir", "data");
            }
            if (!(storeFile = new File(this.filePath)).exists() && !(madeDir = storeFile.mkdirs())) {
                throw new IOException("Can not create directory for store.  Path given: " + this.filePath);
            }
            this.isStarted = true;
        }
    }

    public void setPurgeOnShutdown(boolean purgeOnShutdown) {
        this.purgeOnShutdown = purgeOnShutdown;
    }

    public boolean getPurgeOnShutdown() {
        return this.purgeOnShutdown;
    }

    public void create() throws Exception {
    }

    public void stop() {
        this.isStarted = false;
    }

    public void destroy() {
        if (this.purgeOnShutdown) {
            this.purgeFiles();
        }
    }

    public void purgeFiles() {
        String[] fileList = this.getObjectFileList();
        String fileToDelete = null;
        for (int x = 0; x < fileList.length; ++x) {
            try {
                fileToDelete = this.filePath + System.getProperty("file.separator") + fileList[x];
                File currentFile = new File(fileToDelete);
                boolean deleted = currentFile.delete();
                if (deleted) continue;
                log.warn("Error purging file " + fileToDelete);
                continue;
            }
            catch (Exception e) {
                log.warn("Error purging file " + fileToDelete);
            }
        }
    }

    public void setConfig(Map config) {
        if (config != null) {
            String newSerializationType;
            String newFileSuffix;
            String newFilePath = (String)config.get(FILE_PATH_KEY);
            if (newFilePath != null) {
                this.filePath = newFilePath;
            }
            if ((newFileSuffix = (String)config.get(FILE_SUFFIX_KEY)) != null) {
                this.fileSuffix = newFileSuffix;
            }
            if ((newSerializationType = (String)config.get("serializationtype")) != null) {
                this.serializationType = newSerializationType;
            }
        }
    }

    public String getStoreFilePath() {
        return this.filePath;
    }

    public void setStoreFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getStoreFileSuffix() {
        return this.fileSuffix;
    }

    public void setStoreFileSuffix(String fileSuffix) {
        this.fileSuffix = fileSuffix;
    }

    public int size() {
        this.verifyStarted();
        String[] objectFileList = this.getObjectFileList();
        if (objectFileList != null) {
            return objectFileList.length;
        }
        return 0;
    }

    private void verifyStarted() {
        if (!this.isStarted) {
            throw new RuntimeException("Can not call upon this store method before it has been started.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getNext() throws IOException {
        Object obj;
        block21: {
            this.verifyStarted();
            obj = null;
            String objectFilePath = null;
            String string = this.filePath;
            synchronized (string) {
                IOException ioe22;
                ObjectInputStream in;
                block19: {
                    String[] objectFileList = this.getObjectFileList();
                    FileInputStream inFile = null;
                    in = null;
                    if (objectFileList == null || objectFileList.length <= 0) break block21;
                    try {
                        objectFilePath = this.filePath + System.getProperty("file.separator") + objectFileList[0];
                        inFile = new FileInputStream(objectFilePath);
                        in = SerializationStreamFactory.getManagerInstance(this.serializationType).createRegularInput(inFile);
                        try {
                            obj = in.readObject();
                        }
                        catch (ClassNotFoundException e) {
                            throw new IOException("Error loading persisted object.  Could not load class (" + e.getMessage() + ").");
                        }
                        Object var9_8 = null;
                        if (inFile == null) break block19;
                    }
                    catch (Throwable throwable) {
                        IOException ioe22;
                        Object var9_9 = null;
                        if (inFile != null) {
                            try {
                                inFile.close();
                            }
                            catch (IOException ioe22) {
                                log.debug("Error closing FileInputStream.", ioe22);
                            }
                        }
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (IOException ioe22) {
                                log.debug("Error closing ObjectInputStream.", ioe22);
                            }
                        }
                        if (objectFilePath != null) {
                            File objectFile = new File(objectFilePath);
                            boolean isDeleted = objectFile.delete();
                            if (log.isTraceEnabled()) {
                                log.trace("object file (" + objectFilePath + ") has been deleted - " + isDeleted);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        inFile.close();
                    }
                    catch (IOException ioe22) {
                        log.debug("Error closing FileInputStream.", ioe22);
                    }
                }
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException ioe22) {
                        log.debug("Error closing ObjectInputStream.", ioe22);
                    }
                }
                if (objectFilePath == null) break block21;
                File objectFile = new File(objectFilePath);
                boolean isDeleted = objectFile.delete();
                if (log.isTraceEnabled()) {
                    log.trace("object file (" + objectFilePath + ") has been deleted - " + isDeleted);
                }
            }
        }
        return obj;
    }

    private String[] getObjectFileList() {
        File storePath = new File(this.filePath);
        Object[] objectFileList = storePath.list(new StoreFileFilter());
        Arrays.sort(objectFileList);
        return objectFileList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Serializable object) throws IOException {
        this.verifyStarted();
        String string = this.filePath;
        synchronized (string) {
            IOException ioe22;
            ObjectOutputStream out;
            block16: {
                long currentTimestamp = System.currentTimeMillis();
                if (previousTimestamp == currentTimestamp) {
                    ++timestampCounter;
                } else {
                    previousTimestamp = currentTimestamp;
                    timestampCounter = 0;
                }
                StringBuffer path = new StringBuffer(this.filePath);
                path.append(System.getProperty("file.separator")).append(String.valueOf(currentTimestamp));
                path.append("-").append(timestampCounter).append(".").append(this.fileSuffix);
                File storeFile = new File(path.toString());
                FileOutputStream outFile = null;
                out = null;
                try {
                    outFile = new FileOutputStream(storeFile, false);
                    out = SerializationStreamFactory.getManagerInstance(this.serializationType).createOutput(outFile);
                    out.writeObject(object);
                    out.flush();
                    Object var10_8 = null;
                    if (outFile == null) break block16;
                }
                catch (Throwable throwable) {
                    IOException ioe22;
                    Object var10_9 = null;
                    if (outFile != null) {
                        try {
                            outFile.close();
                        }
                        catch (IOException ioe22) {
                            log.debug("Error closing FileInputStream.", ioe22);
                        }
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException ioe22) {
                            log.debug("Error closing ObjectInputStream.", ioe22);
                        }
                    }
                    throw throwable;
                }
                try {
                    outFile.close();
                }
                catch (IOException ioe22) {
                    log.debug("Error closing FileInputStream.", ioe22);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException ioe22) {
                    log.debug("Error closing ObjectInputStream.", ioe22);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = Logger.getLogger(class$org$jboss$remoting$callback$CallbackStore == null ? (class$org$jboss$remoting$callback$CallbackStore = CallbackStore.class$("org.jboss.remoting.callback.CallbackStore")) : class$org$jboss$remoting$callback$CallbackStore);
    }

    public class StoreFileFilter
    implements FilenameFilter {
        public boolean accept(File dir, String name) {
            return name.endsWith(CallbackStore.this.fileSuffix);
        }
    }
}

