/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.lang;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javassist.CtClass;
import javassist.CtConstructor;
import javassist.CtField;
import javassist.CtMethod;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.ClassFile;
import javassist.bytecode.FieldInfo;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.SignatureAttribute;
import org.jboss.javassist.JavassistUtil;
import org.jboss.lang.JBossStringBuilder;
import org.jboss.lang.reflect.GenericArrayTypeImpl;
import org.jboss.lang.reflect.ParameterizedTypeImpl;
import org.jboss.lang.reflect.Type;
import org.jboss.lang.reflect.TypeVariable;
import org.jboss.lang.reflect.TypeVariableImpl;

public class GenericsHelper {
    static final Type[] NO_TYPES = new Type[0];
    static final TypeVariable[] NO_TYPE_VARIABLES = new TypeVariable[0];

    public static TypeVariable[] getTypeParameters(Class clazz) {
        SignatureAttribute.ClassSignature sig = GenericsHelper.getClassSignature(clazz);
        if (sig != null) {
            SignatureAttribute.TypeParameter[] params = sig.getParameters();
            TypeVariable[] tparams = new TypeVariable[params.length];
            for (int i = 0; i < params.length; ++i) {
                Object[] bounds = null;
                try {
                    bounds = GenericsHelper.getBounds(params[i].getClassBound(), params[i].getInterfaceBound());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException(cnfe);
                }
                tparams[i] = new TypeVariableImpl(bounds, clazz, params[i].getName());
            }
            return tparams;
        }
        return NO_TYPE_VARIABLES;
    }

    private static Object[] getBounds(SignatureAttribute.ObjectType classBound, SignatureAttribute.ObjectType[] interfaceBounds) throws ClassNotFoundException {
        Object[] bounds = null;
        if (classBound == null && (interfaceBounds == null || interfaceBounds.length == 0)) {
            bounds = new Object[]{Class.forName("java.lang.Object")};
        } else if (interfaceBounds == null || interfaceBounds.length == 0) {
            Class<?> superClass = Class.forName(classBound.toString());
            bounds = new Object[]{superClass};
        } else if (classBound == null) {
            bounds = new Object[interfaceBounds.length];
            for (int i = 0; i < interfaceBounds.length; ++i) {
                bounds[i] = Class.forName(interfaceBounds[i].toString());
            }
        } else {
            bounds = new Object[interfaceBounds.length + 1];
            bounds[0] = Class.forName(classBound.toString());
            for (int i = 0; i < interfaceBounds.length; ++i) {
                bounds[i + 1] = Class.forName(interfaceBounds[i].toString());
            }
        }
        return bounds;
    }

    public static Object[] getGenericInterfaces(Class clazz) {
        try {
            SignatureAttribute.ClassSignature sig = GenericsHelper.getClassSignature(clazz);
            if (sig != null) {
                SignatureAttribute.ClassType[] ifs = sig.getInterfaces();
                Object[] inters = new Object[ifs.length];
                for (int i = 0; i < ifs.length; ++i) {
                    inters[i] = GenericsHelper.createType(Class.forName(ifs[i].getName()), (SignatureAttribute.Type)ifs[i]);
                }
                return inters;
            }
            return clazz.getInterfaces();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object getGenericSuperclass(Class clazz) {
        SignatureAttribute.ClassType supa;
        SignatureAttribute.ClassSignature sig;
        if (!clazz.isInterface() && (sig = GenericsHelper.getClassSignature(clazz)) != null && (supa = sig.getSuperClass()) != null) {
            return GenericsHelper.createType(clazz.getSuperclass(), (SignatureAttribute.Type)supa);
        }
        return clazz.getSuperclass();
    }

    public static TypeVariable[] getTypeParameters(Constructor ctor) {
        SignatureAttribute.MethodSignature methodSig = GenericsHelper.getMethodSignature(ctor);
        if (methodSig != null) {
            SignatureAttribute.TypeParameter[] params = methodSig.getTypeParameters();
            TypeVariable[] tparams = new TypeVariable[params.length];
            for (int i = 0; i < params.length; ++i) {
                Object[] bounds = null;
                try {
                    bounds = GenericsHelper.getBounds(params[i].getClassBound(), params[i].getInterfaceBound());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException(cnfe);
                }
                tparams[i] = new TypeVariableImpl(bounds, params[i].getClass(), params[i].getName());
            }
            return tparams;
        }
        return NO_TYPE_VARIABLES;
    }

    public static Object[] getGenericParameterTypes(Constructor c) {
        SignatureAttribute.MethodSignature methodSig = GenericsHelper.getMethodSignature(c);
        return GenericsHelper.getGenericParameterTypes(c.getDeclaringClass(), c.getParameterTypes(), methodSig);
    }

    public static Object[] getGenericExceptionTypes(Constructor c) {
        SignatureAttribute.MethodSignature methodSig = GenericsHelper.getMethodSignature(c);
        return GenericsHelper.getGenericExceptionTypes(c.getExceptionTypes(), methodSig);
    }

    public static String toGenericString(Constructor c) {
        SignatureAttribute.MethodSignature methodSig = GenericsHelper.getMethodSignature(c);
        JBossStringBuilder buf = new JBossStringBuilder();
        GenericsHelper.appendModifiers(buf, c);
        GenericsHelper.appendTypeParameters(buf, GenericsHelper.getTypeParameters(c));
        buf.append(c.getDeclaringClass().getName());
        GenericsHelper.appendGenericParameterTypes(buf, GenericsHelper.getGenericParameterTypes(c.getDeclaringClass(), c.getParameterTypes(), methodSig));
        if (c.getExceptionTypes().length > 0) {
            buf.append(" throws ");
            GenericsHelper.appendGenericExceptionTypes(buf, GenericsHelper.getGenericExceptionTypes(c.getExceptionTypes(), methodSig));
        }
        return buf.toString();
    }

    public static TypeVariable[] getTypeParameters(Method meth) {
        SignatureAttribute.MethodSignature methodSig = GenericsHelper.getMethodSignature(meth);
        if (methodSig != null) {
            SignatureAttribute.TypeParameter[] params = methodSig.getTypeParameters();
            TypeVariable[] tparams = new TypeVariable[params.length];
            for (int i = 0; i < params.length; ++i) {
                Object[] bounds = null;
                try {
                    bounds = GenericsHelper.getBounds(params[i].getClassBound(), params[i].getInterfaceBound());
                }
                catch (ClassNotFoundException cnfe) {
                    throw new RuntimeException(cnfe);
                }
                tparams[i] = new TypeVariableImpl(bounds, params[i].getClass(), params[i].getName());
            }
            return tparams;
        }
        return NO_TYPE_VARIABLES;
    }

    public static Object getGenericReturnType(Method m) {
        SignatureAttribute.MethodSignature methodSig = GenericsHelper.getMethodSignature(m);
        return GenericsHelper.getGenericReturnType(m, methodSig);
    }

    public static Object[] getGenericParameterTypes(Method m) {
        SignatureAttribute.MethodSignature methodSig = GenericsHelper.getMethodSignature(m);
        return GenericsHelper.getGenericParameterTypes(m.getDeclaringClass(), m.getParameterTypes(), methodSig);
    }

    public static Object[] getGenericExceptionTypes(Method m) {
        SignatureAttribute.MethodSignature methodSig = GenericsHelper.getMethodSignature(m);
        return GenericsHelper.getGenericExceptionTypes(m.getExceptionTypes(), methodSig);
    }

    public static String toGenericString(Method m) {
        SignatureAttribute.MethodSignature methodSig = GenericsHelper.getMethodSignature(m);
        JBossStringBuilder buf = new JBossStringBuilder();
        GenericsHelper.appendModifiers(buf, m);
        buf.append(GenericsHelper.formatTypeName(GenericsHelper.getGenericReturnType(m, methodSig)));
        buf.append(" ");
        buf.append(m.getDeclaringClass().getName());
        buf.append(".");
        buf.append(m.getName());
        GenericsHelper.appendGenericParameterTypes(buf, GenericsHelper.getGenericParameterTypes(m.getDeclaringClass(), m.getParameterTypes(), methodSig));
        if (m.getExceptionTypes().length > 0) {
            buf.append(" throws ");
            GenericsHelper.appendGenericExceptionTypes(buf, GenericsHelper.getGenericExceptionTypes(m.getExceptionTypes(), methodSig));
        }
        return buf.toString();
    }

    public static Object getGenericType(Field f) {
        CtField fld = JavassistUtil.getCtField(f);
        FieldInfo info = fld.getFieldInfo2();
        SignatureAttribute sig = (SignatureAttribute)info.getAttribute("Signature");
        if (sig != null) {
            try {
                SignatureAttribute.ObjectType type = SignatureAttribute.toFieldSignature((String)sig.getSignature());
                return GenericsHelper.createType(f.getType(), (SignatureAttribute.Type)type);
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
        }
        return f.getType();
    }

    public static String toGenericString(Field f) {
        JBossStringBuilder buf = new JBossStringBuilder();
        GenericsHelper.appendModifiers(buf, f);
        Object type = GenericsHelper.getGenericType(f);
        buf.append(GenericsHelper.formatTypeName(type));
        buf.append(" ");
        buf.append(f.getDeclaringClass().getName());
        buf.append(".");
        buf.append(f.getName());
        return buf.toString();
    }

    public static Object[] getTypeParameters(Object o) {
        if (o instanceof Class) {
            return GenericsHelper.getTypeParameters((Class)o);
        }
        if (o instanceof Method) {
            return GenericsHelper.getTypeParameters((Method)o);
        }
        if (o instanceof Constructor) {
            return GenericsHelper.getTypeParameters((Constructor)o);
        }
        if (o == null) {
            throw new IllegalArgumentException("Null object passed in");
        }
        throw new IllegalArgumentException(new JBossStringBuilder().append("Object of type ").append(o.getClass().getName()).append(" does not implement GenericDeclaration").toString());
    }

    private static String formatTypeName(Object type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.toString();
    }

    private static void appendModifiers(JBossStringBuilder buf, Member m) {
        int length = buf.length();
        buf.append(Modifier.toString(m.getModifiers()));
        if (buf.length() > length) {
            buf.append(" ");
        }
    }

    private static void appendTypeParameters(JBossStringBuilder buf, TypeVariable[] tvs) {
        if (tvs.length == 0) {
            return;
        }
        buf.append("<");
        for (int i = 0; i < tvs.length; ++i) {
            if (i > 0) {
                buf.append(",");
            }
            buf.append(tvs[i]);
        }
        buf.append("> ");
    }

    private static void appendGenericParameterTypes(JBossStringBuilder buf, Object[] params) {
        buf.append("(");
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(GenericsHelper.formatTypeName(params[i]));
        }
        buf.append(")");
    }

    private static void appendGenericExceptionTypes(JBossStringBuilder buf, Object[] exceptions) {
        for (int i = 0; i < exceptions.length; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(exceptions[i].toString());
        }
    }

    private static Object createType(Class targetClass, SignatureAttribute.Type type) {
        try {
            if (type instanceof SignatureAttribute.ClassType) {
                SignatureAttribute.ClassType stype = (SignatureAttribute.ClassType)type;
                Class raw = targetClass;
                SignatureAttribute.TypeArgument[] args = ((SignatureAttribute.ClassType)type).getTypeArguments();
                if (args == null) {
                    return raw;
                }
                Object ownerType = null;
                Object[] typeArgs = NO_TYPES;
                if (type instanceof SignatureAttribute.NestedClassType) {
                    throw new RuntimeException("NestedClassType types are not yet supported");
                }
                if (args.length > 0) {
                    typeArgs = new Object[args.length];
                    for (int i = 0; i < args.length; ++i) {
                        if (args[i].isWildcard()) {
                            throw new RuntimeException("Wildcard argument types are not yet supported");
                        }
                        if (args[i].getType() instanceof SignatureAttribute.ClassType) {
                            typeArgs[i] = Class.forName(((SignatureAttribute.ClassType)args[i].getType()).getName());
                            continue;
                        }
                        if (args[i].getType() instanceof SignatureAttribute.TypeVariable) {
                            SignatureAttribute.TypeVariable tv = (SignatureAttribute.TypeVariable)args[i].getType();
                            Object[] bounds = new Object[]{Class.forName("java.lang.Object")};
                            String varname = tv.getName();
                            Class decl = targetClass;
                            typeArgs[i] = new TypeVariableImpl(bounds, decl, varname);
                            continue;
                        }
                        throw new RuntimeException(new JBossStringBuilder().append("Invalid argument type ").append(args[i].getType()).toString());
                    }
                }
                ParameterizedTypeImpl paramType = new ParameterizedTypeImpl(type.toString(), raw, ownerType, typeArgs);
                return paramType;
            }
            if (type instanceof SignatureAttribute.TypeVariable) {
                SignatureAttribute.TypeVariable tv = (SignatureAttribute.TypeVariable)type;
                Object[] bounds = new Object[]{Class.forName("java.lang.Object")};
                String varname = tv.getName();
                Class decl = targetClass;
                return new TypeVariableImpl(bounds, decl, varname);
            }
            if (type instanceof SignatureAttribute.ArrayType) {
                SignatureAttribute.ArrayType arrayType = (SignatureAttribute.ArrayType)type;
                return new GenericArrayTypeImpl(arrayType.getComponentType(), arrayType.getDimension(), arrayType.toString());
            }
            if (type instanceof SignatureAttribute.BaseType) {
                SignatureAttribute.BaseType baseType = (SignatureAttribute.BaseType)type;
                return GenericsHelper.getPrimitiveType(baseType.getDescriptor());
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        throw new RuntimeException(new JBossStringBuilder().append("Unknown type ").append(type.getClass()).toString());
    }

    private static Class getPrimitiveType(char typeDescriptor) {
        if (typeDescriptor == 'V') {
            return Void.TYPE;
        }
        if (typeDescriptor == 'I') {
            return Integer.TYPE;
        }
        if (typeDescriptor == 'B') {
            return Byte.TYPE;
        }
        if (typeDescriptor == 'J') {
            return Long.TYPE;
        }
        if (typeDescriptor == 'D') {
            return Double.TYPE;
        }
        if (typeDescriptor == 'F') {
            return Float.TYPE;
        }
        if (typeDescriptor == 'C') {
            return Character.TYPE;
        }
        if (typeDescriptor == 'S') {
            return Short.TYPE;
        }
        if (typeDescriptor == 'Z') {
            return Boolean.TYPE;
        }
        throw new RuntimeException(new JBossStringBuilder().append("bad descriptor: ").append(typeDescriptor).toString());
    }

    private static Class getRawClass(SignatureAttribute.ClassType type) {
        try {
            String name = type.getName();
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private static SignatureAttribute.ClassSignature getClassSignature(Class clazz) {
        CtClass ctclazz = JavassistUtil.getCtClass(clazz);
        ClassFile cf = ctclazz.getClassFile2();
        SignatureAttribute sig = (SignatureAttribute)cf.getAttribute("Signature");
        if (sig != null) {
            try {
                SignatureAttribute.ClassSignature type = SignatureAttribute.toClassSignature((String)sig.getSignature());
                return type;
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static SignatureAttribute.MethodSignature getMethodSignature(Method m) {
        CtMethod mtd = JavassistUtil.getCtMethod(m);
        MethodInfo info = mtd.getMethodInfo2();
        return GenericsHelper.getMethodSignature(info);
    }

    private static SignatureAttribute.MethodSignature getMethodSignature(Constructor c) {
        CtConstructor con = JavassistUtil.getCtConstructor(c);
        MethodInfo info = con.getMethodInfo2();
        return GenericsHelper.getMethodSignature(info);
    }

    private static SignatureAttribute.MethodSignature getMethodSignature(MethodInfo info) {
        SignatureAttribute sig = (SignatureAttribute)info.getAttribute("Signature");
        if (sig != null) {
            try {
                SignatureAttribute.MethodSignature type = SignatureAttribute.toMethodSignature((String)sig.getSignature());
                return type;
            }
            catch (BadBytecode e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    private static Object getGenericReturnType(Method m, SignatureAttribute.MethodSignature methodSig) {
        if (methodSig != null) {
            return GenericsHelper.createType(m.getReturnType(), methodSig.getReturnType());
        }
        return m.getReturnType();
    }

    private static Object[] getGenericParameterTypes(Class targetClass, Class[] parameterTypes, SignatureAttribute.MethodSignature methodSig) {
        if (methodSig != null) {
            SignatureAttribute.Type[] types = methodSig.getParameterTypes();
            Object[] paramTypes = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                paramTypes[i] = GenericsHelper.createType(parameterTypes[i], types[i]);
            }
            return paramTypes;
        }
        return parameterTypes;
    }

    private static Object[] getGenericExceptionTypes(Class[] exceptionTypes, SignatureAttribute.MethodSignature methodSig) {
        if (methodSig != null) {
            SignatureAttribute.ObjectType[] types = methodSig.getExceptionTypes();
            Object[] exTypes = new Object[types.length];
            for (int i = 0; i < types.length; ++i) {
                exTypes[i] = GenericsHelper.createType(exceptionTypes[i], (SignatureAttribute.Type)types[i]);
            }
            return exTypes;
        }
        return exceptionTypes;
    }
}

