/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Iterator;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSinkNode;
import org.drools.reteoo.TupleSource;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.DataProvider;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListEntry;
import org.drools.util.TupleHashTable;

public class FromNode
extends TupleSource
implements TupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private DataProvider dataProvider;
    private TupleSource tupleSource;
    private AlphaNodeFieldConstraint[] alphaConstraints;
    private BetaConstraints betaConstraints;
    private TupleSinkNode previousTupleSinkNode;
    private TupleSinkNode nextTupleSinkNode;
    protected boolean tupleMemoryEnabled;

    public FromNode(int id, DataProvider dataProvider, TupleSource tupleSource, AlphaNodeFieldConstraint[] constraints, BetaConstraints binder) {
        super(id);
        this.dataProvider = dataProvider;
        this.tupleSource = tupleSource;
        this.alphaConstraints = constraints;
        this.betaConstraints = binder == null ? EmptyBetaConstraints.getInstance() : binder;
        this.tupleMemoryEnabled = false;
    }

    public void assertTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        memory.getTupleMemory().add(leftTuple);
        LinkedList list = new LinkedList();
        this.betaConstraints.updateFromTuple(workingMemory, leftTuple);
        Iterator it = this.dataProvider.getResults(leftTuple, workingMemory, context);
        while (it.hasNext()) {
            Object object = it.next();
            if (this.alphaConstraints != null) {
                boolean isAllowed = true;
                int length = this.alphaConstraints.length;
                for (int i = 0; i < length; ++i) {
                    if (this.alphaConstraints[i].isAllowed(object, workingMemory)) continue;
                    isAllowed = false;
                    break;
                }
                if (!isAllowed) continue;
            }
            if (!this.betaConstraints.isAllowedCachedLeft(object)) continue;
            InternalFactHandle handle = workingMemory.getFactHandleFactory().newFactHandle(object);
            list.add(new LinkedListEntry(handle));
            this.sink.propagateAssertTuple(leftTuple, handle, context, workingMemory);
        }
        if (!list.isEmpty()) {
            memory.getCreatedHandles().put(leftTuple, list);
        }
    }

    public void retractTuple(ReteTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        ReteTuple tuple = memory.getTupleMemory().remove(leftTuple);
        LinkedList list = (LinkedList)memory.getCreatedHandles().remove(tuple);
        if (list != null) {
            for (LinkedListEntry entry = (LinkedListEntry)list.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
                InternalFactHandle handle = (InternalFactHandle)entry.getObject();
                this.sink.propagateRetractTuple(leftTuple, handle, context, workingMemory);
                workingMemory.getFactHandleFactory().destroyFactHandle(handle);
            }
        }
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        int length = workingMemories.length;
        for (int i = 0; i < length; ++i) {
            InternalWorkingMemory workingMemory = workingMemories[i];
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void remove(BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((TupleSink)((Object)node));
        }
        this.removeShare();
        if (!this.isInUse()) {
            int length = workingMemories.length;
            for (int i = 0; i < length; ++i) {
                workingMemories[i].clearNodeMemory(this);
            }
        }
        this.tupleSource.remove(this, workingMemories);
    }

    public void updateSink(TupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory(this);
        org.drools.util.Iterator tupleIter = memory.getTupleMemory().iterator();
        ReteTuple tuple = (ReteTuple)tupleIter.next();
        while (tuple != null) {
            LinkedList list = (LinkedList)memory.getCreatedHandles().remove(tuple);
            if (list != null) {
                for (LinkedListEntry entry = (LinkedListEntry)list.getFirst(); entry != null; entry = (LinkedListEntry)entry.getNext()) {
                    InternalFactHandle handle = (InternalFactHandle)entry.getObject();
                    this.sink.propagateRetractTuple(tuple, handle, context, workingMemory);
                    workingMemory.getFactHandleFactory().destroyFactHandle(handle);
                }
            }
            tuple = (ReteTuple)tupleIter.next();
        }
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new BetaMemory(new TupleHashTable(), null);
    }

    public boolean isTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public TupleSinkNode getNextTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextTupleSinkNode(TupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public TupleSinkNode getPreviousTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousTupleSinkNode(TupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }
}

