/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.graph.action;

import bsh.EvalError;
import bsh.Interpreter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.context.exe.ContextInstance;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.graph.exe.Token;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.jpdl.xml.Parsable;

public class Script
extends Action
implements Parsable {
    private static final long serialVersionUID = 1L;
    protected String expression = null;
    protected Set variableAccesses = null;
    private static final Log log = LogFactory.getLog((Class)Script.class);

    public void read(Element scriptElement, JpdlXmlReader jpdlReader) {
        if (scriptElement.isTextOnly()) {
            this.expression = scriptElement.getTextTrim();
        } else {
            this.variableAccesses = new HashSet(jpdlReader.readVariableAccesses(scriptElement));
            this.expression = scriptElement.element("expression").getTextTrim();
        }
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        Map outputMap = this.eval(executionContext);
        this.setVariables(outputMap, executionContext);
    }

    public Map eval(Token token) throws Exception {
        return this.eval(new ExecutionContext(token));
    }

    public Map eval(ExecutionContext executionContext) throws Exception {
        Map inputMap = this.createInputMap(executionContext);
        Set outputNames = this.getOutputNames();
        return this.eval(inputMap, outputNames);
    }

    public Map createInputMap(ExecutionContext executionContext) {
        HashMap<String, Object> inputMap;
        block3: {
            ContextInstance contextInstance;
            Token token;
            block2: {
                token = executionContext.getToken();
                inputMap = new HashMap<String, Object>();
                inputMap.put("executionContext", executionContext);
                inputMap.put("token", token);
                inputMap.put("node", executionContext.getNode());
                inputMap.put("task", executionContext.getTask());
                inputMap.put("taskInstance", executionContext.getTaskInstance());
                contextInstance = executionContext.getContextInstance();
                if (this.hasReadableVariable()) break block2;
                Map variables = contextInstance.getVariables(token);
                if (variables == null) break block3;
                Iterator iter = variables.entrySet().iterator();
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    String variableName = (String)entry.getKey();
                    Object variableValue = entry.getValue();
                    inputMap.put(variableName, variableValue);
                }
                break block3;
            }
            Iterator iter = this.variableAccesses.iterator();
            while (iter.hasNext()) {
                VariableAccess variableAccess = (VariableAccess)iter.next();
                if (!variableAccess.isReadable()) continue;
                String variableName = variableAccess.getVariableName();
                String mappedName = variableAccess.getMappedName();
                Object variableValue = contextInstance.getVariable(variableName, token);
                inputMap.put(mappedName, variableValue);
            }
        }
        return inputMap;
    }

    public Map eval(Map inputMap, Set outputNames) throws Exception {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        try {
            log.debug((Object)("script input: " + inputMap));
            Interpreter interpreter = new Interpreter();
            Iterator<Object> iter = inputMap.keySet().iterator();
            while (iter.hasNext()) {
                String inputName = (String)iter.next();
                Object inputValue = inputMap.get(inputName);
                interpreter.set(inputName, inputValue);
            }
            interpreter.eval(this.expression);
            iter = outputNames.iterator();
            while (iter.hasNext()) {
                String outputName = (String)iter.next();
                Object outputValue = interpreter.get(outputName);
                outputMap.put(outputName, outputValue);
            }
            log.debug((Object)("script output: " + outputMap));
        }
        catch (EvalError e) {
            log.warn((Object)"exception during evaluation of script expression", (Throwable)e);
            if (e.getCause() instanceof Exception) {
                throw (Exception)e.getCause();
            }
            if (e.getCause() instanceof Error) {
                throw (Error)e.getCause();
            }
            throw e;
        }
        return outputMap;
    }

    public void addVariableAccess(VariableAccess variableAccess) {
        if (this.variableAccesses == null) {
            this.variableAccesses = new HashSet();
        }
        this.variableAccesses.add(variableAccess);
    }

    Set getOutputNames() {
        HashSet<String> outputNames = new HashSet<String>();
        if (this.variableAccesses != null) {
            Iterator iter = this.variableAccesses.iterator();
            while (iter.hasNext()) {
                VariableAccess variableAccess = (VariableAccess)iter.next();
                if (!variableAccess.isWritable()) continue;
                outputNames.add(variableAccess.getMappedName());
            }
        }
        return outputNames;
    }

    boolean hasReadableVariable() {
        if (this.variableAccesses == null) {
            return false;
        }
        Iterator iter = this.variableAccesses.iterator();
        while (iter.hasNext()) {
            VariableAccess variableAccess = (VariableAccess)iter.next();
            if (!variableAccess.isReadable()) continue;
            return true;
        }
        return false;
    }

    void setVariables(Map outputMap, ExecutionContext executionContext) {
        if (outputMap != null && !outputMap.isEmpty() && executionContext != null) {
            Map variableNames = this.getVariableNames();
            ContextInstance contextInstance = executionContext.getContextInstance();
            Token token = executionContext.getToken();
            Iterator iter = outputMap.keySet().iterator();
            while (iter.hasNext()) {
                String mappedName = (String)iter.next();
                String variableName = (String)variableNames.get(mappedName);
                contextInstance.setVariable(variableName, outputMap.get(mappedName), token);
            }
        }
    }

    Map getVariableNames() {
        HashMap<String, String> variableNames = new HashMap<String, String>();
        Iterator iter = this.variableAccesses.iterator();
        while (iter.hasNext()) {
            VariableAccess variableAccess = (VariableAccess)iter.next();
            if (!variableAccess.isWritable()) continue;
            variableNames.put(variableAccess.getMappedName(), variableAccess.getVariableName());
        }
        return variableNames;
    }

    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public Set getVariableAccesses() {
        return this.variableAccesses;
    }

    public void setVariableAccesses(Set variableAccesses) {
        this.variableAccesses = variableAccesses;
    }
}

