/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.addressing;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.ws.addressing.AddressingBuilder;
import javax.xml.ws.addressing.AddressingConstants;
import javax.xml.ws.addressing.AddressingProperties;
import javax.xml.ws.addressing.AddressingType;
import javax.xml.ws.addressing.AttributedURI;
import javax.xml.ws.addressing.EndpointReference;
import javax.xml.ws.addressing.ReferenceParameters;
import javax.xml.ws.addressing.Relationship;
import org.jboss.ws.extensions.addressing.AddressingConstantsImpl;
import org.jboss.ws.extensions.addressing.AttributedURIImpl;
import org.jboss.ws.extensions.addressing.ElementExtensibleImpl;
import org.jboss.ws.extensions.addressing.ReferenceParametersImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressingPropertiesImpl
extends ElementExtensibleImpl
implements AddressingProperties {
    private static AddressingConstants ADDR = new AddressingConstantsImpl();
    private AttributedURI to;
    private AttributedURI action;
    private AttributedURI messageId;
    private Relationship[] relatesTo;
    private EndpointReference replyTo;
    private EndpointReference faultTo;
    private EndpointReference from;
    private ReferenceParameters refParams = new ReferenceParametersImpl();
    private Map<QName, AddressingType> addrTypes = new HashMap<QName, AddressingType>();
    private boolean initialized = false;

    public AttributedURI getTo() {
        return this.to;
    }

    public void setTo(AttributedURI to) {
        this.to = to;
    }

    public AttributedURI getAction() {
        return this.action;
    }

    public void setAction(AttributedURI action) {
        this.action = action;
    }

    public AttributedURI getMessageID() {
        return this.messageId;
    }

    public void setMessageID(AttributedURI iri) {
        this.messageId = iri;
    }

    public Relationship[] getRelatesTo() {
        return this.relatesTo;
    }

    public void setRelatesTo(Relationship[] relatesTo) {
        this.relatesTo = relatesTo;
    }

    public EndpointReference getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(EndpointReference replyTo) {
        this.replyTo = replyTo;
    }

    public EndpointReference getFaultTo() {
        return this.faultTo;
    }

    public void setFaultTo(EndpointReference faultTo) {
        this.faultTo = faultTo;
    }

    public EndpointReference getFrom() {
        return this.from;
    }

    public void setFrom(EndpointReference from) {
        this.from = from;
    }

    public ReferenceParameters getReferenceParameters() {
        return this.refParams;
    }

    public void initializeAsDestination(EndpointReference epr) {
        if (this.initialized) {
            return;
        }
        if (epr == null) {
            throw new IllegalArgumentException("Invalid null endpoint reference");
        }
        this.to = epr.getAddress();
        ReferenceParameters srcParams = epr.getReferenceParameters();
        for (Object obj : srcParams.getElements()) {
            SOAPElement soapElement = (SOAPElement)obj;
            soapElement.setAttributeNS(this.getNamespaceURI(), "wsa:IsReferenceParameter", "true");
            this.addElement(soapElement);
        }
        this.initialized = true;
    }

    public void initializeAsReply(AddressingProperties props, boolean isFault) {
        EndpointReference epr;
        if (this.initialized) {
            return;
        }
        EndpointReference endpointReference = epr = isFault ? props.getFaultTo() : null;
        if (epr == null) {
            epr = props.getReplyTo();
        }
        Object object = this.to = epr != null ? epr.getAddress() : new AttributedURIImpl(ADDR.getAnonymousURI());
        if (epr != null) {
            ReferenceParameters srcParams = epr.getReferenceParameters();
            for (Object obj : srcParams.getElements()) {
                SOAPElement soapElement = (SOAPElement)obj;
                soapElement.setAttributeNS(this.getNamespaceURI(), "wsa:IsReferenceParameter", "true");
                this.addElement(soapElement);
            }
        }
        if (props.getMessageID() != null) {
            AddressingBuilder builder = AddressingBuilder.getAddressingBuilder();
            Relationship rel = builder.newRelationship(props.getMessageID().getURI());
            this.relatesTo = new Relationship[]{rel};
        }
        this.initialized = true;
    }

    public int size() {
        return this.addrTypes.size();
    }

    public boolean isEmpty() {
        return this.addrTypes.isEmpty();
    }

    public boolean containsKey(Object arg0) {
        return this.addrTypes.containsKey(arg0);
    }

    public boolean containsValue(Object arg0) {
        return this.addrTypes.containsValue(arg0);
    }

    public AddressingType get(Object arg0) {
        return this.addrTypes.get(arg0);
    }

    public AddressingType put(QName arg0, AddressingType arg1) {
        return this.addrTypes.put(arg0, arg1);
    }

    public AddressingType remove(Object arg0) {
        return this.addrTypes.remove(arg0);
    }

    public void putAll(Map<? extends QName, ? extends AddressingType> arg0) {
        this.addrTypes.putAll(arg0);
    }

    public void clear() {
        this.addrTypes.clear();
    }

    public Set<QName> keySet() {
        return this.addrTypes.keySet();
    }

    public Collection<AddressingType> values() {
        return this.addrTypes.values();
    }

    public Set<Map.Entry<QName, AddressingType>> entrySet() {
        return this.addrTypes.entrySet();
    }
}

