/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.drools.RuleBaseConfiguration;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BaseNode;
import org.drools.reteoo.ReteTuple;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.TupleSink;
import org.drools.reteoo.TupleSource;
import org.drools.rule.EvalCondition;
import org.drools.spi.PropagationContext;
import org.drools.util.LinkedList;
import org.drools.util.LinkedListObjectWrapper;

class EvalConditionNode
extends TupleSource
implements TupleSink,
NodeMemory {
    private static final long serialVersionUID = 1986131208174298080L;
    private final EvalCondition condition;
    private final TupleSource tupleSource;

    EvalConditionNode(int n, TupleSource tupleSource, EvalCondition evalCondition) {
        super(n);
        this.condition = evalCondition;
        this.tupleSource = tupleSource;
        this.hasMemory = true;
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        this.attach();
        int n = reteooWorkingMemoryArray.length;
        for (int i = 0; i < n; ++i) {
            ReteooWorkingMemory reteooWorkingMemory = reteooWorkingMemoryArray[i];
            PropagationContextImpl propagationContextImpl = new PropagationContextImpl(reteooWorkingMemory.getNextPropagationIdCounter(), 3, null, null);
            this.tupleSource.updateNewNode(reteooWorkingMemory, propagationContextImpl);
        }
    }

    public EvalCondition getCondition() {
        return this.condition;
    }

    public void assertTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        boolean bl = this.condition.isAllowed(reteTuple, reteooWorkingMemory);
        if (bl) {
            LinkedList linkedList = (LinkedList)reteooWorkingMemory.getNodeMemory(this);
            linkedList.add(reteTuple);
            this.propagateAssertTuple(reteTuple, propagationContext, reteooWorkingMemory);
        }
    }

    public void retractTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        LinkedList linkedList = (LinkedList)reteooWorkingMemory.getNodeMemory(this);
        if (reteTuple.getLinkedTuples() != null && !reteTuple.getLinkedTuples().isEmpty()) {
            linkedList.remove(reteTuple);
            this.propagateRetractTuple(reteTuple, propagationContext, reteooWorkingMemory);
        }
    }

    public void modifyTuple(ReteTuple reteTuple, PropagationContext propagationContext, ReteooWorkingMemory reteooWorkingMemory) {
        boolean bl;
        boolean bl2;
        LinkedList linkedList = (LinkedList)reteooWorkingMemory.getNodeMemory(this);
        boolean bl3 = bl2 = reteTuple.getLinkedTuples() != null && !reteTuple.getLinkedTuples().isEmpty();
        if (bl2) {
            linkedList.remove(reteTuple);
        }
        if (bl = this.condition.isAllowed(reteTuple, reteooWorkingMemory)) {
            linkedList.add(reteTuple);
            if (!bl2) {
                this.propagateAssertTuple(reteTuple, propagationContext, reteooWorkingMemory);
            } else {
                this.propagateModifyTuple(reteTuple, propagationContext, reteooWorkingMemory);
            }
        } else {
            this.propagateRetractTuple(reteTuple, propagationContext, reteooWorkingMemory);
        }
    }

    public void updateNewNode(ReteooWorkingMemory reteooWorkingMemory, PropagationContext propagationContext) {
        this.attachingNewNode = true;
        LinkedList linkedList = (LinkedList)reteooWorkingMemory.getNodeMemory(this);
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ReteTuple reteTuple = (ReteTuple)iterator.next();
            ReteTuple reteTuple2 = new ReteTuple(reteTuple);
            reteTuple.addLinkedTuple(new LinkedListObjectWrapper(reteTuple2));
            ((TupleSink)this.getTupleSinks().get(this.getTupleSinks().size() - 1)).assertTuple(reteTuple2, propagationContext, reteooWorkingMemory);
        }
        this.attachingNewNode = false;
    }

    public String toString() {
        return "[ConditionNode: cond=" + this.condition + "]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != EvalConditionNode.class) {
            return false;
        }
        EvalConditionNode evalConditionNode = (EvalConditionNode)object;
        return this.tupleSource.equals(evalConditionNode.tupleSource) && this.condition.equals(evalConditionNode.condition);
    }

    public void remove(BaseNode baseNode, ReteooWorkingMemory[] reteooWorkingMemoryArray) {
        this.getTupleSinks().remove(baseNode);
        this.removeShare();
        if (this.sharedCount < 0) {
            int n = reteooWorkingMemoryArray.length;
            for (int i = 0; i < n; ++i) {
                reteooWorkingMemoryArray[i].clearNodeMemory(this);
            }
            this.tupleSource.remove(this, reteooWorkingMemoryArray);
        }
    }

    public Object createMemory(RuleBaseConfiguration ruleBaseConfiguration) {
        return new LinkedList();
    }

    public List getPropagatedTuples(ReteooWorkingMemory reteooWorkingMemory, TupleSink tupleSink) {
        LinkedList linkedList = (LinkedList)reteooWorkingMemory.getNodeMemory(this);
        int n = this.getTupleSinks().indexOf(tupleSink);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            ReteTuple reteTuple = (ReteTuple)iterator.next();
            LinkedList linkedList2 = reteTuple.getLinkedTuples();
            LinkedListObjectWrapper linkedListObjectWrapper = (LinkedListObjectWrapper)linkedList2.getFirst();
            for (int i = 0; i < n; ++i) {
                linkedListObjectWrapper = (LinkedListObjectWrapper)linkedListObjectWrapper.getNext();
            }
            arrayList.add(linkedListObjectWrapper.getObject());
        }
        return arrayList;
    }
}

