/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.scheduler.def;

import java.util.Date;
import org.dom4j.Element;
import org.jbpm.calendar.BusinessCalendar;
import org.jbpm.calendar.Duration;
import org.jbpm.graph.def.Action;
import org.jbpm.graph.def.GraphElement;
import org.jbpm.graph.exe.ExecutionContext;
import org.jbpm.jpdl.xml.JpdlXmlReader;
import org.jbpm.scheduler.SchedulerService;
import org.jbpm.scheduler.exe.Timer;
import org.jbpm.svc.Services;

public class CreateTimerAction
extends Action {
    private static final long serialVersionUID = 1L;
    static BusinessCalendar businessCalendar = new BusinessCalendar();
    String timerName = null;
    String dueDate = null;
    String repeat = null;
    String transitionName = null;
    Action timerAction = null;

    public void read(Element actionElement, JpdlXmlReader jpdlReader) {
        this.timerName = actionElement.attributeValue("name");
        this.timerAction = jpdlReader.readSingleAction(actionElement);
        this.dueDate = actionElement.attributeValue("duedate");
        if (this.dueDate == null) {
            jpdlReader.addWarning("no duedate specified in create timer action '" + actionElement + "'");
        }
        this.repeat = actionElement.attributeValue("repeat");
        if ("true".equalsIgnoreCase(this.repeat) || "yes".equalsIgnoreCase(this.repeat)) {
            this.repeat = this.dueDate;
        }
        this.transitionName = actionElement.attributeValue("transition");
    }

    public void execute(ExecutionContext executionContext) throws Exception {
        Timer timer = this.createTimer(executionContext);
        SchedulerService schedulerService = (SchedulerService)Services.getCurrentService("scheduler");
        schedulerService.createTimer(timer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Timer createTimer(ExecutionContext executionContext) {
        Timer timer = new Timer(executionContext.getToken());
        timer.setName(this.timerName);
        timer.setRepeat(this.repeat);
        if (this.dueDate != null) {
            Duration duration = new Duration(this.dueDate);
            Date dueDateDate = businessCalendar.add(new Date(), duration);
            timer.setDueDate(dueDateDate);
        }
        timer.setAction(this.timerAction);
        timer.setTransitionName(this.transitionName);
        timer.setGraphElement(executionContext.getEventSource());
        timer.setTaskInstance(executionContext.getTaskInstance());
        if (this.getEvent() != null && this.getEvent().getGraphElement() != null) {
            GraphElement graphElement = this.getEvent().getGraphElement();
            try {
                executionContext.setTimer(timer);
                graphElement.fireEvent("timer-create", executionContext);
            }
            finally {
                executionContext.setTimer(null);
            }
        }
        return timer;
    }

    public String getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(String dueDateDuration) {
        this.dueDate = dueDateDuration;
    }

    public String getRepeat() {
        return this.repeat;
    }

    public void setRepeat(String repeatDuration) {
        this.repeat = repeatDuration;
    }

    public String getTransitionName() {
        return this.transitionName;
    }

    public void setTransitionName(String transitionName) {
        this.transitionName = transitionName;
    }

    public String getTimerName() {
        return this.timerName;
    }

    public void setTimerName(String timerName) {
        this.timerName = timerName;
    }

    public Action getTimerAction() {
        return this.timerAction;
    }

    public void setTimerAction(Action timerAction) {
        this.timerAction = timerAction;
    }
}

