/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.proxy.pojo.cglib;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.CallbackFilter;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.Factory;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;
import net.sf.cglib.proxy.NoOp;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.engine.SessionImplementor;
import org.hibernate.proxy.HibernateProxy;
import org.hibernate.proxy.pojo.BasicLazyInitializer;
import org.hibernate.proxy.pojo.cglib.SerializableProxy;
import org.hibernate.type.AbstractComponentType;
import org.hibernate.util.ReflectHelper;

public final class CGLIBLazyInitializer
extends BasicLazyInitializer
implements MethodInterceptor {
    private static final Class[] CALLBACK_TYPES = new Class[]{MethodInterceptor.class, NoOp.class};
    private static final CallbackFilter FINALIZE_FILTER = new CallbackFilter(){

        public int accept(Method method) {
            if (method.getParameterTypes().length == 0 && method.getName().equals("finalize")) {
                return 1;
            }
            return 0;
        }
    };
    private Class[] interfaces;
    private boolean constructed = false;

    static HibernateProxy getProxy(String entityName, Class persistentClass, Class[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        try {
            CGLIBLazyInitializer instance = new CGLIBLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
            HibernateProxy proxy = (HibernateProxy)Enhancer.create((Class)(interfaces.length == 1 ? persistentClass : null), (Class[])interfaces, (CallbackFilter)FINALIZE_FILTER, (Callback[])new Callback[]{instance, NoOp.INSTANCE});
            instance.constructed = true;
            return proxy;
        }
        catch (Throwable t) {
            LogFactory.getLog((Class)BasicLazyInitializer.class).error((Object)("CGLIB Enhancement failed: " + entityName), t);
            throw new HibernateException("CGLIB Enhancement failed: " + entityName, t);
        }
    }

    public static HibernateProxy getProxy(Class factory, String entityName, Class persistentClass, Class[] interfaces, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, Serializable id, SessionImplementor session) throws HibernateException {
        HibernateProxy proxy;
        CGLIBLazyInitializer instance = new CGLIBLazyInitializer(entityName, persistentClass, interfaces, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
        try {
            proxy = (HibernateProxy)factory.newInstance();
        }
        catch (Exception e) {
            throw new HibernateException("CGLIB Enhancement failed: " + persistentClass.getName(), e);
        }
        ((Factory)proxy).setCallback(0, (Callback)instance);
        instance.constructed = true;
        return proxy;
    }

    public static Class getProxyFactory(Class persistentClass, Class[] interfaces) throws HibernateException {
        try {
            Enhancer en = new Enhancer();
            en.setUseCache(false);
            en.setInterceptDuringConstruction(false);
            en.setCallbackTypes(CALLBACK_TYPES);
            en.setCallbackFilter(FINALIZE_FILTER);
            en.setSuperclass(interfaces.length == 1 ? persistentClass : null);
            en.setInterfaces(interfaces);
            return en.createClass();
        }
        catch (Throwable t) {
            LogFactory.getLog((Class)BasicLazyInitializer.class).error((Object)("CGLIB Enhancement failed: " + persistentClass.getName()), t);
            throw new HibernateException("CGLIB Enhancement failed: " + persistentClass.getName(), t);
        }
    }

    private CGLIBLazyInitializer(String entityName, Class persistentClass, Class[] interfaces, Serializable id, Method getIdentifierMethod, Method setIdentifierMethod, AbstractComponentType componentIdType, SessionImplementor session) {
        super(entityName, persistentClass, id, getIdentifierMethod, setIdentifierMethod, componentIdType, session);
        this.interfaces = interfaces;
    }

    /*
     * WARNING - void declaration
     */
    public Object intercept(Object proxy, Method method, Object[] args, MethodProxy methodProxy) throws Throwable {
        if (this.constructed) {
            Object result = this.invoke(method, args, proxy);
            if (result == INVOKE_IMPLEMENTATION) {
                void var7_7;
                Object returnValue;
                Object target = this.getImplementation();
                if (ReflectHelper.isPublic(this.persistentClass, method)) {
                    returnValue = methodProxy.invoke(target, args);
                } else {
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    try {
                        returnValue = method.invoke(target, args);
                    }
                    catch (InvocationTargetException ite) {
                        throw ite.getTargetException();
                    }
                }
                return var7_7 == target ? proxy : var7_7;
            }
            return result;
        }
        if (method.getName().equals("getHibernateLazyInitializer")) {
            return this;
        }
        return methodProxy.invokeSuper(proxy, args);
    }

    protected Object serializableProxy() {
        return new SerializableProxy(this.getEntityName(), this.persistentClass, this.interfaces, this.getIdentifier(), this.getIdentifierMethod, this.setIdentifierMethod, this.componentIdType);
    }
}

