/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.event;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.ejb.event.BeanCallback;
import org.hibernate.ejb.event.Callback;
import org.hibernate.ejb.event.ListenerCallback;
import org.hibernate.reflection.ReflectionManager;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CallbackResolver {
    private static boolean useAnnotationAnnotatedByListener;
    private static Log log;

    private CallbackResolver() {
        useAnnotationAnnotatedByListener = false;
        Target target = EntityListeners.class.getAnnotation(Target.class);
        if (target != null) {
            for (ElementType type : target.value()) {
                if (!type.equals((Object)ElementType.ANNOTATION_TYPE)) continue;
                useAnnotationAnnotatedByListener = true;
            }
        }
    }

    public static Callback[] resolveCallback(XClass beanClass, Class annotation, ReflectionManager reflectionManager) {
        List defaultListeners;
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        ArrayList<String> callbacksMethodNames = new ArrayList<String>();
        ArrayList<Class> orderedListeners = new ArrayList<Class>();
        XClass currentClazz = beanClass;
        boolean stopListeners = false;
        boolean stopDefaultListeners = false;
        do {
            BeanCallback callback = null;
            List<XMethod> methods = currentClazz.getDeclaredMethods();
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                XMethod xMethod = methods.get(i);
                if (!xMethod.isAnnotationPresent(annotation)) continue;
                if (callback == null) {
                    String methodName;
                    Method method = reflectionManager.toMethod(xMethod);
                    callback = new BeanCallback(method);
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 0) {
                        throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + annotation.getName() + " - " + xMethod);
                    }
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    if (callbacksMethodNames.contains(methodName = method.getName())) continue;
                    callbacks.add(0, callback);
                    callbacksMethodNames.add(0, methodName);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + annotation.getName() + " in bean class: " + beanClass.getName());
            }
            if (!stopListeners) {
                CallbackResolver.getListeners(currentClazz, orderedListeners);
                stopListeners = currentClazz.isAnnotationPresent(ExcludeSuperclassListeners.class);
                stopDefaultListeners = currentClazz.isAnnotationPresent(ExcludeDefaultListeners.class);
            }
            while ((currentClazz = currentClazz.getSuperclass()) != null && !currentClazz.isAnnotationPresent(Entity.class) && !currentClazz.isAnnotationPresent(MappedSuperclass.class)) {
            }
        } while (currentClazz != null);
        if (!stopDefaultListeners && (defaultListeners = (List)reflectionManager.getDefaults().get(EntityListeners.class)) != null) {
            int defaultListenerSize = defaultListeners.size();
            for (int i = defaultListenerSize - 1; i >= 0; --i) {
                orderedListeners.add((Class)defaultListeners.get(i));
            }
        }
        for (Class listener : orderedListeners) {
            ListenerCallback callback = null;
            if (listener == null) continue;
            XClass xListener = reflectionManager.toXClass(listener);
            List<XMethod> methods = xListener.getDeclaredMethods();
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                XMethod xMethod = methods.get(i);
                Method method = reflectionManager.toMethod(xMethod);
                if (!xMethod.isAnnotationPresent(annotation)) continue;
                if (callback == null) {
                    try {
                        callback = new ListenerCallback(method, listener.newInstance());
                    }
                    catch (IllegalAccessException e) {
                        throw new PersistenceException("Unable to create instance of " + listener.getName() + " as a listener of beanClass", e);
                    }
                    catch (InstantiationException e) {
                        throw new PersistenceException("Unable to create instance of " + listener.getName() + " as a listener of beanClass", e);
                    }
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 1) {
                        throw new PersistenceException("Callback methods annotated in a listener bean class must return void and take one argument: " + annotation.getName() + " - " + method);
                    }
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    callbacks.add(0, callback);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + annotation.getName() + " in bean class: " + beanClass.getName() + " and callback listener: " + listener.getName());
            }
        }
        return callbacks.toArray(new Callback[callbacks.size()]);
    }

    private static void getListeners(XClass currentClazz, List<Class> orderedListeners) {
        EntityListeners entityListeners = currentClazz.getAnnotation(EntityListeners.class);
        if (entityListeners != null) {
            Class[] classes = entityListeners.value();
            int size = classes.length;
            for (int index = size - 1; index >= 0; --index) {
                orderedListeners.add(classes[index]);
            }
        }
        if (useAnnotationAnnotatedByListener) {
            Annotation[] annotations;
            for (Annotation annot : annotations = currentClazz.getAnnotations()) {
                entityListeners = annot.getClass().getAnnotation(EntityListeners.class);
                if (entityListeners == null) continue;
                Class[] classes = entityListeners.value();
                int size = classes.length;
                for (int index = size - 1; index >= 0; --index) {
                    orderedListeners.add(classes[index]);
                }
            }
        }
    }

    static {
        log = LogFactory.getLog(CallbackResolver.class);
    }
}

