/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.cglib;

import java.lang.reflect.Modifier;
import net.sf.cglib.beans.BulkBean;
import net.sf.cglib.beans.BulkBeanException;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.transform.ClassFilter;
import net.sf.cglib.transform.ClassTransformerFactory;
import net.sf.cglib.transform.TransformingClassLoader;
import net.sf.cglib.transform.impl.InterceptFieldFilter;
import net.sf.cglib.transform.impl.InterceptFieldTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.bytecode.BytecodeProvider;
import org.hibernate.bytecode.ClassTransformer;
import org.hibernate.bytecode.ProxyFactoryFactory;
import org.hibernate.bytecode.ReflectionOptimizer;
import org.hibernate.bytecode.cglib.AccessOptimizerAdapter;
import org.hibernate.bytecode.cglib.CglibClassTransformer;
import org.hibernate.bytecode.cglib.InstantiationOptimizerAdapter;
import org.hibernate.bytecode.cglib.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.cglib.ReflectionOptimizerImpl;
import org.hibernate.util.StringHelper;
import org.objectweb.asm.Type;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final Log log = LogFactory.getLog((Class)BytecodeProviderImpl.class);

    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        BulkBean bulkBean;
        FastClass fastClass;
        try {
            fastClass = FastClass.create((Class)clazz);
            bulkBean = BulkBean.create((Class)clazz, (String[])getterNames, (String[])setterNames, (Class[])types);
            if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                if (fastClass == null) {
                    bulkBean = null;
                } else {
                    Object instance = fastClass.newInstance();
                    bulkBean.setPropertyValues(instance, bulkBean.getPropertyValues(instance));
                }
            }
        }
        catch (Throwable t) {
            int index;
            fastClass = null;
            bulkBean = null;
            String message = "reflection optimizer disabled for: " + clazz.getName() + " [" + StringHelper.unqualify(t.getClass().getName()) + ": " + t.getMessage();
            if (t instanceof BulkBeanException && (index = ((BulkBeanException)t).getIndex()) >= 0) {
                message = message + " (property " + setterNames[index] + ")";
            }
            log.debug((Object)message);
        }
        if (fastClass != null && bulkBean != null) {
            return new ReflectionOptimizerImpl(new InstantiationOptimizerAdapter(fastClass), new AccessOptimizerAdapter(bulkBean, clazz));
        }
        return null;
    }

    public ClassLoader generateDynamicFieldInterceptionClassLoader(ClassLoader parent, String[] classpath, String[] packages) {
        return new TransformingClassLoader(parent, (ClassFilter)new ClassLoaderClassFilter(packages), new ClassTransformerFactory(){

            public net.sf.cglib.transform.ClassTransformer newInstance() {
                return new InterceptFieldTransformer(new InterceptFieldFilter(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public boolean acceptRead(Type owner, String name) {
                        return true;
                    }

                    public boolean acceptWrite(Type owner, String name) {
                        return true;
                    }
                });
            }
        });
    }

    public ClassTransformer getEntityClassTransformer(String[] packages, String[] classes) {
        return new CglibClassTransformer(packages, classes);
    }

    public void releaseDynamicFieldInterceptionClassLoader(ClassLoader classLoader) {
    }

    private static class ClassLoaderClassFilter
    implements ClassFilter {
        private final String[] packages;

        public ClassLoaderClassFilter(String[] packages) {
            this.packages = packages;
        }

        public boolean accept(String className) {
            if (this.packages == null) {
                return true;
            }
            for (int i = 0; i < this.packages.length; ++i) {
                if (!className.startsWith(this.packages[i])) continue;
                return true;
            }
            return false;
        }
    }
}

