//$Id: ApplicationContext.java,v 1.5 2006/11/24 23:15:17 gavin Exp $
package org.jboss.seam.core;

import static org.jboss.seam.InterceptionType.NEVER;
import static org.jboss.seam.annotations.Install.BUILT_IN;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Intercept;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Unwrap;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.contexts.Contexts;

/**
 * Support for injecting the application context
 * 
 * @author Gavin King
 */
@Scope(ScopeType.APPLICATION)
@Intercept(NEVER)
@Name("org.jboss.seam.core.applicationContext")
@Install(precedence=BUILT_IN)
public class ApplicationContext
{
   @Unwrap
   public Context getContext()
   {
      return Contexts.isApplicationContextActive() ? 
            Contexts.getApplicationContext() : null;
   }
}
