/*
 * JBoss, Home of Professional Open Source
 * Copyright 2007, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.test.ws.tools.jbws1597;

import java.io.File;
import java.io.FilenameFilter;

import org.jboss.wsf.test.JBossWSTest;
import org.jboss.test.ws.tools.fixture.JBossSourceComparator;
import org.jboss.test.ws.tools.validation.JaxrpcMappingValidator;
import org.jboss.ws.tools.WSTools;

/**
 * 
 * @author darran.lofthouse@jboss.com
 * @since 27 Apr 2007
 */
public class JBWS1597TestCase extends JBossWSTest
{

   public void testGenerateDocLitIn() throws Exception
   {
      generateScenario("doclit_in");
   }

   public void testGenerateDocLitOut() throws Exception
   {
      generateScenario("doclit_out");
   }

   public void testGenerateDocLitInOut() throws Exception
   {
      generateScenario("doclit_inout");
   }

   public void testGenerateDocLitInAndOut() throws Exception
   {
      generateScenario("doclit_in_and_out");
   }

   public void testGenerateRpcLitIn() throws Exception
   {
      generateScenario("rpclit_in");
   }

   public void testGenerateRpcLitOut() throws Exception
   {
      generateScenario("rpclit_out");
   }
   
   public void testGenerateRpcLitInOut() throws Exception
   {
      generateScenario("rpclit_inout");
   }
   
   public void testGenerateRpcLitInAndOut() throws Exception
   {
      generateScenario("rpclit_in_and_out");
   }
   
   protected void generateScenario(final String scenario) throws Exception
   {
      String resourceDir = "resources/tools/jbws1597/" + scenario;
      String toolsDir = "tools/jbws1597/" + scenario;
      String[] args = new String[] { "-dest", toolsDir, "-config", resourceDir + "/wstools-config.xml" };
      new WSTools().generate(args);
      File resourceDirFile = new File(resourceDir);
      String[] expectedFiles = resourceDirFile.list(new FilenameFilter() {
         public boolean accept(File dir, String name)
         {
            return name.endsWith(".java");
         }
      });

      for (int i = 0; i < expectedFiles.length; i++)
      {
         String currentFile = expectedFiles[i];

         try
         {
            compareSource(resourceDir + "/" + currentFile, toolsDir + "/org/jboss/test/ws/jbws1597/" + currentFile);
         }
         catch (Exception e)
         {
            throw new Exception("Validation of '" + currentFile + "' failed.", e);
         }
      }

      File packageDir = new File(toolsDir + "/org/jboss/test/ws/jbws1597");
      String[] generatedFiles = packageDir.list();
      for (int i = 0; i < generatedFiles.length; i++)
      {
         String currentFile = generatedFiles[i];

         boolean matched = "PhoneBookService.java".equals(currentFile);

         for (int j = 0; j < expectedFiles.length && (matched == false); j++)
            matched = currentFile.equals(expectedFiles[j]);

         assertTrue("File '" + currentFile + "' was not expected to be generated", matched);
      }

      JaxrpcMappingValidator mappingValidator = new JaxrpcMappingValidator();
      mappingValidator.validate(resourceDir + "/jaxrpc-mapping.xml", toolsDir + "/jaxrpc-mapping.xml");
   }

   private static void compareSource(final String expectedName, final String generatedName) throws Exception
   {
      File expected = new File(expectedName);
      File generated = new File(generatedName);

      JBossSourceComparator sc = new JBossSourceComparator(expected, generated);
      sc.validate();
      sc.validateImports();
   }

}
