package org.jbpm.scheduler.exe;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Date;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.db.AbstractDbTestCase;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.job.Timer;
import org.jbpm.persistence.db.DbPersistenceService;
import org.jbpm.persistence.db.DbPersistenceServiceFactory;
import org.jbpm.svc.Service;
import org.jbpm.svc.Services;

public class UnsafeSessionUsageTest extends AbstractDbTestCase {

  private static final long serialVersionUID = 1L;
  
  public void testTimerRepeat() {
    ProcessDefinition processDefinition = ProcessDefinition.parseXmlString(
      "<process-definition>" +
      "  <start-state>" +
      "    <transition to='a' />" +
      "  </start-state>" +
      "  <state name='a'>" +
      "    <timer name='reminder' " +
      "           duedate='0 seconds' >" +
      "      <action class='org.jbpm.scheduler.exe.TimerDbTest$NoOp' />" +
      "    </timer>" +
      "    <transition to='b'/>" +
      "    <transition name='back' to='a'/>" +
      "  </state>" +
      "  <state name='b'/>" +
      "</process-definition>"
    );
    processDefinition = saveAndReload(processDefinition);
    
    ProcessInstance processInstance = new ProcessInstance(processDefinition);
    processInstance.signal();
    
    jbpmContext.save(processInstance);

    processJobs(5000);
  }

  private static Log log = LogFactory.getLog(UnsafeSessionUsageTest.class);
}
