package org.jbpm.gd.common.notation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class AbstractNotationElement implements NotationElement {
	
	private NotationElementFactory factory;
	private Object semanticElement;
	private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

	public void setFactory(NotationElementFactory factory) {
		this.factory = factory;
	}
	
	public NotationElementFactory getFactory() {
		return factory;
	}
	
	public void setSemanticElement(Object semanticElement) {
		this.semanticElement = semanticElement;
	}
	
	public Object getSemanticElement() {
		return semanticElement;
	}

	protected void firePropertyChange(String name, Object oldValue, Object newValue) {
		propertyChangeSupport.firePropertyChange(name, oldValue, newValue);
	}
	
	public void addPropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.addPropertyChangeListener(listener);
	}
	
	public void removePropertyChangeListener(PropertyChangeListener listener) {
		propertyChangeSupport.removePropertyChangeListener(listener);
	}

	public void propertyChange(PropertyChangeEvent evt) {
	}
	
	public void register() {
		getFactory().register(this);
	}
	
	public void unregister() {
		getFactory().unregister(this);
	}
	
	public AbstractNotationElement getRegisteredNotationElementFor(Object semanticElement) {
		return getFactory().getRegisteredNotationElementFor(semanticElement);
	}
}
