package org.jbpm.gd.jpdl.xml;

import java.beans.PropertyChangeEvent;
import java.util.HashMap;
import java.util.Map;

import org.jbpm.gd.jpdl.model.Event;
import org.jbpm.gd.jpdl.model.ExceptionHandler;
import org.jbpm.gd.jpdl.model.AbstractJpdlElement;
import org.jbpm.gd.jpdl.model.JpdlElementFactory;
import org.jbpm.gd.jpdl.model.ProcessState;
import org.jbpm.gd.jpdl.model.SubProcess;
import org.jbpm.gd.jpdl.model.Timer;
import org.jbpm.gd.jpdl.model.Transition;
import org.jbpm.gd.jpdl.model.Variable;

public class ProcessStateDomAdapter extends JpdlElementDomAdapter {
	
	private static final String[] CHILD_ELEMENTS = {"sub-process", "variable", "event", "exception-handler", "timer", "transition"};
	private static HashMap NODE_TYPES = null;
	
	protected String[] getChildElements() {
		return CHILD_ELEMENTS;
	}
	
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = new HashMap();
			NODE_TYPES.put("sub-process", "sup-process");
			NODE_TYPES.put("variable", "variable");
			NODE_TYPES.put("event", "event");
			NODE_TYPES.put("exception-handler", "exception-handler");
			NODE_TYPES.put("timer", "timer");
			NODE_TYPES.put("transition", "transition");
		}
		return NODE_TYPES;
	}
	
	protected void initialize() {
		super.initialize();
		ProcessState processState = (ProcessState)getJpdlElement();
		if (processState != null) {
			setAttribute("async", processState.getAsync());
			setAttribute("name", processState.getName());
			addElements(processState.getSubProcesses());
			addElements(processState.getVariables());
			addElements(processState.getEvents());
			addElements(processState.getExceptionHandlers());
			addElements(processState.getTimers());
			addElements(processState.getTransitions());
		}
	}

	protected void initialize(AbstractJpdlElement jpdlElement) {
		super.initialize(jpdlElement);
		ProcessState processState = (ProcessState)jpdlElement;
		processState.setAsync(getAttribute("async"));
		processState.setName(getAttribute("name"));
		processState.addPropertyChangeListener(this);
	}

	public void propertyChange(PropertyChangeEvent evt) {
		if ("subProcessAdd".equals(evt.getPropertyName())) {
			addElement((SubProcess)evt.getNewValue());
		} else if ("subProcessRemove".equals(evt.getPropertyName())) {
			removeElement((SubProcess)evt.getOldValue());
		} else if ("variableAdd".equals(evt.getPropertyName())) {
			addElement((Variable)evt.getNewValue());
		} else if ("variableRemove".equals(evt.getPropertyName())) {
			removeElement((Variable)evt.getOldValue());
		} else if ("timerAdd".equals(evt.getPropertyName())) {
			addElement((Timer)evt.getNewValue());
		} else if ("timerRemove".equals(evt.getPropertyName())) {
			removeElement((Timer)evt.getOldValue());
		} else if ("transitionAdd".equals(evt.getPropertyName())) {
			addElement((Transition)evt.getNewValue());
		} else if ("transitionRemove".equals(evt.getPropertyName())) {
			removeElement((Transition)evt.getOldValue());
		} else  if ("eventAdd".equals(evt.getPropertyName())) {
			addElement((Event)evt.getNewValue());
		} else if ("eventRemove".equals(evt.getPropertyName())) {
			removeElement((Event)evt.getOldValue());
		} else if ("exceptionHandlerAdd".equals(evt.getPropertyName())) {
			addElement((ExceptionHandler)evt.getNewValue());
		} else if ("exceptionHanlderRemove".equals(evt.getPropertyName())) {
			removeElement((ExceptionHandler)evt.getOldValue());
		} else if ("async".equals(evt.getPropertyName())) {
			setAttribute("async", (String)evt.getNewValue());
		} else if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String)evt.getNewValue());
		}
	}
	
	protected void doModelUpdate(String name, String newValue) {
		ProcessState processState = (ProcessState)getJpdlElement();
		if ("name".equals(name)) {
			processState.setName(newValue);
		} else if ("async".equals(name)) {
			processState.setAsync(newValue);
		}
	}
	
	protected void doModelAdd(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		ProcessState processState = (ProcessState)getJpdlElement();
		AbstractJpdlElement jpdlElement = JpdlElementFactory.INSTANCE.createByName(type);
		child.initialize(jpdlElement);
		if ("event".equals(type)) {
			processState.addEvent((Event)jpdlElement);
		} else if ("exception-handler".equals(type)) {
			processState.addExceptionHandler((ExceptionHandler)jpdlElement);
		} else if ("timer".equals(type)) {
			processState.addTimer((Timer)jpdlElement);
		} else if ("transition".equals(type)) {
			processState.addTransition((Transition)jpdlElement);
		} else if ("variable".equals(type)) {
			processState.addVariable((Variable)jpdlElement);
		} else if ("subprocess".equals(type)) {
			processState.addSubProcess((SubProcess)jpdlElement);
		}
	}
	
	protected void doModelRemove(JpdlElementDomAdapter child) {
		String type = child.getElementType();
		ProcessState processState = (ProcessState)getJpdlElement();
		if ("event".equals(type)) {
			processState.removeEvent((Event)child.getJpdlElement());
		} else if ("exception-handler".equals(type)) {
			processState.removeExceptionHandler((ExceptionHandler)child.getJpdlElement());
		} else if ("timer".equals(type)) {
			processState.removeTimer((Timer)child.getJpdlElement());
		} else if ("transition".equals(type)) {
			processState.removeTransition((Transition)child.getJpdlElement());
		} else if ("variable".equals(type)) {
			processState.removeVariable((Variable)child.getJpdlElement());
		} else if ("subprocess".equals(type)) {
			processState.removeSubProcess((SubProcess)child.getJpdlElement());
		}
	}

}
