/*
 * JBoss, Home of Professional Open Source
 * Copyright 2005, JBoss Inc., and individual contributors as indicated
 * by the @authors tag. See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jbpm.gd.jpdl.xml;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.sse.core.internal.provisional.AbstractAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.jbpm.gd.jpdl.model.ConfigInfoElement;
import org.jbpm.gd.jpdl.model.JpdlElement;
import org.jbpm.gd.jpdl.model.JpdlExtensionRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JpdlElementDomAdapterFactory extends AbstractAdapterFactory {

	private Map adapterRegistry = new HashMap();
	
	private Document document;
	
	public JpdlElementDomAdapterFactory(Document document) {
		super();
		this.document = document;
		setAdapterKey(this);
		setShouldRegisterAdapter(true);
	}
	
	public JpdlElementDomAdapter adapt(Node node) {
		return (JpdlElementDomAdapter)super.adapt((INodeNotifier)node);
	}
	
	protected INodeAdapter createAdapter(INodeNotifier target) {
		if (document == null) throw new RuntimeException("The document property of the JpdlElementDomAdapterFactory is not initialized");
		JpdlElementDomAdapter result = null;
		try {
			IConfigurationElement element = JpdlExtensionRegistry.getConfigurationElementByName((((Node)target).getNodeName()));
			if (element != null) {
				result = (JpdlElementDomAdapter)element.createExecutableExtension("adapterClass");
			} else if (((Node)target).getNodeType() != Node.TEXT_NODE){
				result = new ConfigInfoElementDomAdapter();
			}
			if (result != null) {
				result.setNode((Node)target);
				result.setFactory(this);
			}
		} catch (CoreException e) {
			throw new RuntimeException("Creation of executable extension failed", e);
		}
		return result;
	}
	
	public JpdlElementDomAdapter createAdapterFromElementName(String elementName) {
		INodeNotifier element = (INodeNotifier)document.createElement(elementName);
		return (JpdlElementDomAdapter)adapt(element);
	}
	
	public JpdlElementDomAdapter createAdapterFromModel(JpdlElement jpdlElement) {
		String elementName = null;
		if (jpdlElement instanceof ConfigInfoElement)  {
			elementName = ((ConfigInfoElement)jpdlElement).getName();
		} else {
			String modelClassName = jpdlElement.getClass().getName();
			elementName = JpdlExtensionRegistry.getElementNameFromModelClass(modelClassName);
		}
		return elementName == null ? null : createAdapterFromElementName(elementName);
	}
	
	void register(JpdlElementDomAdapter jpdlElementDomAdapter) {
		adapterRegistry.put(jpdlElementDomAdapter.getJpdlElement(), jpdlElementDomAdapter);
	}
	
	void unregister(JpdlElementDomAdapter jpdlElementDomAdapter) {
		adapterRegistry.remove(jpdlElementDomAdapter.getJpdlElement());
	}
	
	JpdlElementDomAdapter getRegisteredAdapterFor(JpdlElement jpdlElement) {
		return (JpdlElementDomAdapter)adapterRegistry.get(jpdlElement);
	}
	
}
